/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.logging.LogFormatter;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.logging.TextLogFormatterBuilder;
import com.linecorp.armeria.common.util.TextFormatter;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

@UnstableApi
final class TextLogFormatter
implements LogFormatter {
    static final LogFormatter DEFAULT_INSTANCE = new TextLogFormatterBuilder().build();
    private final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable String> requestHeadersSanitizer;
    private final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable String> responseHeadersSanitizer;
    private final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable String> requestTrailersSanitizer;
    private final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable String> responseTrailersSanitizer;
    private final BiFunction<? super RequestContext, Object, ? extends @Nullable String> requestContentSanitizer;
    private final BiFunction<? super RequestContext, Object, ? extends @Nullable String> responseContentSanitizer;
    private final boolean includeContext;

    TextLogFormatter(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable String> requestHeadersSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable String> responseHeadersSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable String> requestTrailersSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable String> responseTrailersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable String> requestContentSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable String> responseContentSanitizer, boolean includeContext) {
        this.requestHeadersSanitizer = requestHeadersSanitizer;
        this.responseHeadersSanitizer = responseHeadersSanitizer;
        this.requestTrailersSanitizer = requestTrailersSanitizer;
        this.responseTrailersSanitizer = responseTrailersSanitizer;
        this.requestContentSanitizer = requestContentSanitizer;
        this.responseContentSanitizer = responseContentSanitizer;
        this.includeContext = includeContext;
    }

    @Override
    public String formatRequest(RequestOnlyLog log) {
        String contentPreview;
        Object content;
        Throwable cause;
        Objects.requireNonNull(log, "log");
        int flags = log.availabilityStamp();
        RequestContext ctx = log.context();
        if (!RequestLogProperty.REQUEST_START_TIME.isAvailable(flags)) {
            if (this.includeContext) {
                return ctx + " Request: {}";
            }
            return "Request: {}";
        }
        String requestCauseString = null;
        if (RequestLogProperty.REQUEST_CAUSE.isAvailable(flags) && (cause = log.requestCause()) != null) {
            requestCauseString = cause.toString();
        }
        String sanitizedHeaders = RequestLogProperty.REQUEST_HEADERS.isAvailable(flags) ? this.requestHeadersSanitizer.apply(ctx, log.requestHeaders()) : null;
        String sanitizedContent = null;
        if (RequestLogProperty.REQUEST_CONTENT.isAvailable(flags) && (content = log.requestContent()) != null) {
            sanitizedContent = this.requestContentSanitizer.apply(ctx, content);
        }
        if (sanitizedContent == null && RequestLogProperty.REQUEST_CONTENT_PREVIEW.isAvailable(flags) && (contentPreview = log.requestContentPreview()) != null) {
            sanitizedContent = this.requestContentSanitizer.apply(ctx, contentPreview);
        }
        String sanitizedTrailers = RequestLogProperty.REQUEST_TRAILERS.isAvailable(flags) && !log.requestTrailers().isEmpty() ? this.requestTrailersSanitizer.apply(ctx, log.requestTrailers()) : null;
        String ctxString = this.includeContext ? ctx.toString() + ' ' : null;
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            if (ctxString != null) {
                buf.append(ctxString);
            }
            buf.append("Request: {startTime=");
            TextFormatter.appendEpochMicros(buf, log.requestStartTimeMicros());
            if (RequestLogProperty.REQUEST_LENGTH.isAvailable(flags)) {
                buf.append(", length=");
                TextFormatter.appendSize(buf, log.requestLength());
            }
            if (RequestLogProperty.REQUEST_END_TIME.isAvailable(flags)) {
                buf.append(", duration=");
                TextFormatter.appendElapsed(buf, log.requestDurationNanos());
            }
            if (requestCauseString != null) {
                buf.append(", cause=").append(requestCauseString);
            }
            buf.append(", scheme=");
            if (RequestLogProperty.SCHEME.isAvailable(flags)) {
                buf.append(log.scheme().uriText());
            } else if (RequestLogProperty.SESSION.isAvailable(flags)) {
                buf.append(SerializationFormat.UNKNOWN.uriText()).append('+').append((Object)log.sessionProtocol());
            } else {
                buf.append(SerializationFormat.UNKNOWN.uriText()).append('+').append("unknown");
            }
            if (RequestLogProperty.NAME.isAvailable(flags)) {
                buf.append(", name=").append(log.name());
            }
            if (sanitizedHeaders != null) {
                buf.append(", headers=").append(sanitizedHeaders);
            }
            if (sanitizedContent != null) {
                buf.append(", content=").append(sanitizedContent);
            }
            if (sanitizedTrailers != null) {
                buf.append(", trailers=").append(sanitizedTrailers);
            }
            buf.append('}');
            String string = buf.toString();
            return string;
        }
    }

    @Override
    public String formatResponse(RequestLog log) {
        String contentPreview;
        Object content;
        Throwable cause;
        Objects.requireNonNull(log, "log");
        int flags = log.availabilityStamp();
        RequestContext ctx = log.context();
        if (!RequestLogProperty.RESPONSE_START_TIME.isAvailable(flags)) {
            if (this.includeContext) {
                return ctx + " Response: {}";
            }
            return "Response: {}";
        }
        String responseCauseString = null;
        if (RequestLogProperty.RESPONSE_CAUSE.isAvailable(flags) && (cause = log.responseCause()) != null) {
            responseCauseString = cause.toString();
        }
        String sanitizedHeaders = RequestLogProperty.RESPONSE_HEADERS.isAvailable(flags) ? this.responseHeadersSanitizer.apply(ctx, log.responseHeaders()) : null;
        String sanitizedContent = null;
        if (RequestLogProperty.RESPONSE_CONTENT.isAvailable(flags) && (content = log.responseContent()) != null) {
            sanitizedContent = this.responseContentSanitizer.apply(ctx, content);
        }
        if (sanitizedContent == null && RequestLogProperty.RESPONSE_CONTENT_PREVIEW.isAvailable(flags) && (contentPreview = log.responseContentPreview()) != null) {
            sanitizedContent = this.responseContentSanitizer.apply(ctx, contentPreview);
        }
        String sanitizedTrailers = RequestLogProperty.RESPONSE_TRAILERS.isAvailable(flags) && !log.responseTrailers().isEmpty() ? this.responseTrailersSanitizer.apply(ctx, log.responseTrailers()) : null;
        String ctxString = this.includeContext ? ctx.toString() + ' ' : null;
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            if (ctxString != null) {
                buf.append(ctxString);
            }
            buf.append("Response: {startTime=");
            TextFormatter.appendEpochMicros(buf, log.responseStartTimeMicros());
            if (RequestLogProperty.RESPONSE_LENGTH.isAvailable(flags)) {
                buf.append(", length=");
                TextFormatter.appendSize(buf, log.responseLength());
            }
            if (RequestLogProperty.RESPONSE_END_TIME.isAvailable(flags)) {
                buf.append(", duration=");
                TextFormatter.appendElapsed(buf, log.responseDurationNanos());
                buf.append(", totalDuration=");
                TextFormatter.appendElapsed(buf, log.totalDurationNanos());
            }
            if (responseCauseString != null) {
                buf.append(", cause=").append(responseCauseString);
            }
            if (sanitizedHeaders != null) {
                buf.append(", headers=").append(sanitizedHeaders);
            }
            if (sanitizedContent != null) {
                buf.append(", content=").append(sanitizedContent);
            }
            if (sanitizedTrailers != null) {
                buf.append(", trailers=").append(sanitizedTrailers);
            }
            buf.append('}');
            List<RequestLogAccess> children = log.children();
            int numChildren = children.size();
            if (numChildren > 1) {
                buf.append(", {totalAttempts=");
                buf.append(numChildren);
                buf.append('}');
            }
            String string = buf.toString();
            return string;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("requestHeadersSanitizer", this.requestHeadersSanitizer).add("requestContentSanitizer", this.requestContentSanitizer).add("requestTrailersSanitizer", this.requestTrailersSanitizer).add("responseHeadersSanitizer", this.responseHeadersSanitizer).add("responseContentSanitizer", this.responseContentSanitizer).add("responseTrailersSanitizer", this.responseTrailersSanitizer).toString();
    }
}

