/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.linecorp.armeria.common.AbstractHttpMessageBuilder;
import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.annotation.UnstableApi;
import java.util.Map;
import java.util.Objects;
import org.reactivestreams.Publisher;

@UnstableApi
public final class HttpResponseBuilder
extends AbstractHttpMessageBuilder {
    private final ResponseHeadersBuilder responseHeadersBuilder = ResponseHeaders.builder();

    HttpResponseBuilder() {
    }

    public HttpResponseBuilder status(int statusCode) {
        this.responseHeadersBuilder.status(HttpStatus.valueOf(statusCode));
        return this;
    }

    public HttpResponseBuilder status(HttpStatus status) {
        Objects.requireNonNull(status, "status");
        this.responseHeadersBuilder.status(status);
        return this;
    }

    public HttpResponseBuilder ok() {
        return this.status(HttpStatus.OK);
    }

    public HttpResponseBuilder created() {
        return this.status(HttpStatus.CREATED);
    }

    public HttpResponseBuilder movedPermanently() {
        return this.status(HttpStatus.MOVED_PERMANENTLY);
    }

    public HttpResponseBuilder badRequest() {
        return this.status(HttpStatus.BAD_REQUEST);
    }

    public HttpResponseBuilder unauthorized() {
        return this.status(HttpStatus.UNAUTHORIZED);
    }

    public HttpResponseBuilder forbidden() {
        return this.status(HttpStatus.FORBIDDEN);
    }

    public HttpResponseBuilder notFound() {
        return this.status(HttpStatus.NOT_FOUND);
    }

    public HttpResponseBuilder internalServerError() {
        return this.status(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public HttpResponseBuilder badGateway() {
        return this.status(HttpStatus.BAD_GATEWAY);
    }

    @Override
    public HttpResponseBuilder content(String content) {
        return (HttpResponseBuilder)super.content(content);
    }

    @Override
    public HttpResponseBuilder content(MediaType contentType, CharSequence content) {
        return (HttpResponseBuilder)super.content(contentType, content);
    }

    @Override
    public HttpResponseBuilder content(MediaType contentType, String content) {
        return (HttpResponseBuilder)super.content(contentType, content);
    }

    @Override
    @FormatMethod
    public HttpResponseBuilder content(@FormatString String format, Object ... content) {
        return (HttpResponseBuilder)super.content(format, content);
    }

    @Override
    @FormatMethod
    public HttpResponseBuilder content(MediaType contentType, @FormatString String format, Object ... content) {
        return (HttpResponseBuilder)super.content(contentType, format, content);
    }

    @Override
    public HttpResponseBuilder content(MediaType contentType, byte[] content) {
        return (HttpResponseBuilder)super.content(contentType, content);
    }

    @Override
    public HttpResponseBuilder content(MediaType contentType, HttpData content) {
        return (HttpResponseBuilder)super.content(contentType, content);
    }

    @Override
    public HttpResponseBuilder content(Publisher<? extends HttpData> content) {
        return (HttpResponseBuilder)super.content((Publisher)content);
    }

    @Override
    public HttpResponseBuilder content(MediaType contentType, Publisher<? extends HttpData> content) {
        return (HttpResponseBuilder)super.content(contentType, (Publisher)content);
    }

    @Override
    public HttpResponseBuilder contentJson(Object content) {
        return (HttpResponseBuilder)super.contentJson(content);
    }

    @Override
    public HttpResponseBuilder header(CharSequence name, Object value) {
        return (HttpResponseBuilder)super.header(name, value);
    }

    @Override
    public HttpResponseBuilder headers(Iterable<? extends Map.Entry<? extends CharSequence, String>> headers) {
        return (HttpResponseBuilder)super.headers((Iterable)headers);
    }

    @Override
    public HttpResponseBuilder trailers(Iterable<? extends Map.Entry<? extends CharSequence, String>> trailers) {
        return (HttpResponseBuilder)super.trailers((Iterable)trailers);
    }

    @Override
    public HttpResponseBuilder cookie(Cookie cookie) {
        this.responseHeadersBuilder.cookie(cookie);
        return this;
    }

    @Override
    public HttpResponseBuilder cookies(Iterable<? extends Cookie> cookies) {
        this.responseHeadersBuilder.cookies(cookies);
        return this;
    }

    @Override
    HttpHeadersBuilder headersBuilder() {
        return this.responseHeadersBuilder;
    }

    public HttpResponse build() {
        ResponseHeaders responseHeaders = this.responseHeadersBuilder.build();
        HttpHeadersBuilder trailers = this.httpTrailers();
        HttpData content = this.content();
        Publisher<? extends HttpData> publisher = this.publisher();
        if (publisher == null) {
            if (content == null) {
                content = HttpData.empty();
            }
            if (trailers == null) {
                return HttpResponse.of(responseHeaders, content);
            }
            return HttpResponse.of(responseHeaders, content, trailers.build());
        }
        if (trailers == null) {
            return HttpResponse.of(responseHeaders, publisher);
        }
        return HttpResponse.of(responseHeaders, publisher, trailers.build());
    }
}

