/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.websocket;

import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.websocket.DefaultWebSocketClient;
import com.linecorp.armeria.client.websocket.WebSocketClientBuilder;
import com.linecorp.armeria.client.websocket.WebSocketSession;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.Unwrappable;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@UnstableApi
public interface WebSocketClient
extends ClientBuilderParams,
Unwrappable {
    public static WebSocketClient of() {
        return DefaultWebSocketClient.DEFAULT;
    }

    public static WebSocketClient of(String uri) {
        return WebSocketClient.builder(uri).build();
    }

    public static WebSocketClient of(URI uri) {
        return WebSocketClient.builder(uri).build();
    }

    public static WebSocketClient of(String scheme, EndpointGroup endpointGroup) {
        return WebSocketClient.builder(scheme, endpointGroup).build();
    }

    public static WebSocketClient of(Scheme scheme, EndpointGroup endpointGroup) {
        return WebSocketClient.builder(scheme, endpointGroup).build();
    }

    public static WebSocketClient of(SessionProtocol protocol, EndpointGroup endpointGroup) {
        return WebSocketClient.builder(protocol, endpointGroup).build();
    }

    public static WebSocketClient of(String scheme, EndpointGroup endpointGroup, String path) {
        return WebSocketClient.builder(scheme, endpointGroup, path).build();
    }

    public static WebSocketClient of(Scheme scheme, EndpointGroup endpointGroup, String path) {
        return WebSocketClient.builder(scheme, endpointGroup, path).build();
    }

    public static WebSocketClient of(SessionProtocol protocol, EndpointGroup endpointGroup, String path) {
        return WebSocketClient.builder(protocol, endpointGroup, path).build();
    }

    public static WebSocketClientBuilder builder(String uri) {
        return WebSocketClient.builder(URI.create(Objects.requireNonNull(uri, "uri")));
    }

    public static WebSocketClientBuilder builder(URI uri) {
        return new WebSocketClientBuilder(Objects.requireNonNull(uri, "uri"));
    }

    public static WebSocketClientBuilder builder(String scheme, EndpointGroup endpointGroup) {
        Objects.requireNonNull(scheme, "scheme");
        return WebSocketClient.builder(Scheme.parse(scheme), endpointGroup);
    }

    public static WebSocketClientBuilder builder(Scheme scheme, EndpointGroup endpointGroup) {
        Objects.requireNonNull(scheme, "scheme");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        return new WebSocketClientBuilder(scheme, endpointGroup, null);
    }

    public static WebSocketClientBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup) {
        Objects.requireNonNull(protocol, "protocol");
        return WebSocketClient.builder(Scheme.of(SerializationFormat.WS, protocol), endpointGroup);
    }

    public static WebSocketClientBuilder builder(String scheme, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(scheme, "scheme");
        return WebSocketClient.builder(Scheme.parse(scheme), endpointGroup, path);
    }

    public static WebSocketClientBuilder builder(Scheme scheme, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(scheme, "scheme");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        return new WebSocketClientBuilder(scheme, endpointGroup, path);
    }

    public static WebSocketClientBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(protocol, "protocol");
        return WebSocketClient.builder(Scheme.of(SerializationFormat.WS, protocol), endpointGroup, path);
    }

    public CompletableFuture<WebSocketSession> connect(String var1);

    @Override
    public WebClient unwrap();
}

