/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractHttpResponseDecoder;
import com.linecorp.armeria.client.Http1ClientKeepAliveHandler;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.HttpResponseWrapper;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.ProtocolViolationException;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.metric.MoreMeters;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.InboundTrafficController;
import com.linecorp.armeria.internal.common.KeepAliveHandler;
import com.linecorp.armeria.internal.common.KeepAliveHandlerUtil;
import com.linecorp.armeria.internal.common.NoopKeepAliveHandler;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Http1ResponseDecoder
extends AbstractHttpResponseDecoder
implements ChannelInboundHandler {
    private static final Logger logger = LoggerFactory.getLogger(Http1ResponseDecoder.class);
    @Nullable
    private HttpResponseWrapper res;
    private final KeepAliveHandler keepAliveHandler;
    private int resId = 1;
    private int lastPingReqId = -1;
    private State state = State.NEED_HEADERS;

    Http1ResponseDecoder(Channel channel, HttpClientFactory clientFactory, SessionProtocol protocol) {
        super(channel, InboundTrafficController.ofHttp1(channel));
        long idleTimeoutMillis = clientFactory.idleTimeoutMillis();
        long pingIntervalMillis = clientFactory.pingIntervalMillis();
        long maxConnectionAgeMillis = clientFactory.maxConnectionAgeMillis();
        int maxNumRequestsPerConnection = clientFactory.maxNumRequestsPerConnection();
        boolean keepAliveOnPing = clientFactory.keepAliveOnPing();
        boolean needsKeepAliveHandler = KeepAliveHandlerUtil.needsKeepAliveHandler(idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis, maxNumRequestsPerConnection);
        if (needsKeepAliveHandler) {
            Timer keepAliveTimer = MoreMeters.newTimer(clientFactory.meterRegistry(), "armeria.client.connections.lifespan", ImmutableList.of(Tag.of((String)"protocol", (String)protocol.uriText())));
            this.keepAliveHandler = new Http1ClientKeepAliveHandler(channel, this, keepAliveTimer, idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis, maxNumRequestsPerConnection, keepAliveOnPing);
        } else {
            this.keepAliveHandler = new NoopKeepAliveHandler();
        }
    }

    @Override
    void onResponseAdded(int id, EventLoop eventLoop, HttpResponseWrapper resWrapper) {
        resWrapper.whenComplete().handle((unused, cause) -> {
            if (eventLoop.inEventLoop()) {
                this.onWrapperCompleted(resWrapper, (Throwable)cause);
            } else {
                eventLoop.execute(() -> this.onWrapperCompleted(resWrapper, (Throwable)cause));
            }
            return null;
        });
    }

    private void onWrapperCompleted(HttpResponseWrapper resWrapper, @Nullable Throwable cause) {
        resWrapper.onSubscriptionCancelled(cause);
        if (cause != null) {
            this.channel().close();
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.keepAliveHandler.destroy();
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        ctx.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelUnregistered();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.res != null) {
            this.res.close(ClosedSessionException.get());
        }
        this.keepAliveHandler.destroy();
        ctx.fireChannelInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof HttpObject)) {
            ctx.fireChannelRead(msg);
            return;
        }
        if (this.isPing()) {
            this.onPingRead(msg);
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        this.keepAliveHandler.onReadOrWrite();
        try {
            switch (this.state) {
                case NEED_HEADERS: {
                    boolean written;
                    HttpResponseWrapper res;
                    if (!(msg instanceof HttpResponse)) {
                        this.failWithUnexpectedMessageType(ctx, msg, HttpResponse.class);
                        return;
                    }
                    HttpResponse nettyRes = (HttpResponse)msg;
                    DecoderResult decoderResult = nettyRes.decoderResult();
                    if (!decoderResult.isSuccess()) {
                        this.fail(ctx, new ProtocolViolationException(decoderResult.cause()));
                        return;
                    }
                    if (!HttpUtil.isKeepAlive((HttpMessage)nettyRes)) {
                        this.session().deactivate();
                    }
                    if ((res = this.getResponse(this.resId)) == null && ArmeriaHttpUtil.isRequestTimeoutResponse(nettyRes)) {
                        this.close(ctx);
                        return;
                    }
                    assert (res != null);
                    this.res = res;
                    res.startResponse();
                    ResponseHeaders responseHeaders = ArmeriaHttpUtil.toArmeria(nettyRes);
                    if (responseHeaders.status().codeClass() == HttpStatusClass.INFORMATIONAL) {
                        this.state = State.NEED_INFORMATIONAL_DATA;
                        written = res.tryWrite(responseHeaders);
                    } else {
                        this.state = State.NEED_DATA_OR_TRAILERS;
                        written = res.tryWriteResponseHeaders(responseHeaders);
                    }
                    if (written) return;
                    this.fail(ctx, ClosedSessionException.get());
                    return;
                }
                case NEED_INFORMATIONAL_DATA: {
                    if (msg instanceof LastHttpContent) {
                        this.state = State.NEED_HEADERS;
                        return;
                    }
                    this.failWithUnexpectedMessageType(ctx, msg, LastHttpContent.class);
                    return;
                }
                case NEED_DATA_OR_TRAILERS: {
                    if (!(msg instanceof HttpContent)) {
                        this.failWithUnexpectedMessageType(ctx, msg, HttpContent.class);
                        return;
                    }
                    HttpContent content = (HttpContent)msg;
                    DecoderResult decoderResult = content.decoderResult();
                    if (!decoderResult.isSuccess()) {
                        this.fail(ctx, new ProtocolViolationException(decoderResult.cause()));
                        return;
                    }
                    ByteBuf data = content.content();
                    int dataLength = data.readableBytes();
                    if (dataLength > 0) {
                        assert (this.res != null);
                        long maxContentLength = this.res.maxContentLength();
                        long writtenBytes = this.res.writtenBytes();
                        if (maxContentLength > 0L && writtenBytes > maxContentLength - (long)dataLength) {
                            long transferred = LongMath.saturatedAdd(writtenBytes, dataLength);
                            this.fail(ctx, Http1ResponseDecoder.contentTooLargeException(this.res, transferred));
                            return;
                        }
                        if (!this.res.tryWriteData(HttpData.wrap(data.retain()))) {
                            this.fail(ctx, ClosedSessionException.get());
                            return;
                        }
                    }
                    if (!(msg instanceof LastHttpContent)) return;
                    HttpResponseWrapper res = this.removeResponse(this.resId++);
                    assert (res != null);
                    assert (this.res == res);
                    this.res = null;
                    this.state = State.NEED_HEADERS;
                    HttpHeaders trailingHeaders = ((LastHttpContent)msg).trailingHeaders();
                    if (!trailingHeaders.isEmpty() && !res.tryWriteTrailers(ArmeriaHttpUtil.toArmeria(trailingHeaders))) {
                        this.fail(ctx, ClosedSessionException.get());
                        return;
                    }
                    res.close();
                    if (!this.needsToDisconnectNow()) return;
                    ctx.close();
                    return;
                }
            }
            return;
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    private void failWithUnexpectedMessageType(ChannelHandlerContext ctx, Object msg, Class<?> expected) {
        String message;
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            buf.append("unexpected message type: " + msg.getClass().getName() + " (expected: " + expected.getName() + ", channel: " + ctx.channel() + ", resId: " + this.resId);
            if (this.lastPingReqId == -1) {
                buf.append(')');
            } else {
                buf.append(", lastPingReqId: " + this.lastPingReqId + ')');
            }
            message = buf.toString();
        }
        this.fail(ctx, new ProtocolViolationException(message));
    }

    private void fail(ChannelHandlerContext ctx, Throwable cause) {
        this.state = State.DISCARD;
        HttpResponseWrapper res = this.res;
        this.res = null;
        if (res != null) {
            res.close(cause);
        } else {
            logger.warn("Unexpected exception:", cause);
        }
        ctx.close();
    }

    private void close(ChannelHandlerContext ctx) {
        this.state = State.DISCARD;
        ctx.close();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelReadComplete();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        ctx.fireUserEventTriggered(evt);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelWritabilityChanged();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.fireExceptionCaught(cause);
    }

    @Override
    public KeepAliveHandler keepAliveHandler() {
        return this.keepAliveHandler;
    }

    void maybeInitializeKeepAliveHandler(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            this.keepAliveHandler.initialize(ctx);
        }
    }

    private void onPingRead(Object msg) {
        if (msg instanceof HttpResponse) {
            this.keepAliveHandler.onPing();
        }
        if (msg instanceof LastHttpContent) {
            this.onPingComplete();
        }
    }

    void setPingReqId(int id) {
        this.lastPingReqId = id;
    }

    boolean isPingReqId(int id) {
        return this.lastPingReqId == id;
    }

    private boolean isPing() {
        return this.lastPingReqId == this.resId;
    }

    private void onPingComplete() {
        this.lastPingReqId = -1;
        ++this.resId;
    }

    private static enum State {
        NEED_HEADERS,
        NEED_INFORMATIONAL_DATA,
        NEED_DATA_OR_TRAILERS,
        DISCARD;

    }
}

