/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientDecoration;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOption;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.redirect.RedirectConfig;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.AbstractOptions;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.HttpHeadersUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ClientOptions
extends AbstractOptions<ClientOption<Object>, ClientOptionValue<Object>> {
    public static final ClientOption<ClientFactory> FACTORY = ClientOption.define("FACTORY", ClientFactory.ofDefault());
    public static final ClientOption<Long> WRITE_TIMEOUT_MILLIS = ClientOption.define("WRITE_TIMEOUT_MILLIS", Flags.defaultWriteTimeoutMillis());
    public static final ClientOption<Long> RESPONSE_TIMEOUT_MILLIS = ClientOption.define("RESPONSE_TIMEOUT_MILLIS", Flags.defaultResponseTimeoutMillis());
    public static final ClientOption<Long> MAX_RESPONSE_LENGTH = ClientOption.define("MAX_RESPONSE_LENGTH", Flags.defaultMaxResponseLength());
    public static final ClientOption<Long> REQUEST_AUTO_ABORT_DELAY_MILLIS = ClientOption.define("REQUEST_AUTO_ABORT_DELAY_MILLIS", Flags.defaultRequestAutoAbortDelayMillis());
    @UnstableApi
    public static final ClientOption<Boolean> AUTO_FILL_ORIGIN_HEADER = ClientOption.define("AUTO_FILL_ORIGIN_HEADER", false);
    @UnstableApi
    public static final ClientOption<RedirectConfig> REDIRECT_CONFIG = ClientOption.define("REDIRECT_CONFIG", RedirectConfig.disabled());
    @UnstableApi
    public static final ClientOption<Consumer<ClientRequestContext>> CONTEXT_CUSTOMIZER = ClientOption.define("CONTEXT_CUSTOMIZER", ctx -> {});
    public static final ClientOption<ClientDecoration> DECORATION = ClientOption.define("DECORATION", ClientDecoration.of(), Function.identity(), (oldValue, newValue) -> {
        ClientDecoration newDecoration = (ClientDecoration)newValue.value();
        if (newDecoration.isEmpty()) {
            return oldValue;
        }
        ClientDecoration oldDecoration = (ClientDecoration)oldValue.value();
        if (oldDecoration.isEmpty()) {
            return newValue;
        }
        return (ClientOptionValue)((ClientOption)newValue.option()).newValue(ClientDecoration.builder().add(oldDecoration).add(newDecoration).build());
    });
    public static final ClientOption<Supplier<RequestId>> REQUEST_ID_GENERATOR = ClientOption.define("REQUEST_ID_GENERATOR", RequestId::random);
    public static final ClientOption<SuccessFunction> SUCCESS_FUNCTION = ClientOption.define("SUCCESS_FUNCTION", SuccessFunction.ofDefault());
    public static final ClientOption<Function<? super Endpoint, ? extends EndpointGroup>> ENDPOINT_REMAPPER = ClientOption.define("ENDPOINT_REMAPPER", Function.identity());
    private static final List<AsciiString> PROHIBITED_HEADER_NAMES = ImmutableList.of(HttpHeaderNames.HTTP2_SETTINGS, HttpHeaderNames.METHOD, HttpHeaderNames.PATH, HttpHeaderNames.SCHEME, HttpHeaderNames.STATUS, HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderNames.UPGRADE, HttpHeaderNames.KEEP_ALIVE, ArmeriaHttpUtil.HEADER_NAME_PROXY_CONNECTION, HttpConversionUtil.ExtensionHeaderNames.PATH.text(), HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), new AsciiString[]{HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text()});
    public static final ClientOption<HttpHeaders> HEADERS = ClientOption.define("HEADERS", HttpHeaders.of(), newHeaders -> {
        for (AsciiString name : PROHIBITED_HEADER_NAMES) {
            if (!newHeaders.contains((CharSequence)name)) continue;
            throw new IllegalArgumentException("prohibited header name: " + name);
        }
        boolean hasUnnormalizedCloseValue = false;
        for (String connectionOption : newHeaders.getAll((CharSequence)HttpHeaderNames.CONNECTION)) {
            if ("close".equalsIgnoreCase(connectionOption)) {
                if ("close".equals(connectionOption)) continue;
                hasUnnormalizedCloseValue = true;
                continue;
            }
            throw new IllegalArgumentException("prohibited 'Connection' header value: " + connectionOption);
        }
        if (hasUnnormalizedCloseValue) {
            return newHeaders.toBuilder().set((CharSequence)HttpHeaderNames.CONNECTION, HttpHeadersUtil.CLOSE_STRING).build();
        }
        return newHeaders;
    }, (oldValue, newValue) -> {
        HttpHeaders newHeaders = (HttpHeaders)newValue.value();
        if (newHeaders.isEmpty()) {
            return oldValue;
        }
        HttpHeaders oldHeaders = (HttpHeaders)oldValue.value();
        if (oldHeaders.isEmpty()) {
            return newValue;
        }
        return (ClientOptionValue)((ClientOption)newValue.option()).newValue(oldHeaders.toBuilder().set(newHeaders).build());
    });
    private static final ClientOptions EMPTY = new ClientOptions(ImmutableList.of());

    public static ClientOptions of() {
        return EMPTY;
    }

    public static ClientOptions of(ClientOptionValue<?> ... values) {
        Objects.requireNonNull(values, "values");
        if (values.length == 0) {
            return EMPTY;
        }
        return ClientOptions.of(Arrays.asList(values));
    }

    public static ClientOptions of(Iterable<? extends ClientOptionValue<?>> values) {
        Objects.requireNonNull(values, "values");
        if (values instanceof ClientOptions) {
            return (ClientOptions)values;
        }
        return new ClientOptions(values);
    }

    public static ClientOptions of(ClientOptions baseOptions, ClientOptionValue<?> ... additionalValues) {
        Objects.requireNonNull(baseOptions, "baseOptions");
        Objects.requireNonNull(additionalValues, "additionalValues");
        if (additionalValues.length == 0) {
            return baseOptions;
        }
        return new ClientOptions(baseOptions, (Iterable<? extends ClientOptionValue<?>>)Arrays.asList(additionalValues));
    }

    public static ClientOptions of(ClientOptions baseOptions, Iterable<? extends ClientOptionValue<?>> additionalValues) {
        Objects.requireNonNull(baseOptions, "baseOptions");
        Objects.requireNonNull(additionalValues, "additionalValues");
        return new ClientOptions(baseOptions, additionalValues);
    }

    public static ClientOptionsBuilder builder() {
        return new ClientOptionsBuilder();
    }

    private ClientOptions(Iterable<? extends ClientOptionValue<?>> values) {
        super(values);
    }

    private ClientOptions(ClientOptions baseOptions, Iterable<? extends ClientOptionValue<?>> additionalValues) {
        super(baseOptions, additionalValues);
    }

    public ClientFactory factory() {
        return (ClientFactory)this.get(FACTORY);
    }

    public long writeTimeoutMillis() {
        return (Long)this.get(WRITE_TIMEOUT_MILLIS);
    }

    public long responseTimeoutMillis() {
        return (Long)this.get(RESPONSE_TIMEOUT_MILLIS);
    }

    public long maxResponseLength() {
        return (Long)this.get(MAX_RESPONSE_LENGTH);
    }

    public long requestAutoAbortDelayMillis() {
        return (Long)this.get(REQUEST_AUTO_ABORT_DELAY_MILLIS);
    }

    @UnstableApi
    public boolean autoFillOriginHeader() {
        return (Boolean)this.get(AUTO_FILL_ORIGIN_HEADER);
    }

    @UnstableApi
    public RedirectConfig redirectConfig() {
        return (RedirectConfig)this.get(REDIRECT_CONFIG);
    }

    public ClientDecoration decoration() {
        return (ClientDecoration)this.get(DECORATION);
    }

    public HttpHeaders headers() {
        return (HttpHeaders)this.get(HEADERS);
    }

    public Supplier<RequestId> requestIdGenerator() {
        return (Supplier)this.get(REQUEST_ID_GENERATOR);
    }

    public SuccessFunction successFunction() {
        return (SuccessFunction)this.get(SUCCESS_FUNCTION);
    }

    public Function<? super Endpoint, ? extends EndpointGroup> endpointRemapper() {
        return (Function)this.get(ENDPOINT_REMAPPER);
    }

    public Consumer<ClientRequestContext> contextCustomizer() {
        return (Consumer)this.get(CONTEXT_CUSTOMIZER);
    }

    public ClientOptionsBuilder toBuilder() {
        return new ClientOptionsBuilder(this);
    }
}

