/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientFactoryOption;
import com.linecorp.armeria.client.ClientFactoryOptionValue;
import com.linecorp.armeria.client.ClientFactoryOptions;
import com.linecorp.armeria.client.ConnectionPoolListener;
import com.linecorp.armeria.client.DefaultClientFactory;
import com.linecorp.armeria.client.DefaultEventLoopScheduler;
import com.linecorp.armeria.client.DnsResolverGroupBuilder;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.EventLoopScheduler;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.IgnoreHostsTrustManager;
import com.linecorp.armeria.client.proxy.ProxyConfig;
import com.linecorp.armeria.client.proxy.ProxyConfigSelector;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.Http1HeaderNaming;
import com.linecorp.armeria.common.TlsSetters;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.EventLoopGroups;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.common.util.ChannelUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.io.ByteStreams;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;

public final class ClientFactoryBuilder
implements TlsSetters {
    private static final ClientFactoryOptionValue<Long> ZERO_PING_INTERVAL = (ClientFactoryOptionValue)ClientFactoryOptions.PING_INTERVAL_MILLIS.newValue(0L);
    static final long MIN_PING_INTERVAL_MILLIS = 1000L;
    private static final ClientFactoryOptionValue<Long> MIN_PING_INTERVAL = (ClientFactoryOptionValue)ClientFactoryOptions.PING_INTERVAL_MILLIS.newValue(1000L);
    static final long MIN_MAX_CONNECTION_AGE_MILLIS = 1000L;
    private final Map<ClientFactoryOption<?>, ClientFactoryOptionValue<?>> options = new LinkedHashMap();
    @Nullable
    private Consumer<DnsResolverGroupBuilder> dnsResolverGroupCustomizer;
    private int maxNumEventLoopsPerEndpoint;
    private int maxNumEventLoopsPerHttp1Endpoint;
    private final List<ToIntFunction<Endpoint>> maxNumEventLoopsFunctions = new ArrayList<ToIntFunction<Endpoint>>();
    private boolean tlsNoVerifySet;
    private final Set<String> insecureHosts = new HashSet<String>();

    ClientFactoryBuilder() {
        this.connectTimeoutMillis(Flags.defaultConnectTimeoutMillis());
    }

    public ClientFactoryBuilder workerGroup(EventLoopGroup workerGroup, boolean shutdownOnClose) {
        this.option(ClientFactoryOptions.WORKER_GROUP, Objects.requireNonNull(workerGroup, "workerGroup"));
        this.option(ClientFactoryOptions.SHUTDOWN_WORKER_GROUP_ON_CLOSE, shutdownOnClose);
        return this;
    }

    public ClientFactoryBuilder workerGroup(int numThreads) {
        return this.workerGroup(EventLoopGroups.newEventLoopGroup(numThreads), true);
    }

    public ClientFactoryBuilder eventLoopSchedulerFactory(Function<? super EventLoopGroup, ? extends EventLoopScheduler> eventLoopSchedulerFactory) {
        Objects.requireNonNull(eventLoopSchedulerFactory, "eventLoopSchedulerFactory");
        Preconditions.checkState(this.maxNumEventLoopsPerHttp1Endpoint == 0 && this.maxNumEventLoopsPerEndpoint == 0 && this.maxNumEventLoopsFunctions.isEmpty(), "Cannot set eventLoopSchedulerFactory when maxEventLoop per endpoint is specified.");
        this.option(ClientFactoryOptions.EVENT_LOOP_SCHEDULER_FACTORY, eventLoopSchedulerFactory);
        return this;
    }

    public ClientFactoryBuilder maxNumEventLoopsPerHttp1Endpoint(int maxNumEventLoopsPerEndpoint) {
        this.validateMaxNumEventLoopsPerEndpoint(maxNumEventLoopsPerEndpoint);
        this.maxNumEventLoopsPerHttp1Endpoint = maxNumEventLoopsPerEndpoint;
        return this;
    }

    public ClientFactoryBuilder maxNumEventLoopsPerEndpoint(int maxNumEventLoopsPerEndpoint) {
        this.validateMaxNumEventLoopsPerEndpoint(maxNumEventLoopsPerEndpoint);
        this.maxNumEventLoopsPerEndpoint = maxNumEventLoopsPerEndpoint;
        return this;
    }

    private void validateMaxNumEventLoopsPerEndpoint(int maxNumEventLoopsPerEndpoint) {
        Preconditions.checkArgument(maxNumEventLoopsPerEndpoint > 0, "maxNumEventLoopsPerEndpoint: %s (expected: > 0)", maxNumEventLoopsPerEndpoint);
        Preconditions.checkState(!this.options.containsKey(ClientFactoryOptions.EVENT_LOOP_SCHEDULER_FACTORY), "maxNumEventLoopsPerEndpoint() and eventLoopSchedulerFactory() are mutually exclusive.");
    }

    public ClientFactoryBuilder maxNumEventLoopsFunction(ToIntFunction<Endpoint> maxNumEventLoopsFunction) {
        Preconditions.checkState(!this.options.containsKey(ClientFactoryOptions.EVENT_LOOP_SCHEDULER_FACTORY), "maxNumEventLoopsPerEndpoint() and eventLoopSchedulerFactory() are mutually exclusive.");
        this.maxNumEventLoopsFunctions.add(Objects.requireNonNull(maxNumEventLoopsFunction, "maxNumEventLoopsFunction"));
        return this;
    }

    public ClientFactoryBuilder connectTimeout(Duration connectTimeout) {
        Objects.requireNonNull(connectTimeout, "connectTimeout");
        Preconditions.checkArgument(!connectTimeout.isZero() && !connectTimeout.isNegative(), "connectTimeout: %s (expected: > 0)", (Object)connectTimeout);
        return this.connectTimeoutMillis(connectTimeout.toMillis());
    }

    public ClientFactoryBuilder connectTimeoutMillis(long connectTimeoutMillis) {
        Preconditions.checkArgument(connectTimeoutMillis > 0L, "connectTimeoutMillis: %s (expected: > 0)", connectTimeoutMillis);
        return this.channelOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, Ints.saturatedCast(connectTimeoutMillis));
    }

    public <T> ClientFactoryBuilder channelOption(ChannelOption<T> option, T value) {
        Objects.requireNonNull(option, "option");
        Objects.requireNonNull(value, "value");
        this.channelOptions(ImmutableMap.of(option, value));
        return this;
    }

    private void channelOptions(Map<ChannelOption<?>, Object> newChannelOptions) {
        ClientFactoryOptionValue<?> castOptions = this.options.get(ClientFactoryOptions.CHANNEL_OPTIONS);
        if (castOptions == null) {
            this.options.put(ClientFactoryOptions.CHANNEL_OPTIONS, (ClientFactoryOptionValue)ClientFactoryOptions.CHANNEL_OPTIONS.newValue(ImmutableMap.copyOf(newChannelOptions)));
        } else {
            ImmutableMap.Builder<ChannelOption<?>, Object> builder = ImmutableMap.builderWithExpectedSize(newChannelOptions.size());
            ((Map)castOptions.value()).forEach((channelOption, value) -> {
                if (!newChannelOptions.containsKey(channelOption)) {
                    builder.put((ChannelOption<?>)channelOption, value);
                }
            });
            builder.putAll(newChannelOptions);
            this.options.put(ClientFactoryOptions.CHANNEL_OPTIONS, (ClientFactoryOptionValue)ClientFactoryOptions.CHANNEL_OPTIONS.newValue(builder.build()));
        }
    }

    public ClientFactoryBuilder tlsNoVerify() {
        Preconditions.checkState(this.insecureHosts.isEmpty(), "tlsNoVerify() and tlsNoVerifyHosts() are mutually exclusive.");
        this.tlsNoVerifySet = true;
        return this;
    }

    public ClientFactoryBuilder tlsNoVerifyHosts(String ... insecureHosts) {
        Preconditions.checkState(!this.tlsNoVerifySet, "tlsNoVerify() and tlsNoVerifyHosts() are mutually exclusive.");
        this.insecureHosts.addAll(Arrays.asList(insecureHosts));
        return this;
    }

    @Override
    public ClientFactoryBuilder tls(File keyCertChainFile, File keyFile) {
        return (ClientFactoryBuilder)TlsSetters.super.tls(keyCertChainFile, keyFile);
    }

    @Override
    public ClientFactoryBuilder tls(File keyCertChainFile, File keyFile, @Nullable String keyPassword) {
        Objects.requireNonNull(keyCertChainFile, "keyCertChainFile");
        Objects.requireNonNull(keyFile, "keyFile");
        return this.tlsCustomizer((T customizer) -> customizer.keyManager(keyCertChainFile, keyFile, keyPassword));
    }

    @Override
    public ClientFactoryBuilder tls(InputStream keyCertChainInputStream, InputStream keyInputStream) {
        return (ClientFactoryBuilder)TlsSetters.super.tls(keyCertChainInputStream, keyInputStream);
    }

    @Override
    public ClientFactoryBuilder tls(InputStream keyCertChainInputStream, InputStream keyInputStream, @Nullable String keyPassword) {
        byte[] key;
        byte[] keyCertChain;
        Objects.requireNonNull(keyCertChainInputStream, "keyCertChainInputStream");
        Objects.requireNonNull(keyInputStream, "keyInputStream");
        try {
            keyCertChain = ByteStreams.toByteArray(keyCertChainInputStream);
            key = ByteStreams.toByteArray(keyInputStream);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return this.tlsCustomizer((T customizer) -> customizer.keyManager((InputStream)new ByteArrayInputStream(keyCertChain), (InputStream)new ByteArrayInputStream(key), keyPassword));
    }

    @Override
    public ClientFactoryBuilder tls(PrivateKey key, X509Certificate ... keyCertChain) {
        return (ClientFactoryBuilder)TlsSetters.super.tls(key, keyCertChain);
    }

    @Override
    public ClientFactoryBuilder tls(PrivateKey key, Iterable<? extends X509Certificate> keyCertChain) {
        return (ClientFactoryBuilder)TlsSetters.super.tls(key, keyCertChain);
    }

    @Override
    public ClientFactoryBuilder tls(PrivateKey key, @Nullable String keyPassword, X509Certificate ... keyCertChain) {
        return (ClientFactoryBuilder)TlsSetters.super.tls(key, keyPassword, keyCertChain);
    }

    @Override
    public ClientFactoryBuilder tls(PrivateKey key, @Nullable String keyPassword, Iterable<? extends X509Certificate> keyCertChain) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(keyCertChain, "keyCertChain");
        for (X509Certificate x509Certificate : keyCertChain) {
            Objects.requireNonNull(x509Certificate, "keyCertChain contains null.");
        }
        return this.tlsCustomizer((T customizer) -> customizer.keyManager(key, keyPassword, keyCertChain));
    }

    @Override
    public ClientFactoryBuilder tls(KeyManagerFactory keyManagerFactory) {
        Objects.requireNonNull(keyManagerFactory, "keyManagerFactory");
        return this.tlsCustomizer((T customizer) -> customizer.keyManager(keyManagerFactory));
    }

    @Override
    public ClientFactoryBuilder tlsCustomizer(Consumer<? super SslContextBuilder> tlsCustomizer) {
        Consumer oldTlsCustomizer;
        Objects.requireNonNull(tlsCustomizer, "tlsCustomizer");
        ClientFactoryOptionValue<?> oldTlsCustomizerValue = this.options.get(ClientFactoryOptions.TLS_CUSTOMIZER);
        Consumer consumer = oldTlsCustomizer = oldTlsCustomizerValue == null ? (Consumer)ClientFactoryOptions.TLS_CUSTOMIZER.defaultValue() : (Consumer)oldTlsCustomizerValue.value();
        if (oldTlsCustomizer == ClientFactoryOptions.TLS_CUSTOMIZER.defaultValue()) {
            this.option(ClientFactoryOptions.TLS_CUSTOMIZER, tlsCustomizer);
        } else {
            this.option(ClientFactoryOptions.TLS_CUSTOMIZER, b -> {
                oldTlsCustomizer.accept(b);
                tlsCustomizer.accept((SslContextBuilder)b);
            });
        }
        return this;
    }

    @Deprecated
    public ClientFactoryBuilder tlsAllowUnsafeCiphers() {
        return this.tlsAllowUnsafeCiphers(true);
    }

    @Deprecated
    public ClientFactoryBuilder tlsAllowUnsafeCiphers(boolean tlsAllowUnsafeCiphers) {
        this.option(ClientFactoryOptions.TLS_ALLOW_UNSAFE_CIPHERS, tlsAllowUnsafeCiphers);
        return this;
    }

    public ClientFactoryBuilder addressResolverGroupFactory(Function<? super EventLoopGroup, ? extends AddressResolverGroup<? extends InetSocketAddress>> addressResolverGroupFactory) {
        Objects.requireNonNull(addressResolverGroupFactory, "addressResolverGroupFactory");
        Preconditions.checkState(this.dnsResolverGroupCustomizer == null, "addressResolverGroupFactory() and domainNameResolverCustomizer() are mutually exclusive.");
        this.option(ClientFactoryOptions.ADDRESS_RESOLVER_GROUP_FACTORY, addressResolverGroupFactory);
        return this;
    }

    public ClientFactoryBuilder domainNameResolverCustomizer(Consumer<? super DnsResolverGroupBuilder> dnsResolverGroupCustomizer) {
        Objects.requireNonNull(dnsResolverGroupCustomizer, "dnsResolverGroupCustomizer");
        Preconditions.checkState(!this.options.containsKey(ClientFactoryOptions.ADDRESS_RESOLVER_GROUP_FACTORY), "addressResolverGroupFactory() and domainNameResolverCustomizer() are mutually exclusive.");
        this.dnsResolverGroupCustomizer = this.dnsResolverGroupCustomizer == null ? dnsResolverGroupCustomizer : this.dnsResolverGroupCustomizer.andThen(dnsResolverGroupCustomizer);
        return this;
    }

    public ClientFactoryBuilder http2InitialConnectionWindowSize(int http2InitialConnectionWindowSize) {
        Preconditions.checkArgument(http2InitialConnectionWindowSize >= 65535, "http2InitialConnectionWindowSize: %s (expected: >= %s and <= %s)", (Object)http2InitialConnectionWindowSize, (Object)65535, (Object)Integer.MAX_VALUE);
        this.option(ClientFactoryOptions.HTTP2_INITIAL_CONNECTION_WINDOW_SIZE, http2InitialConnectionWindowSize);
        return this;
    }

    public ClientFactoryBuilder http2InitialStreamWindowSize(int http2InitialStreamWindowSize) {
        Preconditions.checkArgument(http2InitialStreamWindowSize > 0, "http2InitialStreamWindowSize: %s (expected: > 0 and <= %s)", http2InitialStreamWindowSize, Integer.MAX_VALUE);
        this.option(ClientFactoryOptions.HTTP2_INITIAL_STREAM_WINDOW_SIZE, http2InitialStreamWindowSize);
        return this;
    }

    public ClientFactoryBuilder http2MaxFrameSize(int http2MaxFrameSize) {
        Preconditions.checkArgument(http2MaxFrameSize >= 16384 && http2MaxFrameSize <= 0xFFFFFF, "http2MaxFrameSize: %s (expected: >= %s and <= %s)", (Object)http2MaxFrameSize, (Object)16384, (Object)0xFFFFFF);
        this.option(ClientFactoryOptions.HTTP2_MAX_FRAME_SIZE, http2MaxFrameSize);
        return this;
    }

    public ClientFactoryBuilder http2MaxHeaderListSize(long http2MaxHeaderListSize) {
        Preconditions.checkArgument(http2MaxHeaderListSize > 0L && http2MaxHeaderListSize <= 0xFFFFFFFFL, "http2MaxHeaderListSize: %s (expected: a positive 32-bit unsigned integer)", http2MaxHeaderListSize);
        this.option(ClientFactoryOptions.HTTP2_MAX_HEADER_LIST_SIZE, http2MaxHeaderListSize);
        return this;
    }

    public ClientFactoryBuilder http1MaxInitialLineLength(int http1MaxInitialLineLength) {
        Preconditions.checkArgument(http1MaxInitialLineLength >= 0, "http1MaxInitialLineLength: %s (expected: >= 0)", http1MaxInitialLineLength);
        this.option(ClientFactoryOptions.HTTP1_MAX_INITIAL_LINE_LENGTH, http1MaxInitialLineLength);
        return this;
    }

    public ClientFactoryBuilder http1MaxHeaderSize(int http1MaxHeaderSize) {
        Preconditions.checkArgument(http1MaxHeaderSize >= 0, "http1MaxHeaderSize: %s (expected: >= 0)", http1MaxHeaderSize);
        this.option(ClientFactoryOptions.HTTP1_MAX_HEADER_SIZE, http1MaxHeaderSize);
        return this;
    }

    public ClientFactoryBuilder http1MaxChunkSize(int http1MaxChunkSize) {
        Preconditions.checkArgument(http1MaxChunkSize >= 0, "http1MaxChunkSize: %s (expected: >= 0)", http1MaxChunkSize);
        this.option(ClientFactoryOptions.HTTP1_MAX_CHUNK_SIZE, http1MaxChunkSize);
        return this;
    }

    public ClientFactoryBuilder idleTimeout(Duration idleTimeout) {
        return this.idleTimeoutMillis(Objects.requireNonNull(idleTimeout, "idleTimeout").toMillis());
    }

    @UnstableApi
    public ClientFactoryBuilder idleTimeout(Duration idleTimeout, boolean keepAliveOnPing) {
        return this.idleTimeoutMillis(Objects.requireNonNull(idleTimeout, "idleTimeout").toMillis(), keepAliveOnPing);
    }

    public ClientFactoryBuilder idleTimeoutMillis(long idleTimeoutMillis) {
        return this.idleTimeoutMillis(idleTimeoutMillis, Flags.defaultClientKeepAliveOnPing());
    }

    @UnstableApi
    public ClientFactoryBuilder idleTimeoutMillis(long idleTimeoutMillis, boolean keepAliveOnPing) {
        Preconditions.checkArgument(idleTimeoutMillis >= 0L, "idleTimeoutMillis: %s (expected: >= 0)", idleTimeoutMillis);
        this.option(ClientFactoryOptions.IDLE_TIMEOUT_MILLIS, idleTimeoutMillis);
        this.option(ClientFactoryOptions.KEEP_ALIVE_ON_PING, keepAliveOnPing);
        return this;
    }

    public ClientFactoryBuilder pingIntervalMillis(long pingIntervalMillis) {
        Preconditions.checkArgument(pingIntervalMillis == 0L || pingIntervalMillis >= 1000L, "pingIntervalMillis: %s (expected: >= %s or == 0)", pingIntervalMillis, 1000L);
        this.option(ClientFactoryOptions.PING_INTERVAL_MILLIS, pingIntervalMillis);
        return this;
    }

    public ClientFactoryBuilder pingInterval(Duration pingInterval) {
        this.pingIntervalMillis(Objects.requireNonNull(pingInterval, "pingInterval").toMillis());
        return this;
    }

    public ClientFactoryBuilder maxConnectionAgeMillis(long maxConnectionAgeMillis) {
        Preconditions.checkArgument(maxConnectionAgeMillis >= 1000L || maxConnectionAgeMillis == 0L, "maxConnectionAgeMillis: %s (expected: >= %s or == 0)", maxConnectionAgeMillis, 1000L);
        this.option(ClientFactoryOptions.MAX_CONNECTION_AGE_MILLIS, maxConnectionAgeMillis);
        return this;
    }

    public ClientFactoryBuilder maxConnectionAge(Duration maxConnectionAge) {
        return this.maxConnectionAgeMillis(Objects.requireNonNull(maxConnectionAge, "maxConnectionAge").toMillis());
    }

    public ClientFactoryBuilder maxNumRequestsPerConnection(int maxNumRequestsPerConnection) {
        Preconditions.checkArgument(maxNumRequestsPerConnection >= 0, "maxNumRequestsPerConnection: %s (expected: >= 0)", maxNumRequestsPerConnection);
        this.option(ClientFactoryOptions.MAX_NUM_REQUESTS_PER_CONNECTION, maxNumRequestsPerConnection);
        return this;
    }

    public ClientFactoryBuilder useHttp2Preface(boolean useHttp2Preface) {
        this.option(ClientFactoryOptions.USE_HTTP2_PREFACE, useHttp2Preface);
        return this;
    }

    @UnstableApi
    public ClientFactoryBuilder useHttp2WithoutAlpn(boolean useHttp2WithoutAlpn) {
        this.option(ClientFactoryOptions.USE_HTTP2_WITHOUT_ALPN, useHttp2WithoutAlpn);
        return this;
    }

    public ClientFactoryBuilder useHttp1Pipelining(boolean useHttp1Pipelining) {
        this.option(ClientFactoryOptions.USE_HTTP1_PIPELINING, useHttp1Pipelining);
        return this;
    }

    public ClientFactoryBuilder connectionPoolListener(ConnectionPoolListener connectionPoolListener) {
        this.option(ClientFactoryOptions.CONNECTION_POOL_LISTENER, Objects.requireNonNull(connectionPoolListener, "connectionPoolListener"));
        return this;
    }

    public ClientFactoryBuilder meterRegistry(MeterRegistry meterRegistry) {
        this.option(ClientFactoryOptions.METER_REGISTRY, Objects.requireNonNull(meterRegistry, "meterRegistry"));
        return this;
    }

    public ClientFactoryBuilder proxyConfig(ProxyConfig proxyConfig) {
        Objects.requireNonNull(proxyConfig, "proxyConfig");
        this.option(ClientFactoryOptions.PROXY_CONFIG_SELECTOR, ProxyConfigSelector.of(proxyConfig));
        return this;
    }

    public ClientFactoryBuilder proxyConfig(ProxySelector proxySelector) {
        Objects.requireNonNull(proxySelector, "proxySelector");
        this.option(ClientFactoryOptions.PROXY_CONFIG_SELECTOR, ProxyConfigSelector.of(proxySelector));
        return this;
    }

    public ClientFactoryBuilder proxyConfig(ProxyConfigSelector proxyConfigSelector) {
        Objects.requireNonNull(proxyConfigSelector, "proxyConfigSelector");
        this.option(ClientFactoryOptions.PROXY_CONFIG_SELECTOR, proxyConfigSelector);
        return this;
    }

    public ClientFactoryBuilder http1HeaderNaming(Http1HeaderNaming http1HeaderNaming) {
        Objects.requireNonNull(http1HeaderNaming, "http1HeaderNaming");
        this.option(ClientFactoryOptions.HTTP1_HEADER_NAMING, http1HeaderNaming);
        return this;
    }

    public <T> ClientFactoryBuilder option(ClientFactoryOption<T> option, T value) {
        Objects.requireNonNull(option, "option");
        Objects.requireNonNull(value, "value");
        return this.option((ClientFactoryOptionValue)option.newValue(value));
    }

    public <T> ClientFactoryBuilder option(ClientFactoryOptionValue<T> optionValue) {
        Objects.requireNonNull(optionValue, "optionValue");
        if (ClientFactoryOptions.CHANNEL_OPTIONS == optionValue.option()) {
            Map channelOptions = (Map)optionValue.value();
            this.channelOptions(channelOptions);
        } else {
            this.options.put((ClientFactoryOption)optionValue.option(), optionValue);
        }
        return this;
    }

    public ClientFactoryBuilder options(ClientFactoryOptions options) {
        Objects.requireNonNull(options, "options");
        options.forEach(this::option);
        return this;
    }

    private ClientFactoryOptions buildOptions() {
        this.options.computeIfAbsent(ClientFactoryOptions.EVENT_LOOP_SCHEDULER_FACTORY, k -> {
            Function<EventLoopGroup, EventLoopScheduler> eventLoopSchedulerFactory = eventLoopGroup -> new DefaultEventLoopScheduler((EventLoopGroup)eventLoopGroup, this.maxNumEventLoopsPerEndpoint, this.maxNumEventLoopsPerHttp1Endpoint, this.maxNumEventLoopsFunctions);
            return (ClientFactoryOptionValue)ClientFactoryOptions.EVENT_LOOP_SCHEDULER_FACTORY.newValue(eventLoopSchedulerFactory);
        });
        this.options.computeIfAbsent(ClientFactoryOptions.ADDRESS_RESOLVER_GROUP_FACTORY, k -> {
            Function<EventLoopGroup, AddressResolverGroup> addressResolverGroupFactory = eventLoopGroup -> {
                if (Flags.useJdkDnsResolver() && this.dnsResolverGroupCustomizer == null) {
                    return DefaultAddressResolverGroup.INSTANCE;
                }
                DnsResolverGroupBuilder builder = new DnsResolverGroupBuilder();
                if (this.dnsResolverGroupCustomizer != null) {
                    this.dnsResolverGroupCustomizer.accept(builder);
                }
                if (builder.meterRegistry0() == null) {
                    ClientFactoryOptionValue opt = this.options.getOrDefault(ClientFactoryOptions.METER_REGISTRY, (ClientFactoryOptionValue)ClientFactoryOptions.METER_REGISTRY.newValue(ClientFactoryOptions.of().meterRegistry()));
                    builder.meterRegistry((MeterRegistry)opt.value());
                }
                return builder.build((EventLoopGroup)eventLoopGroup);
            };
            return (ClientFactoryOptionValue)ClientFactoryOptions.ADDRESS_RESOLVER_GROUP_FACTORY.newValue(addressResolverGroupFactory);
        });
        if (this.tlsNoVerifySet) {
            this.tlsCustomizer((T b) -> b.trustManager(InsecureTrustManagerFactory.INSTANCE));
        } else if (!this.insecureHosts.isEmpty()) {
            this.tlsCustomizer((T b) -> b.trustManager((TrustManager)IgnoreHostsTrustManager.of(this.insecureHosts)));
        }
        ClientFactoryOptions newOptions = ClientFactoryOptions.of(this.options.values());
        long maxConnectionAgeMillis = newOptions.maxConnectionAgeMillis();
        long idleTimeoutMillis = newOptions.idleTimeoutMillis();
        long pingIntervalMillis = newOptions.pingIntervalMillis();
        ImmutableList.Builder adjustedOptionsBuilder = ImmutableList.builderWithExpectedSize(2);
        if (maxConnectionAgeMillis != 0L && idleTimeoutMillis > maxConnectionAgeMillis) {
            adjustedOptionsBuilder.add((ClientFactoryOptionValue)ClientFactoryOptions.IDLE_TIMEOUT_MILLIS.newValue(maxConnectionAgeMillis));
            idleTimeoutMillis = maxConnectionAgeMillis;
        }
        if (idleTimeoutMillis > 0L && pingIntervalMillis > 0L) {
            long clampedPingIntervalMillis = Math.max(pingIntervalMillis, 1000L);
            if (clampedPingIntervalMillis >= idleTimeoutMillis) {
                adjustedOptionsBuilder.add(ZERO_PING_INTERVAL);
                pingIntervalMillis = 0L;
            } else if (pingIntervalMillis != 1000L && clampedPingIntervalMillis == 1000L) {
                adjustedOptionsBuilder.add(MIN_PING_INTERVAL);
                pingIntervalMillis = 1000L;
            }
        }
        Map<ChannelOption<?>, Object> newChannelOptions = ChannelUtil.applyDefaultChannelOptions(newOptions.channelOptions(), idleTimeoutMillis, pingIntervalMillis);
        adjustedOptionsBuilder.add((ClientFactoryOptionValue)ClientFactoryOptions.CHANNEL_OPTIONS.newValue(newChannelOptions));
        ImmutableCollection adjustedOptions = adjustedOptionsBuilder.build();
        if (!adjustedOptions.isEmpty()) {
            return ClientFactoryOptions.of(newOptions, adjustedOptions);
        }
        return newOptions;
    }

    public ClientFactory build() {
        return new DefaultClientFactory(new HttpClientFactory(this.buildOptions()));
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this).omitNullValues();
        helper.add("options", this.options);
        if (this.maxNumEventLoopsPerHttp1Endpoint > 0) {
            helper.add("maxNumEventLoopsPerHttp1Endpoint", this.maxNumEventLoopsPerHttp1Endpoint);
        }
        if (this.maxNumEventLoopsPerEndpoint > 0) {
            helper.add("maxNumEventLoopsPerEndpoint", this.maxNumEventLoopsPerEndpoint);
        }
        if (!this.maxNumEventLoopsFunctions.isEmpty()) {
            helper.add("maxNumEventLoopsFunctions", this.maxNumEventLoopsFunctions);
        }
        return helper.toString();
    }

    static {
        RequestContextUtil.init();
    }
}

