/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.configuration.api.ConfigTable;
import org.apache.skywalking.oap.server.configuration.api.DynamicConfigurationService;
import org.apache.skywalking.oap.server.configuration.api.GroupConfigChangeWatcher;
import org.apache.skywalking.oap.server.configuration.api.GroupConfigTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigWatcherRegister
implements DynamicConfigurationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigWatcherRegister.class);

    public abstract void start();

    protected void notifySingleValue(ConfigChangeWatcher watcher, ConfigTable.ConfigItem configItem) {
        String newItemValue = configItem.getValue();
        if (newItemValue == null) {
            if (watcher.value() != null) {
                watcher.notify(new ConfigChangeWatcher.ConfigChangeEvent(null, ConfigChangeWatcher.EventType.DELETE));
            }
        } else if (!newItemValue.equals(watcher.value())) {
            watcher.notify(new ConfigChangeWatcher.ConfigChangeEvent(newItemValue, ConfigChangeWatcher.EventType.MODIFY));
        }
    }

    protected void notifyGroupValues(GroupConfigChangeWatcher watcher, GroupConfigTable.GroupConfigItems groupConfigItems) {
        Map<String, ConfigTable.ConfigItem> groupItems = groupConfigItems.getItems();
        HashMap<String, ConfigChangeWatcher.ConfigChangeEvent> changedGroupItems = new HashMap<String, ConfigChangeWatcher.ConfigChangeEvent>();
        Map currentGroupItems = Optional.ofNullable(watcher.groupItems()).orElse(new HashMap());
        groupItems.forEach((groupItemName, groupItem) -> {
            String newItemValue = groupItem.getValue();
            if (newItemValue == null) {
                if (currentGroupItems.get(groupItemName) != null) {
                    changedGroupItems.put((String)groupItemName, new ConfigChangeWatcher.ConfigChangeEvent(null, ConfigChangeWatcher.EventType.DELETE));
                }
            } else if (!newItemValue.equals(currentGroupItems.get(groupItemName))) {
                changedGroupItems.put((String)groupItemName, new ConfigChangeWatcher.ConfigChangeEvent(newItemValue, ConfigChangeWatcher.EventType.MODIFY));
            }
        });
        currentGroupItems.forEach((oldGroupItemName, oldGroupItemValue) -> {
            if (null == groupItems.get(oldGroupItemName)) {
                changedGroupItems.put((String)oldGroupItemName, new ConfigChangeWatcher.ConfigChangeEvent(null, ConfigChangeWatcher.EventType.DELETE));
            }
        });
        if (changedGroupItems.size() > 0) {
            watcher.notifyGroup(changedGroupItems);
        }
    }

    protected static class WatcherHolder {
        private ConfigChangeWatcher watcher;
        private final String key;

        public WatcherHolder(ConfigChangeWatcher watcher) {
            this.watcher = watcher;
            this.key = String.join((CharSequence)".", watcher.getModule(), watcher.getProvider().name(), watcher.getItemName());
        }

        @Generated
        public ConfigChangeWatcher getWatcher() {
            return this.watcher;
        }

        @Generated
        public String getKey() {
            return this.key;
        }
    }
}

