/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.ebpf.provider.handler;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFOffCPUProfiling;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFOnCPUProfiling;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingData;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingServiceGrpc;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingStackMetadata;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingStackType;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingTaskMetadata;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingTaskQuery;
import org.apache.skywalking.oap.server.core.command.CommandService;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTaskRecord;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTriggerType;
import org.apache.skywalking.oap.server.core.query.enumeration.ProfilingSupportStatus;
import org.apache.skywalking.oap.server.core.query.type.Process;
import org.apache.skywalking.oap.server.core.source.EBPFProcessProfilingSchedule;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.network.trace.component.command.EBPFProfilingTaskCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBPFProfilingServiceHandler
extends EBPFProfilingServiceGrpc.EBPFProfilingServiceImplBase
implements GRPCHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EBPFProfilingServiceHandler.class);
    private static final Gson GSON = new Gson();
    public static final List<org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingStackType> COMMON_STACK_TYPE_ORDER = Arrays.asList(org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingStackType.KERNEL_SPACE, org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingStackType.USER_SPACE);
    private IEBPFProfilingTaskDAO taskDAO;
    private IMetadataQueryDAO metadataQueryDAO;
    private final SourceReceiver sourceReceiver;
    private final CommandService commandService;

    public EBPFProfilingServiceHandler(ModuleManager moduleManager) {
        this.metadataQueryDAO = (IMetadataQueryDAO)moduleManager.find("storage").provider().getService(IMetadataQueryDAO.class);
        this.taskDAO = (IEBPFProfilingTaskDAO)moduleManager.find("storage").provider().getService(IEBPFProfilingTaskDAO.class);
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        this.commandService = (CommandService)moduleManager.find("core").provider().getService(CommandService.class);
    }

    public void queryTasks(EBPFProfilingTaskQuery request, StreamObserver<Commands> responseObserver) {
        String agentId = request.getRoverInstanceId();
        long latestUpdateTime = request.getLatestUpdateTime();
        try {
            List processes = this.metadataQueryDAO.listProcesses(agentId);
            if (CollectionUtils.isEmpty((List)processes)) {
                responseObserver.onNext((Object)Commands.newBuilder().build());
                responseObserver.onCompleted();
                return;
            }
            List serviceIdList = processes.stream().map(Process::getServiceId).distinct().collect(Collectors.toList());
            List tasks = this.taskDAO.queryTasksByServices(serviceIdList, EBPFProfilingTriggerType.FIXED_TIME, 0L, latestUpdateTime);
            Commands.Builder builder = Commands.newBuilder();
            tasks.stream().collect(Collectors.toMap(EBPFProfilingTaskRecord::getLogicalId, Function.identity(), EBPFProfilingTaskRecord::combine)).values().stream().flatMap(t -> this.buildProfilingCommands((EBPFProfilingTaskRecord)t, processes).stream()).map(EBPFProfilingTaskCommand::serialize).forEach(arg_0 -> ((Commands.Builder)builder).addCommands(arg_0));
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
            return;
        }
        catch (Exception e) {
            log.warn("query ebpf process profiling task failure", (Throwable)e);
            responseObserver.onNext((Object)Commands.newBuilder().build());
            responseObserver.onCompleted();
            return;
        }
    }

    private List<EBPFProfilingTaskCommand> buildProfilingCommands(EBPFProfilingTaskRecord task, List<Process> processes) {
        if (EBPFProfilingTargetType.NETWORK.value() == task.getTargetType()) {
            List processIdList = processes.stream().filter(p -> Objects.equals(p.getInstanceId(), task.getInstanceId())).map(Process::getId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(processIdList)) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.commandService.newEBPFProfilingTaskCommand(task, processIdList));
        }
        ArrayList<EBPFProfilingTaskCommand> commands = new ArrayList<EBPFProfilingTaskCommand>(processes.size());
        for (Process process : processes) {
            if (!Objects.equals(process.getServiceId(), task.getServiceId()) || !ProfilingSupportStatus.SUPPORT_EBPF_PROFILING.name().equals(process.getProfilingSupportStatus())) continue;
            List processLabels = Collections.emptyList();
            if (StringUtil.isNotEmpty((String)task.getProcessLabelsJson())) {
                processLabels = (List)GSON.fromJson(task.getProcessLabelsJson(), ArrayList.class);
            }
            if (!CollectionUtils.isEmpty(processLabels) && !process.getLabels().containsAll(processLabels)) continue;
            commands.add(this.commandService.newEBPFProfilingTaskCommand(task, Collections.singletonList(process.getId())));
        }
        return commands;
    }

    public StreamObserver<EBPFProfilingData> collectProfilingData(final StreamObserver<Commands> responseObserver) {
        return new StreamObserver<EBPFProfilingData>(){
            private volatile boolean isFirst = true;
            private EBPFProfilingTaskMetadata task;
            private String scheduleId;

            public void onNext(EBPFProfilingData ebpfProfilingData) {
                if (this.isFirst || ebpfProfilingData.hasTask()) {
                    this.task = ebpfProfilingData.getTask();
                    EBPFProcessProfilingSchedule schedule = new EBPFProcessProfilingSchedule();
                    schedule.setProcessId(this.task.getProcessId());
                    schedule.setTaskId(this.task.getTaskId());
                    schedule.setStartTime(this.task.getProfilingStartTime());
                    schedule.setCurrentTime(this.task.getCurrentTime());
                    EBPFProfilingServiceHandler.this.sourceReceiver.receive((ISource)schedule);
                    this.scheduleId = schedule.getEntityId();
                }
                this.isFirst = false;
                org.apache.skywalking.oap.server.core.source.EBPFProfilingData data = new org.apache.skywalking.oap.server.core.source.EBPFProfilingData();
                data.setScheduleId(this.scheduleId);
                data.setTaskId(this.task.getTaskId());
                data.setUploadTime(this.task.getCurrentTime());
                switch (ebpfProfilingData.getProfilingCase()) {
                    case ONCPU: {
                        try {
                            EBPFProfilingServiceHandler.this.processOnCPUProfiling(data, ebpfProfilingData.getOnCPU());
                        }
                        catch (IOException e) {
                            log.warn("process ON_CPU profiling data failure", (Throwable)e);
                        }
                        break;
                    }
                    case OFFCPU: {
                        try {
                            EBPFProfilingServiceHandler.this.processOffCPUProfiling(data, ebpfProfilingData.getOffCPU());
                        }
                        catch (IOException e) {
                            log.warn("process OFF_CPU profiling data failure", (Throwable)e);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("the profiling data not set");
                    }
                }
                EBPFProfilingServiceHandler.this.sourceReceiver.receive((ISource)data);
            }

            public void onError(Throwable throwable) {
                Status status = Status.fromThrowable((Throwable)throwable);
                if (Status.CANCELLED.getCode() == status.getCode()) {
                    if (log.isDebugEnabled()) {
                        log.debug(throwable.getMessage(), throwable);
                    }
                    return;
                }
                log.error("Error in receiving ebpf profiling data", throwable);
            }

            public void onCompleted() {
                responseObserver.onNext((Object)Commands.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }

    private void processOnCPUProfiling(org.apache.skywalking.oap.server.core.source.EBPFProfilingData data, EBPFOnCPUProfiling onCPU) throws IOException {
        Tuple2<String, List<EBPFProfilingStackMetadata>> order = this.orderMetadataAndSetToData(onCPU.getStacksList(), COMMON_STACK_TYPE_ORDER);
        data.setStackIdList((String)order._1);
        data.setTargetType(EBPFProfilingTargetType.ON_CPU);
        data.setDataBinary(EBPFOnCPUProfiling.newBuilder().addAllStacks((Iterable)order._2).setDumpCount(onCPU.getDumpCount()).build().toByteArray());
    }

    private void processOffCPUProfiling(org.apache.skywalking.oap.server.core.source.EBPFProfilingData data, EBPFOffCPUProfiling offCPUProfiling) throws IOException {
        Tuple2<String, List<EBPFProfilingStackMetadata>> order = this.orderMetadataAndSetToData(offCPUProfiling.getStacksList(), COMMON_STACK_TYPE_ORDER);
        data.setStackIdList((String)order._1);
        data.setTargetType(EBPFProfilingTargetType.OFF_CPU);
        data.setDataBinary(EBPFOffCPUProfiling.newBuilder().addAllStacks((Iterable)order._2).setSwitchCount(offCPUProfiling.getSwitchCount()).setDuration(offCPUProfiling.getDuration()).build().toByteArray());
    }

    private Tuple2<String, List<EBPFProfilingStackMetadata>> orderMetadataAndSetToData(List<EBPFProfilingStackMetadata> original, List<org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingStackType> order) {
        HashMap tmp = new HashMap();
        original.forEach(e -> tmp.put(org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingStackType.valueOf((EBPFProfilingStackType)e.getStackType()), e));
        ArrayList<Integer> stackIdList = new ArrayList<Integer>();
        ArrayList<EBPFProfilingStackMetadata> result = new ArrayList<EBPFProfilingStackMetadata>();
        for (org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingStackType orderStack : order) {
            EBPFProfilingStackMetadata stack = (EBPFProfilingStackMetadata)tmp.get(orderStack);
            if (stack == null) continue;
            result.add(stack);
            stackIdList.add(stack.getStackId());
        }
        return Tuple.of((Object)Joiner.on((String)"_").join(stackIdList), result);
    }
}

