/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.AbstractCriteria;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.metadata.$AutoValue_TopNAggregation;
import org.apache.skywalking.banyandb.v1.client.metadata.NamedSchema;
import org.apache.skywalking.banyandb.v1.client.util.TimeUtils;

@AutoValue
public abstract class TopNAggregation
extends NamedSchema<BanyandbDatabase.TopNAggregation> {
    public abstract String sourceMeasureName();

    public abstract String fieldName();

    @Nullable
    public abstract AbstractQuery.Sort fieldValueSort();

    @Nullable
    public abstract ImmutableList<String> groupByTagNames();

    @Nullable
    abstract AbstractCriteria criteria();

    abstract int countersNumber();

    abstract int lruSize();

    abstract Builder toBuilder();

    public static Builder create(String group, String name) {
        return new $AutoValue_TopNAggregation.Builder().setGroup(group).setName(name);
    }

    @Override
    public BanyandbDatabase.TopNAggregation serialize() {
        BanyandbDatabase.TopNAggregation.Builder bld = BanyandbDatabase.TopNAggregation.newBuilder().setMetadata(this.buildMetadata());
        bld.setFieldName(this.fieldName()).setSourceMeasure(BanyandbCommon.Metadata.newBuilder().setGroup(this.group()).setName(this.sourceMeasureName()).build()).setCountersNumber(this.countersNumber()).setLruSize(this.lruSize());
        if (this.criteria() != null) {
            bld.setCriteria(this.criteria().build());
        }
        if (this.groupByTagNames() != null) {
            bld.addAllGroupByTagNames((Iterable<String>)this.groupByTagNames());
        } else {
            bld.addAllGroupByTagNames(Collections.emptyList());
        }
        if (this.fieldValueSort() == null || this.fieldValueSort() == AbstractQuery.Sort.UNSPECIFIED) {
            bld.setFieldValueSort(BanyandbModel.Sort.SORT_UNSPECIFIED);
        } else {
            bld.setFieldValueSort(AbstractQuery.Sort.DESC == this.fieldValueSort() ? BanyandbModel.Sort.SORT_DESC : BanyandbModel.Sort.SORT_ASC);
        }
        if (this.updatedAt() != null) {
            bld.setUpdatedAt(TimeUtils.buildTimestamp(this.updatedAt()));
        }
        return bld.build();
    }

    public static TopNAggregation fromProtobuf(BanyandbDatabase.TopNAggregation pb) {
        Builder bld = TopNAggregation.create(pb.getMetadata().getGroup(), pb.getMetadata().getName()).setUpdatedAt(TimeUtils.parseTimestamp(pb.getUpdatedAt())).setCountersNumber(pb.getCountersNumber()).setLruSize(pb.getLruSize()).setFieldName(pb.getFieldName()).setSourceMeasureName(pb.getSourceMeasure().getName()).setGroupByTagNames((List<String>)pb.getGroupByTagNamesList());
        switch (pb.getFieldValueSort()) {
            case SORT_ASC: {
                bld.setFieldValueSort(AbstractQuery.Sort.ASC);
                break;
            }
            case SORT_DESC: {
                bld.setFieldValueSort(AbstractQuery.Sort.DESC);
                break;
            }
            default: {
                bld.setFieldValueSort(AbstractQuery.Sort.UNSPECIFIED);
            }
        }
        return bld.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setGroup(String var1);

        abstract Builder setName(String var1);

        abstract Builder setUpdatedAt(ZonedDateTime var1);

        public abstract Builder setLruSize(int var1);

        public abstract Builder setCriteria(AbstractCriteria var1);

        public abstract Builder setFieldValueSort(AbstractQuery.Sort var1);

        public abstract Builder setFieldName(String var1);

        public abstract Builder setCountersNumber(int var1);

        public abstract Builder setGroupByTagNames(String ... var1);

        public abstract Builder setGroupByTagNames(List<String> var1);

        public abstract Builder setSourceMeasureName(String var1);

        public abstract TopNAggregation build();
    }
}

