/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.property.v1.BanyandbProperty;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;
import org.apache.skywalking.banyandb.v1.client.metadata.;
import org.apache.skywalking.banyandb.v1.client.metadata.NamedSchema;
import org.apache.skywalking.banyandb.v1.client.util.TimeUtils;

@AutoValue
public abstract class Property
extends NamedSchema<BanyandbProperty.Property> {
    public abstract String id();

    public abstract ImmutableList<TagAndValue<?>> tags();

    @Nullable
    public abstract String ttl();

    @Nullable
    public abstract Long leaseId();

    @Override
    public BanyandbProperty.Property serialize() {
        ArrayList<BanyandbModel.Tag> tags = new ArrayList<BanyandbModel.Tag>(this.tags().size());
        for (TagAndValue tagAndValue : this.tags()) {
            tags.add(tagAndValue.build());
        }
        BanyandbProperty.Property.Builder builder = BanyandbProperty.Property.newBuilder().setMetadata(BanyandbProperty.Metadata.newBuilder().setId(this.id()).setContainer(this.buildMetadata()).build()).addAllTags(tags);
        if (!Strings.isNullOrEmpty((String)this.ttl())) {
            builder.setTtl(this.ttl());
        }
        if (this.leaseId() != null) {
            builder.setLeaseId(this.leaseId());
        }
        return builder.build();
    }

    public static Builder create(String group, String name, String id) {
        return new .AutoValue_Property.Builder().setGroup(group).setName(name).setId(id);
    }

    static Property fromProtobuf(BanyandbProperty.Property pb) {
        Builder b = Property.create(pb.getMetadata().getContainer().getGroup(), pb.getMetadata().getContainer().getName(), pb.getMetadata().getId()).setUpdatedAt(TimeUtils.parseTimestamp(pb.getUpdatedAt()));
        if (!Strings.isNullOrEmpty((String)pb.getTtl())) {
            b.setTtl(pb.getTtl());
        }
        if (pb.getLeaseId() > 0L) {
            b.setLeaseId(pb.getLeaseId());
        }
        for (int i = 0; i < pb.getTagsCount(); ++i) {
            b.addTag(TagAndValue.fromProtobuf(pb.getTags(i)));
        }
        return b.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setGroup(String var1);

        abstract Builder setName(String var1);

        abstract Builder setUpdatedAt(ZonedDateTime var1);

        public abstract Builder setId(String var1);

        abstract ImmutableList.Builder<TagAndValue<?>> tagsBuilder();

        public final Builder addTag(TagAndValue<?> tagAndValue) {
            this.tagsBuilder().add(tagAndValue);
            return this;
        }

        public abstract Builder setTtl(String var1);

        abstract Builder setLeaseId(long var1);

        public abstract Property build();
    }
}

