/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import java.util.Set;
import org.apache.skywalking.banyandb.stream.v1.BanyandbStream;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.PairQueryCondition;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.MetadataCache;

public class StreamQuery
extends AbstractQuery<BanyandbStream.QueryRequest> {
    private int offset = 0;
    private int limit = 20;
    private AbstractQuery.OrderBy orderBy;

    public StreamQuery(String group, String name, TimestampRange timestampRange, Set<String> projections) {
        super(group, name, timestampRange, projections);
    }

    public StreamQuery(String group, String name, Set<String> projections) {
        this(group, name, null, projections);
    }

    public StreamQuery and(PairQueryCondition<?> condition) {
        return (StreamQuery)super.and(condition);
    }

    public StreamQuery or(PairQueryCondition<?> condition) {
        return (StreamQuery)super.or(condition);
    }

    @Override
    BanyandbStream.QueryRequest build(MetadataCache.EntityMetadata entityMetadata) throws BanyanDBException {
        if (entityMetadata == null) {
            throw new IllegalArgumentException("entity metadata is null");
        }
        BanyandbStream.QueryRequest.Builder builder = BanyandbStream.QueryRequest.newBuilder().setMetadata(this.buildMetadata());
        if (this.timestampRange != null) {
            builder.setTimeRange(this.timestampRange.build());
        }
        builder.setProjection(this.buildTagProjections(entityMetadata));
        this.buildCriteria().ifPresent(builder::setCriteria);
        builder.setOffset(this.offset);
        builder.setLimit(this.limit);
        if (this.orderBy != null) {
            builder.setOrderBy(this.orderBy.build());
        }
        return builder.build();
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setOrderBy(AbstractQuery.OrderBy orderBy) {
        this.orderBy = orderBy;
    }
}

