/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import io.grpc.stub.StreamObserver;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.stream.v1.BanyandbStream;
import org.apache.skywalking.banyandb.stream.v1.StreamServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.AbstractBulkWriteProcessor;
import org.apache.skywalking.banyandb.v1.client.BanyanDBClient;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StreamBulkWriteProcessor
extends AbstractBulkWriteProcessor<BanyandbStream.WriteRequest, StreamServiceGrpc.StreamServiceStub> {
    private static final Logger log = LoggerFactory.getLogger(StreamBulkWriteProcessor.class);
    private final BanyanDBClient client;

    protected StreamBulkWriteProcessor(BanyanDBClient client, int maxBulkSize, int flushInterval, int concurrency) {
        super(client.getStreamServiceStub(), "StreamBulkWriteProcessor", maxBulkSize, flushInterval, concurrency);
        this.client = client;
    }

    @Override
    protected StreamObserver<BanyandbStream.WriteRequest> buildStreamObserver(StreamServiceGrpc.StreamServiceStub stub, final CompletableFuture<Void> batch) {
        return stub.write(new StreamObserver<BanyandbStream.WriteResponse>(){
            private final Set<String> schemaExpired = new HashSet<String>();

            public void onNext(BanyandbStream.WriteResponse writeResponse) {
                switch (writeResponse.getStatus()) {
                    case STATUS_EXPIRED_SCHEMA: {
                        BanyandbCommon.Metadata metadata = writeResponse.getMetadata();
                        String schemaKey = metadata.getGroup() + "." + metadata.getName();
                        if (this.schemaExpired.contains(schemaKey)) break;
                        log.warn("The schema {} is expired, trying update the schema...", (Object)schemaKey);
                        try {
                            StreamBulkWriteProcessor.this.client.findStream(metadata.getGroup(), metadata.getName());
                            this.schemaExpired.add(schemaKey);
                            break;
                        }
                        catch (BanyanDBException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }

            public void onError(Throwable t) {
                batch.completeExceptionally(t);
                log.error("Error occurs in flushing streams", t);
            }

            public void onCompleted() {
                batch.complete(null);
            }
        });
    }
}

