/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.skywalking.banyandb.commons.datacarrier.DataCarrier;
import org.apache.skywalking.banyandb.commons.datacarrier.consumer.IConsumer;

public abstract class BulkWriteProcessor
implements Closeable {
    protected final int flushInterval;
    protected DataCarrier buffer;

    protected BulkWriteProcessor(String processorName, int maxBulkSize, int flushInterval, int concurrency) {
        this.flushInterval = flushInterval;
        this.buffer = new DataCarrier(processorName, maxBulkSize, concurrency);
        Properties properties = new Properties();
        properties.put("maxBulkSize", (Object)maxBulkSize);
        properties.put("flushInterval", (Object)flushInterval);
        properties.put("BulkWriteProcessor", this);
        this.buffer.consume(QueueWatcher.class, concurrency, 20L, properties);
    }

    @Override
    public void close() throws IOException {
        this.buffer.shutdownConsumers();
    }

    protected abstract void flush(List var1);

    public static class QueueWatcher
    implements IConsumer {
        private long lastFlushTimestamp;
        private int maxBulkSize;
        private int flushInterval;
        private List cachedData;
        private BulkWriteProcessor bulkWriteProcessor;

        @Override
        public void init(Properties properties) {
            this.lastFlushTimestamp = System.currentTimeMillis();
            this.maxBulkSize = (Integer)properties.get("maxBulkSize");
            this.flushInterval = (Integer)properties.get("flushInterval") * 1000;
            this.cachedData = new ArrayList(this.maxBulkSize);
            this.bulkWriteProcessor = (BulkWriteProcessor)properties.get("BulkWriteProcessor");
        }

        public void consume(List data) {
            if (data.size() >= this.maxBulkSize) {
                this.bulkWriteProcessor.flush(data);
                this.lastFlushTimestamp = System.currentTimeMillis();
            } else {
                data.forEach(element -> {
                    this.cachedData.add(element);
                    if (this.cachedData.size() >= this.maxBulkSize) {
                        this.bulkWriteProcessor.flush(this.cachedData);
                        this.cachedData = new ArrayList(this.maxBulkSize);
                        this.lastFlushTimestamp = System.currentTimeMillis();
                    }
                });
            }
        }

        public void onError(List data, Throwable t) {
        }

        @Override
        public void onExit() {
        }

        @Override
        public void nothingToConsume() {
            if (System.currentTimeMillis() - this.lastFlushTimestamp > (long)this.flushInterval) {
                this.bulkWriteProcessor.flush(this.cachedData);
                this.cachedData = new ArrayList(this.maxBulkSize);
                this.lastFlushTimestamp = System.currentTimeMillis();
            }
        }
    }
}

