/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.log.analyzer.dsl.spec.extractor;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.apm.network.logging.v3.TraceContext;
import org.apache.skywalking.oap.log.analyzer.dsl.Binding;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.AbstractSpec;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.extractor.sampledtrace.SampledTraceSpec;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.extractor.slowsql.SlowSqlSpec;
import org.apache.skywalking.oap.log.analyzer.provider.LogAnalyzerModuleConfig;
import org.apache.skywalking.oap.meter.analyzer.MetricConvert;
import org.apache.skywalking.oap.meter.analyzer.MetricRuleConfig;
import org.apache.skywalking.oap.meter.analyzer.dsl.Sample;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamily;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamilyBuilder;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.DatabaseSlowStatementBuilder;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.SampledTraceBuilder;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.ServiceMeta;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractorSpec
extends AbstractSpec {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlowSqlSpec.class);
    private final List<MetricConvert> metricConverts;
    private final SlowSqlSpec slowSql;
    private final SampledTraceSpec sampledTrace;
    private final NamingControl namingControl;
    private final SourceReceiver sourceReceiver;

    public ExtractorSpec(ModuleManager moduleManager, LogAnalyzerModuleConfig moduleConfig) throws ModuleStartException {
        super(moduleManager, moduleConfig);
        MeterSystem meterSystem = (MeterSystem)moduleManager.find("core").provider().getService(MeterSystem.class);
        this.metricConverts = moduleConfig.malConfigs().stream().map(it -> new MetricConvert((MetricRuleConfig)it, meterSystem)).collect(Collectors.toList());
        this.slowSql = new SlowSqlSpec(this.moduleManager(), this.moduleConfig());
        this.sampledTrace = new SampledTraceSpec(this.moduleManager(), this.moduleConfig());
        this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
    }

    public void service(String service) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        if (Objects.nonNull(service)) {
            ((Binding)((Object)BINDING.get())).log().setService(service);
        }
    }

    public void instance(String instance) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        if (Objects.nonNull(instance)) {
            ((Binding)((Object)BINDING.get())).log().setServiceInstance(instance);
        }
    }

    public void endpoint(String endpoint) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        if (Objects.nonNull(endpoint)) {
            ((Binding)((Object)BINDING.get())).log().setEndpoint(endpoint);
        }
    }

    public void tag(Map<String, ?> kv) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        if (CollectionUtils.isEmpty(kv)) {
            return;
        }
        LogData.Builder logData = ((Binding)((Object)BINDING.get())).log();
        logData.setTags(logData.getTags().toBuilder().addAllData((Iterable)kv.entrySet().stream().filter(it -> StringUtil.isNotBlank((String)((String)it.getKey()))).filter(it -> Objects.nonNull(it.getValue()) && StringUtil.isNotBlank((String)Objects.toString(it.getValue()))).map(it -> {
            Object val = it.getValue();
            String valStr = Objects.toString(val);
            if (Collection.class.isAssignableFrom(val.getClass())) {
                valStr = Joiner.on((String)",").skipNulls().join((Iterable)((Collection)val));
            }
            return KeyStringValuePair.newBuilder().setKey((String)it.getKey()).setValue(valStr).build();
        }).collect(Collectors.toList())));
        ((Binding)((Object)BINDING.get())).log(logData);
    }

    public void traceId(String traceId) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        if (Objects.nonNull(traceId)) {
            LogData.Builder logData = ((Binding)((Object)BINDING.get())).log();
            TraceContext.Builder traceContext = logData.getTraceContext().toBuilder();
            traceContext.setTraceId(traceId);
            logData.setTraceContext(traceContext);
        }
    }

    public void segmentId(String segmentId) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        if (Objects.nonNull(segmentId)) {
            LogData.Builder logData = ((Binding)((Object)BINDING.get())).log();
            TraceContext.Builder traceContext = logData.getTraceContext().toBuilder();
            traceContext.setTraceSegmentId(segmentId);
            logData.setTraceContext(traceContext);
        }
    }

    public void spanId(String spanId) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        if (Objects.nonNull(spanId)) {
            LogData.Builder logData = ((Binding)((Object)BINDING.get())).log();
            TraceContext.Builder traceContext = logData.getTraceContext().toBuilder();
            traceContext.setSpanId(Integer.parseInt(spanId));
            logData.setTraceContext(traceContext);
        }
    }

    public void timestamp(String timestamp) {
        this.timestamp(timestamp, null);
    }

    public void timestamp(String timestamp, String formatPattern) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        if (StringUtil.isEmpty((String)timestamp)) {
            return;
        }
        if (StringUtil.isEmpty((String)formatPattern)) {
            if (StringUtils.isNumeric((CharSequence)timestamp)) {
                ((Binding)((Object)BINDING.get())).log().setTimestamp(Long.parseLong(timestamp));
            }
        } else {
            SimpleDateFormat format = new SimpleDateFormat(formatPattern);
            try {
                ((Binding)((Object)BINDING.get())).log().setTimestamp(format.parse(timestamp).getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public void layer(String layer) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        if (Objects.nonNull(layer)) {
            LogData.Builder logData = ((Binding)((Object)BINDING.get())).log();
            logData.setLayer(layer);
        }
    }

    public void metrics(@DelegatesTo(value=SampleBuilder.class) Closure<?> cl) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        SampleBuilder builder = new SampleBuilder();
        cl.setDelegate((Object)builder);
        cl.call();
        Sample sample = builder.build();
        SampleFamily sampleFamily = SampleFamilyBuilder.newBuilder((Sample[])new Sample[]{sample}).build();
        Optional<List<SampleFamily>> possibleMetricsContainer = ((Binding)((Object)BINDING.get())).metricsContainer();
        if (possibleMetricsContainer.isPresent()) {
            possibleMetricsContainer.get().add(sampleFamily);
        } else {
            this.metricConverts.forEach(it -> it.toMeter(ImmutableMap.builder().put((Object)sample.getName(), (Object)sampleFamily).build()));
        }
    }

    public void slowSql(@DelegatesTo(value=SlowSqlSpec.class) Closure<?> cl) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        LogData.Builder log = ((Binding)((Object)BINDING.get())).log();
        if (log.getLayer() == null || log.getService() == null || log.getTimestamp() < 1L) {
            LOGGER.warn("SlowSql extracts failed, maybe something is not configured.");
            return;
        }
        DatabaseSlowStatementBuilder builder = new DatabaseSlowStatementBuilder(this.namingControl);
        builder.setLayer(Layer.nameOf((String)log.getLayer()));
        builder.setServiceName(log.getService());
        ((Binding)((Object)BINDING.get())).databaseSlowStatement(builder);
        cl.setDelegate((Object)this.slowSql);
        cl.call();
        if (builder.getId() == null || builder.getLatency() < 1L || builder.getStatement() == null) {
            LOGGER.warn("SlowSql extracts failed, maybe something is not configured.");
            return;
        }
        long timeBucketForDB = TimeBucket.getTimeBucket((long)log.getTimestamp(), (DownSampling)DownSampling.Second);
        builder.setTimeBucket(timeBucketForDB);
        builder.setTimestamp(log.getTimestamp());
        builder.prepare();
        this.sourceReceiver.receive((ISource)builder.toDatabaseSlowStatement());
        ServiceMeta serviceMeta = new ServiceMeta();
        serviceMeta.setName(builder.getServiceName());
        serviceMeta.setLayer(builder.getLayer());
        long timeBucket = TimeBucket.getTimeBucket((long)log.getTimestamp(), (DownSampling)DownSampling.Minute);
        serviceMeta.setTimeBucket(timeBucket);
        this.sourceReceiver.receive((ISource)serviceMeta);
    }

    public void sampledTrace(@DelegatesTo(value=SampledTraceSpec.class) Closure<?> cl) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        LogData.Builder log = ((Binding)((Object)BINDING.get())).log();
        SampledTraceBuilder builder = new SampledTraceBuilder(this.namingControl);
        builder.setLayer(log.getLayer());
        builder.setTimestamp(log.getTimestamp());
        builder.setServiceName(log.getService());
        builder.setServiceInstanceName(log.getServiceInstance());
        builder.setTraceId(log.getTraceContext().getTraceId());
        ((Binding)((Object)BINDING.get())).sampledTrace(builder);
        cl.setDelegate((Object)this.sampledTrace);
        cl.call();
        builder.validate();
        Record record = builder.toRecord();
        ISource entity = builder.toEntity();
        RecordStreamProcessor.getInstance().in(record);
        this.sourceReceiver.receive(entity);
    }

    public static class SampleBuilder {
        private final Sample.SampleBuilder sampleBuilder = Sample.builder();

        public Sample.SampleBuilder labels(Map<String, ?> labels) {
            Map<String, String> filtered = labels.entrySet().stream().filter(it -> StringUtil.isNotBlank((String)((String)it.getKey())) && Objects.nonNull(it.getValue())).collect(Collectors.toMap(Map.Entry::getKey, it -> Objects.toString(it.getValue())));
            return this.sampleBuilder.labels(ImmutableMap.copyOf(filtered));
        }

        @Generated
        public Sample.SampleBuilder name(String name) {
            return this.sampleBuilder.name(name);
        }

        @Generated
        public Sample.SampleBuilder labels(ImmutableMap<String, String> labels) {
            return this.sampleBuilder.labels(labels);
        }

        @Generated
        public Sample.SampleBuilder value(double value) {
            return this.sampleBuilder.value(value);
        }

        @Generated
        public Sample.SampleBuilder timestamp(long timestamp) {
            return this.sampleBuilder.timestamp(timestamp);
        }

        @Generated
        public Sample build() {
            return this.sampleBuilder.build();
        }
    }
}

