/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.Element;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.BasicTrace;
import org.apache.skywalking.oap.server.core.query.type.QueryOrder;
import org.apache.skywalking.oap.server.core.query.type.Span;
import org.apache.skywalking.oap.server.core.query.type.TraceBrief;
import org.apache.skywalking.oap.server.core.query.type.TraceState;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBTraceQueryDAO
extends AbstractBanyanDBDAO
implements ITraceQueryDAO {
    private static final Set<String> BASIC_TAGS = ImmutableSet.of((Object)"trace_id", (Object)"is_error", (Object)"service_id", (Object)"service_instance_id", (Object)"endpoint_id", (Object)"latency", (Object[])new String[]{"start_time", "tags"});
    private static final Set<String> TAGS = ImmutableSet.of((Object)"trace_id", (Object)"is_error", (Object)"service_id", (Object)"service_instance_id", (Object)"endpoint_id", (Object)"latency", (Object[])new String[]{"start_time", "segment_id", "data_binary"});

    public BanyanDBTraceQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public TraceBrief queryBasicTraces(Duration duration, final long minDuration, final long maxDuration, final String serviceId, final String serviceInstanceId, final String endpointId, String traceId, final int limit, final int from, final TraceState traceState, final QueryOrder queryOrder, final List<Tag> tags) throws IOException {
        long startSecondTB = 0L;
        long endSecondTB = 0L;
        if (Objects.nonNull(duration)) {
            startSecondTB = duration.getStartTimeBucketInSec();
            endSecondTB = duration.getEndTimeBucketInSec();
        }
        AbstractBanyanDBDAO.QueryBuilder<StreamQuery> q = new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            public void apply(StreamQuery query) {
                if (minDuration != 0L) {
                    query.and(this.gte("latency", minDuration));
                }
                if (maxDuration != 0L) {
                    query.and(this.lte("latency", maxDuration));
                }
                if (StringUtil.isNotEmpty((String)serviceId)) {
                    query.and(this.eq("service_id", serviceId));
                }
                if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
                    query.and(this.eq("service_instance_id", serviceInstanceId));
                }
                if (StringUtil.isNotEmpty((String)endpointId)) {
                    query.and(this.eq("endpoint_id", endpointId));
                }
                switch (traceState) {
                    case ERROR: {
                        query.and(this.eq("is_error", 1L));
                        break;
                    }
                    case SUCCESS: {
                        query.and(this.eq("is_error", 0L));
                    }
                }
                switch (queryOrder) {
                    case BY_START_TIME: {
                        query.setOrderBy(new AbstractQuery.OrderBy("start_time", AbstractQuery.Sort.DESC));
                        break;
                    }
                    case BY_DURATION: {
                        query.setOrderBy(new AbstractQuery.OrderBy("latency", AbstractQuery.Sort.DESC));
                    }
                }
                if (CollectionUtils.isNotEmpty((List)tags)) {
                    ArrayList<String> tagsConditions = new ArrayList<String>(tags.size());
                    for (Tag tag : tags) {
                        tagsConditions.add(tag.toString());
                    }
                    query.and(this.having("tags", tagsConditions));
                }
                query.setLimit(limit);
                query.setOffset(from);
            }
        };
        TimestampRange tsRange = null;
        if (startSecondTB > 0L && endSecondTB > 0L) {
            tsRange = new TimestampRange(TimeBucket.getTimestamp((long)startSecondTB), TimeBucket.getTimestamp((long)endSecondTB));
        }
        StreamQueryResponse resp = this.query("segment", BASIC_TAGS, tsRange, q);
        TraceBrief traceBrief = new TraceBrief();
        if (resp.size() == 0) {
            return traceBrief;
        }
        for (Element row : resp.getElements()) {
            BasicTrace basicTrace = new BasicTrace();
            basicTrace.setSegmentId(row.getId());
            basicTrace.setStart(String.valueOf((Number)row.getTagValue("start_time")));
            basicTrace.getEndpointNames().add(IDManager.EndpointID.analysisId((String)((String)row.getTagValue("endpoint_id"))).getEndpointName());
            basicTrace.setDuration(((Number)row.getTagValue("latency")).intValue());
            basicTrace.setError(BooleanUtils.valueToBoolean((int)((Number)row.getTagValue("is_error")).intValue()));
            basicTrace.getTraceIds().add((String)row.getTagValue("trace_id"));
            traceBrief.getTraces().add(basicTrace);
        }
        return traceBrief;
    }

    public List<SegmentRecord> queryByTraceId(final String traceId) throws IOException {
        StreamQueryResponse resp = this.query("segment", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            public void apply(StreamQuery query) {
                query.and(this.eq("trace_id", traceId));
            }
        });
        return this.buildRecords(resp);
    }

    public List<SegmentRecord> queryBySegmentIdList(final List<String> segmentIdList) throws IOException {
        StreamQueryResponse resp = this.query("segment", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            public void apply(StreamQuery query) {
                query.and(this.in("segment_id", segmentIdList));
            }
        });
        return this.buildRecords(resp);
    }

    public List<SegmentRecord> queryByTraceIdWithInstanceId(final List<String> traceIdList, final List<String> instanceIdList) throws IOException {
        StreamQueryResponse resp = this.query("segment", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            public void apply(StreamQuery query) {
                query.and(this.in("trace_id", traceIdList));
                query.and(this.in("service_instance_id", instanceIdList));
            }
        });
        return this.buildRecords(resp);
    }

    public List<Span> doFlexibleTraceQuery(String traceId) throws IOException {
        return Collections.emptyList();
    }

    private List<SegmentRecord> buildRecords(StreamQueryResponse resp) {
        ArrayList<SegmentRecord> segmentRecords = new ArrayList<SegmentRecord>(resp.getElements().size());
        for (RowEntity rowEntity : resp.getElements()) {
            SegmentRecord segmentRecord = new SegmentRecord.Builder().storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToStream("segment", rowEntity));
            segmentRecords.add(segmentRecord);
        }
        return segmentRecords;
    }
}

