/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.type.ProfileTask;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBProfileTaskQueryDAO
extends AbstractBanyanDBDAO
implements IProfileTaskQueryDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"service_id", (Object)"endpoint_name", (Object)"task_id", (Object)"start_time", (Object)"create_time", (Object)"duration", (Object[])new String[]{"min_duration_threshold", "dump_period", "max_sampling_count"});
    private final int queryMaxSize;

    public BanyanDBProfileTaskQueryDAO(BanyanDBStorageClient client, int queryMaxSize) {
        super(client);
        this.queryMaxSize = queryMaxSize;
    }

    public List<ProfileTask> getTaskList(final String serviceId, final String endpointName, final Long startTimeBucket, final Long endTimeBucket, final Integer limit) throws IOException {
        StreamQueryResponse resp = this.query("profile_task", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                if (StringUtil.isNotEmpty((String)serviceId)) {
                    query.and(this.eq("service_id", serviceId));
                }
                if (StringUtil.isNotEmpty((String)endpointName)) {
                    query.and(this.eq("endpoint_name", endpointName));
                }
                if (startTimeBucket != null) {
                    query.and(this.gte("start_time", TimeBucket.getTimestamp((long)startTimeBucket)));
                }
                if (endTimeBucket != null) {
                    query.and(this.lte("start_time", TimeBucket.getTimestamp((long)endTimeBucket)));
                }
                if (limit != null) {
                    query.setLimit(limit.intValue());
                } else {
                    query.setLimit(BanyanDBProfileTaskQueryDAO.this.queryMaxSize);
                }
                query.setOrderBy(new AbstractQuery.OrderBy("start_time", AbstractQuery.Sort.DESC));
            }
        });
        if (resp.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ProfileTask> profileTasks = new ArrayList<ProfileTask>(resp.size());
        for (RowEntity entity : resp.getElements()) {
            profileTasks.add(this.buildProfileTask(entity));
        }
        return profileTasks;
    }

    public ProfileTask getById(final String id) throws IOException {
        StreamQueryResponse resp = this.query("profile_task", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                if (StringUtil.isNotEmpty((String)id)) {
                    query.and(this.eq("task_id", id));
                }
                query.setLimit(1);
            }
        });
        if (resp.size() == 0) {
            return null;
        }
        return this.buildProfileTask((RowEntity)resp.getElements().get(0));
    }

    private ProfileTask buildProfileTask(RowEntity data) {
        return ProfileTask.builder().id((String)data.getTagValue("task_id")).serviceId((String)data.getTagValue("service_id")).endpointName((String)data.getTagValue("endpoint_name")).startTime(((Number)data.getTagValue("start_time")).longValue()).createTime(((Number)data.getTagValue("create_time")).longValue()).duration(((Number)data.getTagValue("duration")).intValue()).minDurationThreshold(((Number)data.getTagValue("min_duration_threshold")).intValue()).dumpPeriod(((Number)data.getTagValue("dump_period")).intValue()).maxSamplingCount(((Number)data.getTagValue("max_sampling_count")).intValue()).build();
    }
}

