/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.protobuf.GeneratedMessageV3;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.AbstractCriteria;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.And;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.Or;
import org.apache.skywalking.banyandb.v1.client.PairQueryCondition;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.banyandb.v1.client.TopNQuery;
import org.apache.skywalking.banyandb.v1.client.TopNQueryResponse;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.storage.AbstractDAO;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;

public abstract class AbstractBanyanDBDAO
extends AbstractDAO<BanyanDBStorageClient> {
    private static final Instant UPPER_BOUND = Instant.ofEpochSecond(0L, Long.MAX_VALUE);
    private static final TimestampRange LARGEST_TIME_RANGE = new TimestampRange(0L, UPPER_BOUND.toEpochMilli());

    protected AbstractBanyanDBDAO(BanyanDBStorageClient client) {
        super((Client)client);
    }

    protected StreamQueryResponse query(String streamModelName, Set<String> tags, QueryBuilder<StreamQuery> builder) throws IOException {
        return this.query(streamModelName, tags, (TimestampRange)null, builder);
    }

    protected StreamQueryResponse query(String streamModelName, Set<String> tags, TimestampRange timestampRange, QueryBuilder<StreamQuery> builder) throws IOException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findRecordMetadata(streamModelName);
        if (schema == null) {
            throw new IllegalArgumentException("schema is not registered");
        }
        StreamQuery query = timestampRange == null ? new StreamQuery(schema.getMetadata().getGroup(), schema.getMetadata().name(), LARGEST_TIME_RANGE, tags) : new StreamQuery(schema.getMetadata().getGroup(), schema.getMetadata().name(), timestampRange, tags);
        builder.apply(query);
        return ((BanyanDBStorageClient)this.getClient()).query(query);
    }

    protected MeasureQueryResponse query(String measureModelName, Set<String> tags, Set<String> fields, QueryBuilder<MeasureQuery> builder) throws IOException {
        return this.query(measureModelName, tags, fields, null, builder);
    }

    protected TopNQueryResponse topN(MetadataRegistry.Schema schema, TimestampRange timestampRange, int number, List<KeyValue> additionalConditions) throws IOException {
        return this.topNQuery(schema, timestampRange, number, AbstractQuery.Sort.DESC, additionalConditions);
    }

    protected TopNQueryResponse bottomN(MetadataRegistry.Schema schema, TimestampRange timestampRange, int number, List<KeyValue> additionalConditions) throws IOException {
        return this.topNQuery(schema, timestampRange, number, AbstractQuery.Sort.ASC, additionalConditions);
    }

    private TopNQueryResponse topNQuery(MetadataRegistry.Schema schema, TimestampRange timestampRange, int number, AbstractQuery.Sort sort, List<KeyValue> additionalConditions) throws IOException {
        TopNQuery q = new TopNQuery(schema.getMetadata().getGroup(), schema.getTopNSpec().getName(), timestampRange, number, sort);
        q.setAggregationType(MeasureQuery.Aggregation.Type.MEAN);
        if (CollectionUtils.isNotEmpty(additionalConditions)) {
            ArrayList<PairQueryCondition> conditions = new ArrayList<PairQueryCondition>(additionalConditions.size());
            for (KeyValue kv : additionalConditions) {
                conditions.add(PairQueryCondition.StringQueryCondition.eq((String)kv.getKey(), (String)kv.getValue()));
            }
            q.setConditions(conditions);
        }
        return ((BanyanDBStorageClient)this.getClient()).query(q);
    }

    protected MeasureQueryResponse query(String measureModelName, Set<String> tags, Set<String> fields, TimestampRange timestampRange, QueryBuilder<MeasureQuery> builder) throws IOException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(measureModelName, DownSampling.Minute);
        if (schema == null) {
            throw new IllegalArgumentException("measure is not registered");
        }
        return this.query(schema, tags, fields, timestampRange, builder);
    }

    protected MeasureQueryResponse query(MetadataRegistry.Schema schema, Set<String> tags, Set<String> fields, TimestampRange timestampRange, QueryBuilder<MeasureQuery> builder) throws IOException {
        MeasureQuery query = timestampRange == null ? new MeasureQuery(schema.getMetadata().getGroup(), schema.getMetadata().name(), LARGEST_TIME_RANGE, tags, fields) : new MeasureQuery(schema.getMetadata().getGroup(), schema.getMetadata().name(), timestampRange, tags, fields);
        builder.apply(query);
        return ((BanyanDBStorageClient)this.getClient()).query(query);
    }

    protected static QueryBuilder<MeasureQuery> emptyMeasureQuery() {
        return new QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
            }
        };
    }

    protected static abstract class QueryBuilder<T extends AbstractQuery<? extends GeneratedMessageV3>> {
        protected QueryBuilder() {
        }

        protected abstract void apply(T var1);

        protected PairQueryCondition<Long> eq(String name, long value) {
            return PairQueryCondition.LongQueryCondition.eq((String)name, (Long)value);
        }

        protected PairQueryCondition<List<String>> having(String name, List<String> value) {
            return PairQueryCondition.StringArrayQueryCondition.having((String)name, value);
        }

        protected PairQueryCondition<Long> lte(String name, long value) {
            return PairQueryCondition.LongQueryCondition.le((String)name, (Long)value);
        }

        protected PairQueryCondition<Long> gte(String name, long value) {
            return PairQueryCondition.LongQueryCondition.ge((String)name, (Long)value);
        }

        protected PairQueryCondition<Long> gt(String name, long value) {
            return PairQueryCondition.LongQueryCondition.gt((String)name, (Long)value);
        }

        protected PairQueryCondition<String> eq(String name, String value) {
            return PairQueryCondition.StringQueryCondition.eq((String)name, (String)value);
        }

        protected PairQueryCondition<List<String>> in(String name, List<String> values) {
            return PairQueryCondition.StringArrayQueryCondition.in((String)name, values);
        }

        protected PairQueryCondition<List<String>> notIn(String name, List<String> values) {
            return PairQueryCondition.StringArrayQueryCondition.in((String)name, values);
        }

        protected PairQueryCondition<Long> ne(String name, long value) {
            return PairQueryCondition.LongQueryCondition.ne((String)name, (Long)value);
        }

        protected AbstractQuery.OrderBy desc(String name) {
            return new AbstractQuery.OrderBy(name, AbstractQuery.Sort.DESC);
        }

        protected AbstractQuery.OrderBy asc(String name) {
            return new AbstractQuery.OrderBy(name, AbstractQuery.Sort.ASC);
        }

        protected AbstractCriteria and(List<? extends AbstractCriteria> conditions) {
            if (conditions.isEmpty()) {
                return null;
            }
            if (conditions.size() == 1) {
                return conditions.get(0);
            }
            return conditions.subList(2, conditions.size()).stream().reduce(And.create((AbstractCriteria)conditions.get(0), (AbstractCriteria)conditions.get(1)), And::create, And::create);
        }

        protected AbstractCriteria or(List<? extends AbstractCriteria> conditions) {
            if (conditions.isEmpty()) {
                return null;
            }
            if (conditions.size() == 1) {
                return conditions.get(0);
            }
            return conditions.subList(2, conditions.size()).stream().reduce(Or.create((AbstractCriteria)conditions.get(0), (AbstractCriteria)conditions.get(1)), Or::create, Or::create);
        }
    }
}

