/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import io.grpc.Status;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.BanyanDBClient;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.Catalog;
import org.apache.skywalking.banyandb.v1.client.metadata.Duration;
import org.apache.skywalking.banyandb.v1.client.metadata.Group;
import org.apache.skywalking.banyandb.v1.client.metadata.IndexRule;
import org.apache.skywalking.banyandb.v1.client.metadata.IntervalRule;
import org.apache.skywalking.banyandb.v1.client.metadata.Measure;
import org.apache.skywalking.banyandb.v1.client.metadata.NamedSchema;
import org.apache.skywalking.banyandb.v1.client.metadata.ResourceExist;
import org.apache.skywalking.banyandb.v1.client.metadata.Stream;
import org.apache.skywalking.banyandb.v1.client.metadata.TagFamilySpec;
import org.apache.skywalking.banyandb.v1.client.metadata.TopNAggregation;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntList;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MetadataRegistry {
    INSTANCE;

    @Generated
    private static final Logger log;
    private static final ObjectMapper MAPPER;
    private final Map<String, Schema> registry = new HashMap<String, Schema>();
    private Map<String, GroupSetting> specificGroupSettings = new HashMap<String, GroupSetting>();

    public Stream registerStreamModel(Model model, BanyanDBStorageConfig config, ConfigService configService) {
        SchemaMetadata schemaMetadata = this.parseMetadata(model, config, configService);
        Schema.SchemaBuilder schemaBuilder = Schema.builder().metadata(schemaMetadata);
        Map<String, ModelColumn> modelColumnMap = model.getColumns().stream().collect(Collectors.toMap(modelColumn -> modelColumn.getColumnName().getStorageName(), Function.identity()));
        List<String> shardingColumns = this.parseEntityNames(modelColumnMap);
        if (shardingColumns.isEmpty()) {
            throw new IllegalStateException("sharding keys of model[stream." + model.getName() + "] must not be empty");
        }
        List<TagMetadata> tags = this.parseTagMetadata(model, schemaBuilder, shardingColumns);
        List<TagFamilySpec> tagFamilySpecs = schemaMetadata.extractTagFamilySpec(tags, false);
        for (TagFamilySpec tagFamilySpec : tagFamilySpecs) {
            for (TagFamilySpec.TagSpec tagSpec : tagFamilySpec.tagSpecs()) {
                schemaBuilder.tag(tagSpec.getTagName());
            }
        }
        String timestampColumn4Stream = model.getBanyanDBModelExtension().getTimestampColumn();
        if (StringUtil.isBlank((String)timestampColumn4Stream)) {
            throw new IllegalStateException("Model[stream." + model.getName() + "] miss defined @BanyanDB.TimestampColumn");
        }
        schemaBuilder.timestampColumn4Stream(timestampColumn4Stream);
        List indexRules = tags.stream().map(TagMetadata::getIndexRule).filter(Objects::nonNull).collect(Collectors.toList());
        Stream.Builder builder = Stream.create((String)schemaMetadata.getGroup(), (String)schemaMetadata.name());
        builder.setEntityRelativeTags(shardingColumns);
        builder.addTagFamilies(tagFamilySpecs);
        builder.addIndexes(indexRules);
        this.registry.put(schemaMetadata.name(), schemaBuilder.build());
        return builder.build();
    }

    public Measure registerMeasureModel(Model model, BanyanDBStorageConfig config, ConfigService configService) throws StorageException {
        SchemaMetadata schemaMetadata = this.parseMetadata(model, config, configService);
        Schema.SchemaBuilder schemaBuilder = Schema.builder().metadata(schemaMetadata);
        Map<String, ModelColumn> modelColumnMap = model.getColumns().stream().collect(Collectors.toMap(modelColumn -> modelColumn.getColumnName().getStorageName(), Function.identity()));
        List<String> shardingColumns = this.parseEntityNames(modelColumnMap);
        if (shardingColumns.isEmpty()) {
            throw new StorageException("model " + model.getName() + " doesn't contain series id");
        }
        MeasureMetadata tagsAndFields = this.parseTagAndFieldMetadata(model, schemaBuilder, shardingColumns);
        List<TagFamilySpec> tagFamilySpecs = schemaMetadata.extractTagFamilySpec(tagsAndFields.tags, model.getBanyanDBModelExtension().isStoreIDTag());
        for (TagFamilySpec tagFamilySpec : tagFamilySpecs) {
            for (TagFamilySpec.TagSpec tagSpec : tagFamilySpec.tagSpecs()) {
                schemaBuilder.tag(tagSpec.getTagName());
            }
        }
        List indexRules = tagsAndFields.tags.stream().map(TagMetadata::getIndexRule).filter(Objects::nonNull).collect(Collectors.toList());
        if (model.getBanyanDBModelExtension().isStoreIDTag()) {
            indexRules.add(IndexRule.create((String)"id", (IndexRule.IndexType)IndexRule.IndexType.TREE, (IndexRule.IndexLocation)IndexRule.IndexLocation.SERIES));
        }
        Measure.Builder builder = Measure.create((String)schemaMetadata.getGroup(), (String)schemaMetadata.name(), (Duration)this.downSamplingDuration(model.getDownsampling()));
        builder.setEntityRelativeTags(shardingColumns);
        builder.addTagFamilies(tagFamilySpecs);
        if (!indexRules.isEmpty()) {
            builder.addIndexes(indexRules);
        }
        for (Measure.FieldSpec field : tagsAndFields.fields) {
            builder.addField(field);
            schemaBuilder.field(field.getName());
        }
        schemaBuilder.topNSpec(this.parseTopNSpec(model, schemaMetadata.name()));
        this.registry.put(schemaMetadata.name(), schemaBuilder.build());
        return builder.build();
    }

    private TopNSpec parseTopNSpec(Model model, String measureName) throws StorageException {
        if (model.getBanyanDBModelExtension().getTopN() == null) {
            return null;
        }
        Optional valueColumnOpt = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(model.getName());
        if (valueColumnOpt.isEmpty() || ((ValueColumnMetadata.ValueColumn)valueColumnOpt.get()).getDataType() != Column.ValueDataType.COMMON_VALUE) {
            return null;
        }
        if (CollectionUtils.isEmpty((List)model.getBanyanDBModelExtension().getTopN().getGroupByTagNames())) {
            throw new StorageException("invalid groupBy tags: " + model.getBanyanDBModelExtension().getTopN().getGroupByTagNames());
        }
        return TopNSpec.builder().name(measureName + "_topn").lruSize(model.getBanyanDBModelExtension().getTopN().getLruSize()).countersNumber(model.getBanyanDBModelExtension().getTopN().getCountersNumber()).fieldName(((ValueColumnMetadata.ValueColumn)valueColumnOpt.get()).getValueCName()).groupByTagNames(model.getBanyanDBModelExtension().getTopN().getGroupByTagNames()).sort(AbstractQuery.Sort.UNSPECIFIED).build();
    }

    public Schema findMetadata(Model model) {
        if (model.isRecord()) {
            return this.findRecordMetadata(model.getName());
        }
        return this.findMetadata(model.getName(), model.getDownsampling());
    }

    public Schema findRecordMetadata(String recordModelName) {
        Schema s = this.registry.get(recordModelName);
        if (s == null) {
            return null;
        }
        if (s.getMetadata().getKind() != Kind.STREAM) {
            throw new IllegalArgumentException(recordModelName + "is not a record");
        }
        return s;
    }

    static DownSampling deriveFromStep(Step step) {
        switch (step) {
            case DAY: {
                return DownSampling.Day;
            }
            case HOUR: {
                return DownSampling.Hour;
            }
            case SECOND: {
                return DownSampling.Second;
            }
        }
        return DownSampling.Minute;
    }

    public Schema findMetadata(String modelName, Step step) {
        return this.findMetadata(modelName, MetadataRegistry.deriveFromStep(step));
    }

    public Schema findMetadata(String modelName, DownSampling downSampling) {
        return this.registry.get(SchemaMetadata.formatName(modelName, downSampling));
    }

    private Measure.FieldSpec parseFieldSpec(ModelColumn modelColumn) {
        String colName = modelColumn.getColumnName().getStorageName();
        if (String.class.equals((Object)modelColumn.getType())) {
            return Measure.FieldSpec.newIntField((String)colName).compressWithZSTD().build();
        }
        if (Long.TYPE.equals(modelColumn.getType()) || Integer.TYPE.equals(modelColumn.getType())) {
            return Measure.FieldSpec.newIntField((String)colName).compressWithZSTD().encodeWithGorilla().build();
        }
        if (StorageDataComplexObject.class.isAssignableFrom(modelColumn.getType()) || JsonObject.class.equals((Object)modelColumn.getType())) {
            return Measure.FieldSpec.newStringField((String)colName).compressWithZSTD().build();
        }
        if (Double.TYPE.equals(modelColumn.getType())) {
            log.warn("Double is stored as binary");
            return Measure.FieldSpec.newBinaryField((String)colName).compressWithZSTD().build();
        }
        throw new UnsupportedOperationException(modelColumn.getType().getSimpleName() + " is not supported for field");
    }

    Duration downSamplingDuration(DownSampling downSampling) {
        switch (downSampling) {
            case Hour: {
                return Duration.ofHours((long)1L);
            }
            case Minute: {
                return Duration.ofMinutes((long)1L);
            }
            case Day: {
                return Duration.ofDays((long)1L);
            }
        }
        throw new UnsupportedOperationException("unsupported downSampling interval");
    }

    IndexRule parseIndexRule(String tagName, ModelColumn modelColumn) {
        if (modelColumn == null) {
            return IndexRule.create((String)tagName, (IndexRule.IndexType)IndexRule.IndexType.INVERTED, (IndexRule.IndexLocation)IndexRule.IndexLocation.SERIES);
        }
        if (modelColumn.getBanyanDBExtension().isGlobalIndexing()) {
            return IndexRule.create((String)tagName, (IndexRule.IndexType)MetadataRegistry.parseIndexType(modelColumn.getBanyanDBExtension().getIndexType()), (IndexRule.IndexLocation)IndexRule.IndexLocation.GLOBAL);
        }
        return IndexRule.create((String)tagName, (IndexRule.IndexType)MetadataRegistry.parseIndexType(modelColumn.getBanyanDBExtension().getIndexType()), (IndexRule.IndexLocation)IndexRule.IndexLocation.SERIES);
    }

    private static IndexRule.IndexType parseIndexType(BanyanDB.IndexRule.IndexType indexType) {
        if (indexType == BanyanDB.IndexRule.IndexType.INVERTED) {
            return IndexRule.IndexType.INVERTED;
        }
        return IndexRule.IndexType.TREE;
    }

    List<String> parseEntityNames(Map<String, ModelColumn> modelColumnMap) {
        ArrayList<ModelColumn> shardingColumns = new ArrayList<ModelColumn>();
        for (ModelColumn col2 : modelColumnMap.values()) {
            if (!col2.getBanyanDBExtension().isShardingKey()) continue;
            shardingColumns.add(col2);
        }
        return shardingColumns.stream().sorted(Comparator.comparingInt(col -> col.getBanyanDBExtension().getShardingKeyIdx())).map(col -> col.getColumnName().getName()).collect(Collectors.toList());
    }

    List<TagMetadata> parseTagMetadata(Model model, Schema.SchemaBuilder builder, List<String> shardingColumns) {
        ArrayList<TagMetadata> tagMetadataList = new ArrayList<TagMetadata>();
        for (ModelColumn col : model.getColumns()) {
            String columnStorageName = col.getColumnName().getStorageName();
            if (columnStorageName.equals("time_bucket")) continue;
            TagFamilySpec.TagSpec tagSpec = this.parseTagSpec(col);
            builder.spec(columnStorageName, new ColumnSpec(ColumnType.TAG, col.getType()));
            String colName = col.getColumnName().getStorageName();
            if (!shardingColumns.contains(colName) && col.getBanyanDBExtension().shouldIndex()) {
                IndexRule indexRule = this.parseIndexRule(tagSpec.getTagName(), col);
                tagMetadataList.add(new TagMetadata(indexRule, tagSpec));
                continue;
            }
            tagMetadataList.add(new TagMetadata(null, tagSpec));
        }
        return tagMetadataList;
    }

    MeasureMetadata parseTagAndFieldMetadata(Model model, Schema.SchemaBuilder builder, List<String> shardingColumns) {
        MeasureMetadata.MeasureMetadataBuilder result = MeasureMetadata.builder();
        for (ModelColumn col : model.getColumns()) {
            String columnStorageName = col.getColumnName().getStorageName();
            if (columnStorageName.equals("time_bucket")) continue;
            if (col.getBanyanDBExtension().isMeasureField()) {
                builder.spec(columnStorageName, new ColumnSpec(ColumnType.FIELD, col.getType()));
                result.field(this.parseFieldSpec(col));
                continue;
            }
            TagFamilySpec.TagSpec tagSpec = this.parseTagSpec(col);
            builder.spec(columnStorageName, new ColumnSpec(ColumnType.TAG, col.getType()));
            String colName = col.getColumnName().getStorageName();
            result.tag(new TagMetadata(!shardingColumns.contains(colName) && col.getBanyanDBExtension().shouldIndex() ? this.parseIndexRule(tagSpec.getTagName(), col) : null, tagSpec));
        }
        return result.build();
    }

    @Nonnull
    private TagFamilySpec.TagSpec parseTagSpec(ModelColumn modelColumn) {
        ParameterizedType t;
        Class clazz = modelColumn.getType();
        String colName = modelColumn.getColumnName().getStorageName();
        TagFamilySpec.TagSpec tagSpec = null;
        if (String.class.equals((Object)clazz) || StorageDataComplexObject.class.isAssignableFrom(clazz) || JsonObject.class.equals((Object)clazz)) {
            tagSpec = TagFamilySpec.TagSpec.newStringTag((String)colName);
        } else if (Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz)) {
            tagSpec = TagFamilySpec.TagSpec.newIntTag((String)colName);
        } else if (byte[].class.equals((Object)clazz)) {
            tagSpec = TagFamilySpec.TagSpec.newBinaryTag((String)colName);
        } else if (clazz.isEnum()) {
            tagSpec = TagFamilySpec.TagSpec.newIntTag((String)colName);
        } else if (Double.TYPE.equals(clazz) || Double.class.equals((Object)clazz)) {
            tagSpec = TagFamilySpec.TagSpec.newBinaryTag((String)colName);
        } else if (IntList.class.isAssignableFrom(clazz)) {
            tagSpec = TagFamilySpec.TagSpec.newIntArrayTag((String)colName);
        } else if (List.class.isAssignableFrom(clazz) && String.class.equals((Object)(t = (ParameterizedType)modelColumn.getGenericType()).getActualTypeArguments()[0])) {
            tagSpec = TagFamilySpec.TagSpec.newStringArrayTag((String)colName);
        }
        if (tagSpec == null) {
            throw new IllegalStateException("type " + modelColumn.getType().toString() + " is not supported");
        }
        if (modelColumn.isIndexOnly()) {
            tagSpec.indexedOnly();
        }
        return tagSpec;
    }

    public void initializeIntervals(String specificGroupSettingsStr) {
        if (StringUtil.isBlank((String)specificGroupSettingsStr)) {
            return;
        }
        try {
            this.specificGroupSettings = (Map)MAPPER.readerFor((TypeReference)new TypeReference<Map<String, GroupSetting>>(){}).readValue(specificGroupSettingsStr);
        }
        catch (IOException ioEx) {
            log.warn("fail to parse specificGroupSettings", (Throwable)ioEx);
        }
    }

    public SchemaMetadata parseMetadata(Model model, BanyanDBStorageConfig config, ConfigService configService) {
        GroupSetting groupSetting;
        Object group;
        int blockIntervalHrs = config.getBlockIntervalHours();
        int segmentIntervalDays = config.getSegmentIntervalDays();
        if (model.isSuperDataset()) {
            blockIntervalHrs = config.getSuperDatasetBlockIntervalHours();
            segmentIntervalDays = config.getSuperDatasetSegmentIntervalDays();
        }
        int metricShardNum = config.getMetricsShardsNumber();
        if (model.isRecord()) {
            group = "stream-default";
            if (model.isSuperDataset()) {
                group = "stream-" + model.getName();
            }
        } else if (model.getDownsampling() == DownSampling.Minute && model.isTimeRelativeID()) {
            group = "measure-minute";
            blockIntervalHrs = config.getSuperDatasetBlockIntervalHours();
            segmentIntervalDays = config.getSuperDatasetSegmentIntervalDays();
            metricShardNum *= config.getSuperDatasetShardsFactor();
        } else {
            int intervalDays = Double.valueOf(Math.ceil((double)configService.getMetricsDataTTL() * 2.0 / 1.8)).intValue();
            return new SchemaMetadata("measure-default", model.getName(), Kind.MEASURE, model.getDownsampling(), config.getMetricsShardsNumber(), intervalDays * 24, intervalDays, configService.getMetricsDataTTL());
        }
        if ((groupSetting = this.specificGroupSettings.get(group)) != null) {
            blockIntervalHrs = groupSetting.getBlockIntervalHours();
            segmentIntervalDays = groupSetting.getSegmentIntervalDays();
        }
        if (model.isRecord()) {
            return new SchemaMetadata((String)group, model.getName(), Kind.STREAM, model.getDownsampling(), config.getRecordShardsNumber() * (model.isSuperDataset() ? config.getSuperDatasetShardsFactor() : 1), blockIntervalHrs, segmentIntervalDays, configService.getRecordDataTTL());
        }
        return new SchemaMetadata((String)group, model.getName(), Kind.MEASURE, model.getDownsampling(), metricShardNum, blockIntervalHrs, segmentIntervalDays, configService.getMetricsDataTTL());
    }

    static {
        log = LoggerFactory.getLogger(MetadataRegistry.class);
        MAPPER = new ObjectMapper();
    }

    public static class SchemaMetadata {
        private final String group;
        private final String modelName;
        private final Kind kind;
        private final DownSampling downSampling;
        private final int shard;
        private final int blockIntervalHrs;
        private final int segmentIntervalDays;
        private final int ttlDays;

        static String formatName(String modelName, DownSampling downSampling) {
            if (downSampling == null || downSampling == DownSampling.None) {
                return modelName;
            }
            return modelName + "_" + downSampling.getName();
        }

        public Optional<NamedSchema<?>> findRemoteSchema(BanyanDBClient client) throws BanyanDBException {
            try {
                switch (this.kind) {
                    case STREAM: {
                        return Optional.ofNullable(client.findStream(this.group, this.name()));
                    }
                    case MEASURE: {
                        return Optional.ofNullable(client.findMeasure(this.group, this.name()));
                    }
                }
                throw new IllegalStateException("should not reach here");
            }
            catch (BanyanDBException ex) {
                if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                    return Optional.empty();
                }
                throw ex;
            }
        }

        private List<TagFamilySpec> extractTagFamilySpec(List<TagMetadata> tagMetadataList, boolean shouldAddID) {
            String indexFamily = this.indexFamily();
            String nonIndexFamily = this.nonIndexFamily();
            Map<String, List<TagMetadata>> tagMetadataMap = tagMetadataList.stream().collect(Collectors.groupingBy(tagMetadata -> tagMetadata.isIndex() ? indexFamily : nonIndexFamily));
            ArrayList<TagFamilySpec> tagFamilySpecs = new ArrayList<TagFamilySpec>(tagMetadataMap.size());
            for (Map.Entry<String, List<TagMetadata>> entry : tagMetadataMap.entrySet()) {
                TagFamilySpec.Builder b = TagFamilySpec.create((String)entry.getKey()).addTagSpecs((Iterable)entry.getValue().stream().map(TagMetadata::getTagSpec).collect(Collectors.toList()));
                if (shouldAddID && indexFamily.equals(entry.getKey())) {
                    b.addTagSpec(TagFamilySpec.TagSpec.newStringTag((String)"id"));
                }
                tagFamilySpecs.add(b.build());
            }
            return tagFamilySpecs;
        }

        public boolean checkResourceExistence(BanyanDBClient client) throws BanyanDBException {
            switch (this.kind) {
                case STREAM: {
                    Group g;
                    ResourceExist resourceExist = client.existStream(this.group, this.name());
                    if (!resourceExist.hasGroup() && (g = client.define(Group.create((String)this.group, (Catalog)Catalog.STREAM, (int)this.shard, (IntervalRule)IntervalRule.create((IntervalRule.Unit)IntervalRule.Unit.HOUR, (int)this.blockIntervalHrs), (IntervalRule)IntervalRule.create((IntervalRule.Unit)IntervalRule.Unit.DAY, (int)this.segmentIntervalDays), (IntervalRule)IntervalRule.create((IntervalRule.Unit)IntervalRule.Unit.DAY, (int)this.ttlDays)))) != null) {
                        log.info("group {} created", (Object)g.name());
                    }
                    return resourceExist.hasResource();
                }
                case MEASURE: {
                    Group g;
                    ResourceExist resourceExist = client.existMeasure(this.group, this.name());
                    if (!resourceExist.hasGroup() && (g = client.define(Group.create((String)this.group, (Catalog)Catalog.MEASURE, (int)this.shard, (IntervalRule)IntervalRule.create((IntervalRule.Unit)IntervalRule.Unit.HOUR, (int)this.blockIntervalHrs), (IntervalRule)IntervalRule.create((IntervalRule.Unit)IntervalRule.Unit.DAY, (int)this.segmentIntervalDays), (IntervalRule)IntervalRule.create((IntervalRule.Unit)IntervalRule.Unit.DAY, (int)this.ttlDays)))) != null) {
                        log.info("group {} created", (Object)g.name());
                    }
                    return resourceExist.hasResource();
                }
            }
            throw new IllegalStateException("should not reach here");
        }

        public String name() {
            if (this.kind == Kind.MEASURE) {
                return SchemaMetadata.formatName(this.modelName, this.downSampling);
            }
            return this.modelName;
        }

        public String indexFamily() {
            switch (this.kind) {
                case MEASURE: {
                    return "default";
                }
                case STREAM: {
                    return "searchable";
                }
            }
            throw new IllegalStateException("should not reach here");
        }

        public String nonIndexFamily() {
            switch (this.kind) {
                case STREAM: 
                case MEASURE: {
                    return "storage-only";
                }
            }
            throw new IllegalStateException("should not reach here");
        }

        @Generated
        public SchemaMetadata(String group, String modelName, Kind kind, DownSampling downSampling, int shard, int blockIntervalHrs, int segmentIntervalDays, int ttlDays) {
            this.group = group;
            this.modelName = modelName;
            this.kind = kind;
            this.downSampling = downSampling;
            this.shard = shard;
            this.blockIntervalHrs = blockIntervalHrs;
            this.segmentIntervalDays = segmentIntervalDays;
            this.ttlDays = ttlDays;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public String getModelName() {
            return this.modelName;
        }

        @Generated
        public Kind getKind() {
            return this.kind;
        }

        @Generated
        public DownSampling getDownSampling() {
            return this.downSampling;
        }

        @Generated
        public int getShard() {
            return this.shard;
        }

        @Generated
        public int getBlockIntervalHrs() {
            return this.blockIntervalHrs;
        }

        @Generated
        public int getSegmentIntervalDays() {
            return this.segmentIntervalDays;
        }

        @Generated
        public int getTtlDays() {
            return this.ttlDays;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchemaMetadata)) {
                return false;
            }
            SchemaMetadata other = (SchemaMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getShard() != other.getShard()) {
                return false;
            }
            if (this.getBlockIntervalHrs() != other.getBlockIntervalHrs()) {
                return false;
            }
            if (this.getSegmentIntervalDays() != other.getSegmentIntervalDays()) {
                return false;
            }
            if (this.getTtlDays() != other.getTtlDays()) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$modelName = this.getModelName();
            String other$modelName = other.getModelName();
            if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
                return false;
            }
            Kind this$kind = this.getKind();
            Kind other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
                return false;
            }
            DownSampling this$downSampling = this.getDownSampling();
            DownSampling other$downSampling = other.getDownSampling();
            return !(this$downSampling == null ? other$downSampling != null : !this$downSampling.equals(other$downSampling));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SchemaMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getShard();
            result = result * 59 + this.getBlockIntervalHrs();
            result = result * 59 + this.getSegmentIntervalDays();
            result = result * 59 + this.getTtlDays();
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $modelName = this.getModelName();
            result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
            Kind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
            DownSampling $downSampling = this.getDownSampling();
            result = result * 59 + ($downSampling == null ? 43 : $downSampling.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MetadataRegistry.SchemaMetadata(group=" + this.getGroup() + ", modelName=" + this.getModelName() + ", kind=" + this.getKind() + ", downSampling=" + this.getDownSampling() + ", shard=" + this.getShard() + ", blockIntervalHrs=" + this.getBlockIntervalHrs() + ", segmentIntervalDays=" + this.getSegmentIntervalDays() + ", ttlDays=" + this.getTtlDays() + ")";
        }
    }

    public static class Schema {
        private final SchemaMetadata metadata;
        private final Map<String, ColumnSpec> specs;
        private final Set<String> tags;
        private final Set<String> fields;
        private final String timestampColumn4Stream;
        @Nullable
        private final TopNSpec topNSpec;

        public ColumnSpec getSpec(String columnName) {
            return this.specs.get(columnName);
        }

        public void installTopNAggregation(BanyanDBClient client) throws BanyanDBException {
            if (this.getTopNSpec() == null) {
                if (this.metadata.kind == Kind.MEASURE) {
                    log.debug("skip null TopN Schema for [{}]", (Object)this.metadata.getModelName());
                }
                return;
            }
            client.define(TopNAggregation.create((String)this.getMetadata().getGroup(), (String)this.getTopNSpec().getName()).setSourceMeasureName(this.getMetadata().name()).setFieldValueSort(this.getTopNSpec().getSort()).setFieldName(this.getTopNSpec().getFieldName()).setGroupByTagNames(this.getTopNSpec().getGroupByTagNames()).setCountersNumber(this.getTopNSpec().getCountersNumber()).setLruSize(this.getTopNSpec().getLruSize()).build());
            log.info("installed TopN schema for measure {}", (Object)this.getMetadata().name());
        }

        @Generated
        Schema(SchemaMetadata metadata, Map<String, ColumnSpec> specs, Set<String> tags, Set<String> fields, String timestampColumn4Stream, @Nullable TopNSpec topNSpec) {
            this.metadata = metadata;
            this.specs = specs;
            this.tags = tags;
            this.fields = fields;
            this.timestampColumn4Stream = timestampColumn4Stream;
            this.topNSpec = topNSpec;
        }

        @Generated
        public static SchemaBuilder builder() {
            return new SchemaBuilder();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Schema)) {
                return false;
            }
            Schema other = (Schema)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SchemaMetadata this$metadata = this.getMetadata();
            SchemaMetadata other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            Map<String, ColumnSpec> this$specs = this.specs;
            Map<String, ColumnSpec> other$specs = other.specs;
            if (this$specs == null ? other$specs != null : !((Object)this$specs).equals(other$specs)) {
                return false;
            }
            Set<String> this$tags = this.getTags();
            Set<String> other$tags = other.getTags();
            if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
                return false;
            }
            Set<String> this$fields = this.getFields();
            Set<String> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            String this$timestampColumn4Stream = this.getTimestampColumn4Stream();
            String other$timestampColumn4Stream = other.getTimestampColumn4Stream();
            if (this$timestampColumn4Stream == null ? other$timestampColumn4Stream != null : !this$timestampColumn4Stream.equals(other$timestampColumn4Stream)) {
                return false;
            }
            TopNSpec this$topNSpec = this.getTopNSpec();
            TopNSpec other$topNSpec = other.getTopNSpec();
            return !(this$topNSpec == null ? other$topNSpec != null : !((Object)this$topNSpec).equals(other$topNSpec));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Schema;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SchemaMetadata $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            Map<String, ColumnSpec> $specs = this.specs;
            result = result * 59 + ($specs == null ? 43 : ((Object)$specs).hashCode());
            Set<String> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            Set<String> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            String $timestampColumn4Stream = this.getTimestampColumn4Stream();
            result = result * 59 + ($timestampColumn4Stream == null ? 43 : $timestampColumn4Stream.hashCode());
            TopNSpec $topNSpec = this.getTopNSpec();
            result = result * 59 + ($topNSpec == null ? 43 : ((Object)$topNSpec).hashCode());
            return result;
        }

        @Generated
        public SchemaMetadata getMetadata() {
            return this.metadata;
        }

        @Generated
        public Set<String> getTags() {
            return this.tags;
        }

        @Generated
        public Set<String> getFields() {
            return this.fields;
        }

        @Generated
        public String getTimestampColumn4Stream() {
            return this.timestampColumn4Stream;
        }

        @Nullable
        @Generated
        public TopNSpec getTopNSpec() {
            return this.topNSpec;
        }

        @Generated
        public static class SchemaBuilder {
            @Generated
            private SchemaMetadata metadata;
            @Generated
            private ArrayList<String> specs$key;
            @Generated
            private ArrayList<ColumnSpec> specs$value;
            @Generated
            private ArrayList<String> tags;
            @Generated
            private ArrayList<String> fields;
            @Generated
            private String timestampColumn4Stream;
            @Generated
            private TopNSpec topNSpec;

            @Generated
            SchemaBuilder() {
            }

            @Generated
            public SchemaBuilder metadata(SchemaMetadata metadata) {
                this.metadata = metadata;
                return this;
            }

            @Generated
            public SchemaBuilder spec(String specKey, ColumnSpec specValue) {
                if (this.specs$key == null) {
                    this.specs$key = new ArrayList();
                    this.specs$value = new ArrayList();
                }
                this.specs$key.add(specKey);
                this.specs$value.add(specValue);
                return this;
            }

            @Generated
            public SchemaBuilder specs(Map<? extends String, ? extends ColumnSpec> specs) {
                if (specs == null) {
                    throw new NullPointerException("specs cannot be null");
                }
                if (this.specs$key == null) {
                    this.specs$key = new ArrayList();
                    this.specs$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends ColumnSpec> $lombokEntry : specs.entrySet()) {
                    this.specs$key.add($lombokEntry.getKey());
                    this.specs$value.add($lombokEntry.getValue());
                }
                return this;
            }

            @Generated
            public SchemaBuilder clearSpecs() {
                if (this.specs$key != null) {
                    this.specs$key.clear();
                    this.specs$value.clear();
                }
                return this;
            }

            @Generated
            public SchemaBuilder tag(String tag) {
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.add(tag);
                return this;
            }

            @Generated
            public SchemaBuilder tags(Collection<? extends String> tags) {
                if (tags == null) {
                    throw new NullPointerException("tags cannot be null");
                }
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.addAll(tags);
                return this;
            }

            @Generated
            public SchemaBuilder clearTags() {
                if (this.tags != null) {
                    this.tags.clear();
                }
                return this;
            }

            @Generated
            public SchemaBuilder field(String field) {
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.add(field);
                return this;
            }

            @Generated
            public SchemaBuilder fields(Collection<? extends String> fields) {
                if (fields == null) {
                    throw new NullPointerException("fields cannot be null");
                }
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.addAll(fields);
                return this;
            }

            @Generated
            public SchemaBuilder clearFields() {
                if (this.fields != null) {
                    this.fields.clear();
                }
                return this;
            }

            @Generated
            public SchemaBuilder timestampColumn4Stream(String timestampColumn4Stream) {
                this.timestampColumn4Stream = timestampColumn4Stream;
                return this;
            }

            @Generated
            public SchemaBuilder topNSpec(@Nullable TopNSpec topNSpec) {
                this.topNSpec = topNSpec;
                return this;
            }

            @Generated
            public Schema build() {
                Set<Object> fields;
                Set<Object> tags;
                Map<Object, Object> specs;
                switch (this.specs$key == null ? 0 : this.specs$key.size()) {
                    case 0: {
                        specs = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        specs = Collections.singletonMap(this.specs$key.get(0), this.specs$value.get(0));
                        break;
                    }
                    default: {
                        specs = new LinkedHashMap(this.specs$key.size() < 0x40000000 ? 1 + this.specs$key.size() + (this.specs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.specs$key.size(); ++$i) {
                            specs.put(this.specs$key.get($i), this.specs$value.get($i));
                        }
                        specs = Collections.unmodifiableMap(specs);
                    }
                }
                switch (this.tags == null ? 0 : this.tags.size()) {
                    case 0: {
                        tags = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        tags = Collections.singleton(this.tags.get(0));
                        break;
                    }
                    default: {
                        tags = new LinkedHashSet(this.tags.size() < 0x40000000 ? 1 + this.tags.size() + (this.tags.size() - 3) / 3 : Integer.MAX_VALUE);
                        tags.addAll(this.tags);
                        tags = Collections.unmodifiableSet(tags);
                    }
                }
                switch (this.fields == null ? 0 : this.fields.size()) {
                    case 0: {
                        fields = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        fields = Collections.singleton(this.fields.get(0));
                        break;
                    }
                    default: {
                        fields = new LinkedHashSet(this.fields.size() < 0x40000000 ? 1 + this.fields.size() + (this.fields.size() - 3) / 3 : Integer.MAX_VALUE);
                        fields.addAll(this.fields);
                        fields = Collections.unmodifiableSet(fields);
                    }
                }
                return new Schema(this.metadata, specs, tags, fields, this.timestampColumn4Stream, this.topNSpec);
            }

            @Generated
            public String toString() {
                return "MetadataRegistry.Schema.SchemaBuilder(metadata=" + this.metadata + ", specs$key=" + this.specs$key + ", specs$value=" + this.specs$value + ", tags=" + this.tags + ", fields=" + this.fields + ", timestampColumn4Stream=" + this.timestampColumn4Stream + ", topNSpec=" + this.topNSpec + ")";
            }
        }
    }

    private static class MeasureMetadata {
        private final List<TagMetadata> tags;
        private final List<Measure.FieldSpec> fields;

        @Generated
        MeasureMetadata(List<TagMetadata> tags, List<Measure.FieldSpec> fields) {
            this.tags = tags;
            this.fields = fields;
        }

        @Generated
        public static MeasureMetadataBuilder builder() {
            return new MeasureMetadataBuilder();
        }

        @Generated
        public static class MeasureMetadataBuilder {
            @Generated
            private ArrayList<TagMetadata> tags;
            @Generated
            private ArrayList<Measure.FieldSpec> fields;

            @Generated
            MeasureMetadataBuilder() {
            }

            @Generated
            public MeasureMetadataBuilder tag(TagMetadata tag) {
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.add(tag);
                return this;
            }

            @Generated
            public MeasureMetadataBuilder tags(Collection<? extends TagMetadata> tags) {
                if (tags == null) {
                    throw new NullPointerException("tags cannot be null");
                }
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.addAll(tags);
                return this;
            }

            @Generated
            public MeasureMetadataBuilder clearTags() {
                if (this.tags != null) {
                    this.tags.clear();
                }
                return this;
            }

            @Generated
            public MeasureMetadataBuilder field(Measure.FieldSpec field) {
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.add(field);
                return this;
            }

            @Generated
            public MeasureMetadataBuilder fields(Collection<? extends Measure.FieldSpec> fields) {
                if (fields == null) {
                    throw new NullPointerException("fields cannot be null");
                }
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.addAll(fields);
                return this;
            }

            @Generated
            public MeasureMetadataBuilder clearFields() {
                if (this.fields != null) {
                    this.fields.clear();
                }
                return this;
            }

            @Generated
            public MeasureMetadata build() {
                List<Measure.FieldSpec> fields;
                List<TagMetadata> tags;
                switch (this.tags == null ? 0 : this.tags.size()) {
                    case 0: {
                        tags = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        tags = Collections.singletonList(this.tags.get(0));
                        break;
                    }
                    default: {
                        tags = Collections.unmodifiableList(new ArrayList<TagMetadata>(this.tags));
                    }
                }
                switch (this.fields == null ? 0 : this.fields.size()) {
                    case 0: {
                        fields = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        fields = Collections.singletonList(this.fields.get(0));
                        break;
                    }
                    default: {
                        fields = Collections.unmodifiableList(new ArrayList<Measure.FieldSpec>(this.fields));
                    }
                }
                return new MeasureMetadata(tags, fields);
            }

            @Generated
            public String toString() {
                return "MetadataRegistry.MeasureMetadata.MeasureMetadataBuilder(tags=" + this.tags + ", fields=" + this.fields + ")";
            }
        }
    }

    public static class TopNSpec {
        private final String name;
        private final List<String> groupByTagNames;
        private final String fieldName;
        private final AbstractQuery.Sort sort;
        private final int lruSize;
        private final int countersNumber;

        @Generated
        TopNSpec(String name, List<String> groupByTagNames, String fieldName, AbstractQuery.Sort sort, int lruSize, int countersNumber) {
            this.name = name;
            this.groupByTagNames = groupByTagNames;
            this.fieldName = fieldName;
            this.sort = sort;
            this.lruSize = lruSize;
            this.countersNumber = countersNumber;
        }

        @Generated
        public static TopNSpecBuilder builder() {
            return new TopNSpecBuilder();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TopNSpec)) {
                return false;
            }
            TopNSpec other = (TopNSpec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLruSize() != other.getLruSize()) {
                return false;
            }
            if (this.getCountersNumber() != other.getCountersNumber()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<String> this$groupByTagNames = this.getGroupByTagNames();
            List<String> other$groupByTagNames = other.getGroupByTagNames();
            if (this$groupByTagNames == null ? other$groupByTagNames != null : !((Object)this$groupByTagNames).equals(other$groupByTagNames)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            AbstractQuery.Sort this$sort = this.getSort();
            AbstractQuery.Sort other$sort = other.getSort();
            return !(this$sort == null ? other$sort != null : !this$sort.equals(other$sort));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TopNSpec;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLruSize();
            result = result * 59 + this.getCountersNumber();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<String> $groupByTagNames = this.getGroupByTagNames();
            result = result * 59 + ($groupByTagNames == null ? 43 : ((Object)$groupByTagNames).hashCode());
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            AbstractQuery.Sort $sort = this.getSort();
            result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
            return result;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<String> getGroupByTagNames() {
            return this.groupByTagNames;
        }

        @Generated
        public String getFieldName() {
            return this.fieldName;
        }

        @Generated
        public AbstractQuery.Sort getSort() {
            return this.sort;
        }

        @Generated
        public int getLruSize() {
            return this.lruSize;
        }

        @Generated
        public int getCountersNumber() {
            return this.countersNumber;
        }

        @Generated
        public static class TopNSpecBuilder {
            @Generated
            private String name;
            @Generated
            private ArrayList<String> groupByTagNames;
            @Generated
            private String fieldName;
            @Generated
            private AbstractQuery.Sort sort;
            @Generated
            private int lruSize;
            @Generated
            private int countersNumber;

            @Generated
            TopNSpecBuilder() {
            }

            @Generated
            public TopNSpecBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public TopNSpecBuilder groupByTagName(String groupByTagName) {
                if (this.groupByTagNames == null) {
                    this.groupByTagNames = new ArrayList();
                }
                this.groupByTagNames.add(groupByTagName);
                return this;
            }

            @Generated
            public TopNSpecBuilder groupByTagNames(Collection<? extends String> groupByTagNames) {
                if (groupByTagNames == null) {
                    throw new NullPointerException("groupByTagNames cannot be null");
                }
                if (this.groupByTagNames == null) {
                    this.groupByTagNames = new ArrayList();
                }
                this.groupByTagNames.addAll(groupByTagNames);
                return this;
            }

            @Generated
            public TopNSpecBuilder clearGroupByTagNames() {
                if (this.groupByTagNames != null) {
                    this.groupByTagNames.clear();
                }
                return this;
            }

            @Generated
            public TopNSpecBuilder fieldName(String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            @Generated
            public TopNSpecBuilder sort(AbstractQuery.Sort sort) {
                this.sort = sort;
                return this;
            }

            @Generated
            public TopNSpecBuilder lruSize(int lruSize) {
                this.lruSize = lruSize;
                return this;
            }

            @Generated
            public TopNSpecBuilder countersNumber(int countersNumber) {
                this.countersNumber = countersNumber;
                return this;
            }

            @Generated
            public TopNSpec build() {
                List<String> groupByTagNames;
                switch (this.groupByTagNames == null ? 0 : this.groupByTagNames.size()) {
                    case 0: {
                        groupByTagNames = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        groupByTagNames = Collections.singletonList(this.groupByTagNames.get(0));
                        break;
                    }
                    default: {
                        groupByTagNames = Collections.unmodifiableList(new ArrayList<String>(this.groupByTagNames));
                    }
                }
                return new TopNSpec(this.name, groupByTagNames, this.fieldName, this.sort, this.lruSize, this.countersNumber);
            }

            @Generated
            public String toString() {
                return "MetadataRegistry.TopNSpec.TopNSpecBuilder(name=" + this.name + ", groupByTagNames=" + this.groupByTagNames + ", fieldName=" + this.fieldName + ", sort=" + this.sort + ", lruSize=" + this.lruSize + ", countersNumber=" + this.countersNumber + ")";
            }
        }
    }

    public static enum Kind {
        MEASURE,
        STREAM;

    }

    public static class ColumnSpec {
        private final ColumnType columnType;
        private final Class<?> columnClass;

        @Generated
        public ColumnSpec(ColumnType columnType, Class<?> columnClass) {
            this.columnType = columnType;
            this.columnClass = columnClass;
        }

        @Generated
        public ColumnType getColumnType() {
            return this.columnType;
        }

        @Generated
        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }

    public static enum ColumnType {
        TAG,
        FIELD;

    }

    private static class TagMetadata {
        private final IndexRule indexRule;
        private final TagFamilySpec.TagSpec tagSpec;

        boolean isIndex() {
            return this.indexRule != null;
        }

        @Generated
        public TagMetadata(IndexRule indexRule, TagFamilySpec.TagSpec tagSpec) {
            this.indexRule = indexRule;
            this.tagSpec = tagSpec;
        }

        @Generated
        public IndexRule getIndexRule() {
            return this.indexRule;
        }

        @Generated
        public TagFamilySpec.TagSpec getTagSpec() {
            return this.tagSpec;
        }
    }

    public static class GroupSetting {
        private int blockIntervalHours;
        private int segmentIntervalDays;

        @Generated
        public int getBlockIntervalHours() {
            return this.blockIntervalHours;
        }

        @Generated
        public int getSegmentIntervalDays() {
            return this.segmentIntervalDays;
        }

        @Generated
        public void setBlockIntervalHours(int blockIntervalHours) {
            this.blockIntervalHours = blockIntervalHours;
        }

        @Generated
        public void setSegmentIntervalDays(int segmentIntervalDays) {
            this.segmentIntervalDays = segmentIntervalDays;
        }

        @Generated
        public GroupSetting() {
        }
    }
}

