/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.AbstractCriteria;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.storage.query.IZipkinQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.zipkin.ZipkinSpanRecord;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import zipkin2.Span;
import zipkin2.storage.QueryRequest;

public class BanyanDBZipkinQueryDAO
extends AbstractBanyanDBDAO
implements IZipkinQueryDAO {
    private static final int QUERY_MAX_SIZE = Integer.MAX_VALUE;
    private static final Set<String> SERVICE_TRAFFIC_TAGS = ImmutableSet.of((Object)"service_name");
    private static final Set<String> REMOTE_SERVICE_TRAFFIC_TAGS = ImmutableSet.of((Object)"remote_service_name");
    private static final Set<String> SPAN_TRAFFIC_TAGS = ImmutableSet.of((Object)"span_name");
    private static final Set<String> TRACE_ID = ImmutableSet.of((Object)"trace_id");
    private static final Set<String> TRACE_TAGS = ImmutableSet.of((Object)"trace_id", (Object)"span_id", (Object)"parent_id", (Object)"kind", (Object)"timestamp", (Object)"timestamp_millis", (Object[])new String[]{"duration", "name", "debug", "shared", "local_endpoint_service_name", "local_endpoint_ipv4", "local_endpoint_ipv6", "local_endpoint_port", "remote_endpoint_service_name", "remote_endpoint_ipv4", "remote_endpoint_ipv6", "remote_endpoint_port", "tags", "annotations"});

    public BanyanDBZipkinQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<String> getServiceNames() throws IOException {
        MeasureQueryResponse resp = this.query("zipkin_service_traffic", SERVICE_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.setLimit(Integer.valueOf(Integer.MAX_VALUE));
            }
        });
        ArrayList<String> services = new ArrayList<String>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            services.add((String)dataPoint.getTagValue("service_name"));
        }
        return services;
    }

    public List<String> getRemoteServiceNames(final String serviceName) throws IOException {
        MeasureQueryResponse resp = this.query("zipkin_service_relation_traffic", REMOTE_SERVICE_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                if (StringUtil.isNotEmpty((String)serviceName)) {
                    query.and(this.eq("service_name", serviceName));
                }
                query.setLimit(Integer.valueOf(Integer.MAX_VALUE));
            }
        });
        ArrayList<String> remoteServices = new ArrayList<String>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            remoteServices.add((String)dataPoint.getTagValue("remote_service_name"));
        }
        return remoteServices;
    }

    public List<String> getSpanNames(final String serviceName) throws IOException {
        MeasureQueryResponse resp = this.query("zipkin_service_span_traffic", SPAN_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                if (StringUtil.isNotEmpty((String)serviceName)) {
                    query.and(this.eq("service_name", serviceName));
                }
                query.setLimit(Integer.valueOf(Integer.MAX_VALUE));
            }
        });
        ArrayList<String> spanNames = new ArrayList<String>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            spanNames.add((String)dataPoint.getTagValue("span_name"));
        }
        return spanNames;
    }

    public List<Span> getTrace(final String traceId) throws IOException {
        StreamQueryResponse resp = this.query("zipkin_span", TRACE_TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                query.and(this.eq("trace_id", traceId));
                query.setLimit(Integer.MAX_VALUE);
            }
        });
        ArrayList<Span> trace = new ArrayList<Span>(resp.getElements().size());
        for (RowEntity rowEntity : resp.getElements()) {
            ZipkinSpanRecord spanRecord = new ZipkinSpanRecord.Builder().storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToStream("zipkin_span", rowEntity));
            trace.add(ZipkinSpanRecord.buildSpanFromRecord((ZipkinSpanRecord)spanRecord));
        }
        return trace;
    }

    public List<List<Span>> getTraces(QueryRequest request, Duration duration) throws IOException {
        int tracesLimit = request.limit();
        int scrollLimit = 1000;
        long scrollEndTime = duration.getEndTimestamp();
        HashSet<String> traceIds = new HashSet<String>();
        while (traceIds.size() < tracesLimit) {
            List<ZipkinSpanRecord> spans = this.getSpans(request, duration, scrollEndTime, scrollLimit);
            for (ZipkinSpanRecord span : spans) {
                traceIds.add(span.getTraceId());
                if (traceIds.size() < tracesLimit) continue;
                break;
            }
            if (spans.size() < scrollLimit) break;
            scrollEndTime = spans.get(spans.size() - 1).getTimestampMillis();
        }
        return this.getTraces(traceIds);
    }

    private List<ZipkinSpanRecord> getSpans(final QueryRequest request, Duration duration, long scrollEndTime, final int limit) throws IOException {
        long startTimeMillis = duration.getStartTimestamp();
        TimestampRange tsRange = null;
        if (startTimeMillis > 0L && scrollEndTime > 0L) {
            tsRange = new TimestampRange(startTimeMillis, scrollEndTime);
        }
        AbstractBanyanDBDAO.QueryBuilder<StreamQuery> queryBuilder = new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            public void apply(StreamQuery query) {
                if (!StringUtil.isEmpty((String)request.serviceName())) {
                    query.and(this.eq("local_endpoint_service_name", request.serviceName()));
                }
                if (!StringUtil.isEmpty((String)request.remoteServiceName())) {
                    query.and(this.eq("remote_endpoint_service_name", request.remoteServiceName()));
                }
                if (!StringUtil.isEmpty((String)request.spanName())) {
                    query.and(this.eq("name", request.spanName()));
                }
                if (!CollectionUtils.isEmpty((Map)request.annotationQuery())) {
                    for (Map.Entry annotation : request.annotationQuery().entrySet()) {
                        if (((String)annotation.getValue()).isEmpty()) {
                            query.and(this.eq("query", (String)annotation.getKey()));
                            continue;
                        }
                        query.and(this.eq("query", (String)annotation.getKey() + "=" + (String)annotation.getValue()));
                    }
                }
                if (request.minDuration() != null) {
                    query.and(this.gte("duration", request.minDuration()));
                }
                if (request.maxDuration() != null) {
                    query.and(this.lte("duration", request.maxDuration()));
                }
                query.setOrderBy(new AbstractQuery.OrderBy("timestamp_millis", AbstractQuery.Sort.DESC));
                query.setLimit(limit);
            }
        };
        StreamQueryResponse resp = this.query("zipkin_span", TRACE_TAGS, tsRange, queryBuilder);
        ArrayList<ZipkinSpanRecord> spans = new ArrayList<ZipkinSpanRecord>();
        for (RowEntity rowEntity : resp.getElements()) {
            ZipkinSpanRecord spanRecord = new ZipkinSpanRecord.Builder().storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToStream("zipkin_span", rowEntity));
            spans.add(spanRecord);
        }
        return spans;
    }

    public List<List<Span>> getTraces(final Set<String> traceIds) throws IOException {
        if (CollectionUtils.isEmpty(traceIds)) {
            return Collections.EMPTY_LIST;
        }
        final ArrayList conditions = new ArrayList(traceIds.size());
        StreamQueryResponse resp = this.query("zipkin_span", TRACE_TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                for (String traceId : traceIds) {
                    conditions.add(this.eq("trace_id", traceId));
                }
                if (conditions.size() == 1) {
                    query.criteria((AbstractCriteria)conditions.get(0));
                } else if (conditions.size() > 1) {
                    query.criteria(this.or(conditions));
                }
                query.setOrderBy(new AbstractQuery.OrderBy("timestamp_millis", AbstractQuery.Sort.DESC));
                query.setLimit(Integer.MAX_VALUE);
            }
        });
        return this.buildTraces(resp);
    }

    private List<List<Span>> buildTraces(StreamQueryResponse resp) {
        LinkedHashMap groupedByTraceId = new LinkedHashMap();
        for (RowEntity rowEntity : resp.getElements()) {
            ZipkinSpanRecord spanRecord = new ZipkinSpanRecord.Builder().storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToStream("zipkin_span", rowEntity));
            Span span = ZipkinSpanRecord.buildSpanFromRecord((ZipkinSpanRecord)spanRecord);
            String traceId = span.traceId();
            groupedByTraceId.putIfAbsent(traceId, new ArrayList());
            ((List)groupedByTraceId.get(traceId)).add(span);
        }
        return new ArrayList<List<Span>>(groupedByTraceId.values());
    }
}

