/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.etcd;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.watch.WatchResponse;
import io.grpc.stub.StreamObserver;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.cluster.plugin.etcd.ClusterModuleEtcdConfig;
import org.apache.skywalking.oap.server.cluster.plugin.etcd.EtcdEndpoint;
import org.apache.skywalking.oap.server.core.cluster.ClusterCoordinator;
import org.apache.skywalking.oap.server.core.cluster.ClusterHealthStatus;
import org.apache.skywalking.oap.server.core.cluster.OAPNodeChecker;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.cluster.ServiceRegisterException;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdCoordinator
extends ClusterCoordinator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EtcdCoordinator.class);
    private static final Gson GSON = new Gson().newBuilder().create();
    private final ModuleDefineHolder manager;
    private final ClusterModuleEtcdConfig config;
    private volatile Address selfAddress;
    private HealthCheckMetrics healthChecker;
    private final Client client;
    private final String serviceName;
    private final ByteSequence serviceNameBS;

    public EtcdCoordinator(ModuleDefineHolder manager, ClusterModuleEtcdConfig config) throws ModuleStartException {
        if (Strings.isNullOrEmpty((String)config.getServiceName())) {
            throw new ModuleStartException("ServiceName cannot be empty.");
        }
        this.manager = manager;
        this.config = config;
        this.serviceName = !config.getServiceName().endsWith("/") ? config.getServiceName() + "/" : config.getServiceName();
        this.serviceNameBS = ByteSequence.from((String)this.serviceName, (Charset)Charset.defaultCharset());
        ClientBuilder builder = Client.builder().endpoints(config.getEndpointArray()).authority(config.getAuthority());
        if (StringUtil.isNotEmpty((String)config.getNamespace())) {
            builder.namespace(ByteSequence.from((String)config.getNamespace(), (Charset)Charset.defaultCharset()));
        }
        if (config.isAuthentication()) {
            builder.user(ByteSequence.from((String)config.getUser(), (Charset)Charset.defaultCharset())).password(ByteSequence.from((String)config.getPassword(), (Charset)Charset.defaultCharset()));
        }
        this.client = builder.build();
    }

    public List<RemoteInstance> queryRemoteNodes() {
        ArrayList<RemoteInstance> remoteInstances = new ArrayList<RemoteInstance>();
        try {
            KV kvClient = this.client.getKVClient();
            GetResponse response = (GetResponse)kvClient.get(this.serviceNameBS, GetOption.newBuilder().withPrefix(this.serviceNameBS).build()).get();
            response.getKvs().forEach(kv -> {
                EtcdEndpoint endpoint = (EtcdEndpoint)GSON.fromJson(kv.getValue().toString(Charset.defaultCharset()), EtcdEndpoint.class);
                Address address = new Address(endpoint.getHost(), endpoint.getPort(), false);
                if (address.equals((Object)this.selfAddress)) {
                    address.setSelf(true);
                }
                remoteInstances.add(new RemoteInstance(address));
            });
            ClusterHealthStatus healthStatus = OAPNodeChecker.isHealth(remoteInstances);
            if (healthStatus.isHealth()) {
                this.healthChecker.health();
            } else {
                this.healthChecker.unHealth(healthStatus.getReason());
            }
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new RuntimeException(e);
        }
        if (log.isDebugEnabled()) {
            remoteInstances.forEach(instance -> log.debug("Etcd cluster instance: {}", instance));
        }
        return remoteInstances;
    }

    public void registerRemote(RemoteInstance remoteInstance) throws ServiceRegisterException {
        if (this.needUsingInternalAddr()) {
            remoteInstance = new RemoteInstance(new Address(this.config.getInternalComHost(), this.config.getInternalComPort(), true));
        }
        this.selfAddress = remoteInstance.getAddress();
        EtcdEndpoint endpoint = new EtcdEndpoint.Builder().serviceName(this.serviceName).host(this.selfAddress.getHost()).port(this.selfAddress.getPort()).build();
        try {
            Lease leaseClient = this.client.getLeaseClient();
            long leaseID = ((LeaseGrantResponse)leaseClient.grant(30L).get()).getID();
            ByteSequence instance = ByteSequence.from((String)GSON.toJson((Object)endpoint), (Charset)Charset.defaultCharset());
            this.client.getKVClient().put(EtcdCoordinator.buildKey(this.serviceName, this.selfAddress, remoteInstance), instance, PutOption.newBuilder().withLeaseId(leaseID).build()).get();
            this.healthChecker.health();
            this.client.getLeaseClient().keepAlive(leaseID, (StreamObserver)new StreamObserver<LeaseKeepAliveResponse>(){

                public void onNext(LeaseKeepAliveResponse response) {
                    if (log.isDebugEnabled()) {
                        log.debug("Refresh lease id = {}, ttl = {}", (Object)response.getID(), (Object)response.getTTL());
                    }
                }

                public void onError(Throwable throwable) {
                    log.error("Failed to keep alive in Etcd coordinator", throwable);
                    EtcdCoordinator.this.healthChecker.unHealth(throwable);
                }

                public void onCompleted() {
                }
            });
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new ServiceRegisterException(e);
        }
    }

    private static ByteSequence buildKey(String serviceName, Address address, RemoteInstance instance) {
        String key = serviceName + address.getHost() + "_" + instance.hashCode();
        return ByteSequence.from((String)key, (Charset)Charset.defaultCharset());
    }

    private boolean needUsingInternalAddr() {
        return !Strings.isNullOrEmpty((String)this.config.getInternalComHost()) && this.config.getInternalComPort() > 0;
    }

    private void initHealthChecker() {
        if (this.healthChecker == null) {
            MetricsCreator metricCreator = (MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class);
            this.healthChecker = metricCreator.createHealthCheckerGauge("cluster_etcd", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        }
    }

    public void start() {
        this.initHealthChecker();
        this.client.getWatchClient().watch(this.serviceNameBS, WatchOption.newBuilder().withPrefix(this.serviceNameBS).build(), (Watch.Listener)new EtcdEventListener());
    }

    class EtcdEventListener
    implements Watch.Listener {
        EtcdEventListener() {
        }

        public void onNext(WatchResponse response) {
            response.getEvents().forEach(event -> {
                switch (event.getEventType()) {
                    case DELETE: 
                    case PUT: {
                        if (log.isDebugEnabled()) {
                            String key = event.getKeyValue().getKey().toString(Charset.defaultCharset());
                            log.debug("{}: key = {}}", (Object)event.getEventType().name(), (Object)key);
                        }
                        EtcdCoordinator.this.notifyWatchers(EtcdCoordinator.this.queryRemoteNodes());
                        break;
                    }
                }
            });
        }

        public void onError(Throwable throwable) {
            log.error("Failed to notify RemoteInstances update.", throwable);
            EtcdCoordinator.this.healthChecker.unHealth(throwable);
        }

        public void onCompleted() {
        }
    }
}

