/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.otel.otlp;

import com.google.gson.JsonObject;
import com.google.protobuf.ByteString;
import io.grpc.BindableService;
import io.grpc.stub.StreamObserver;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceResponse;
import io.opentelemetry.proto.collector.trace.v1.TraceServiceGrpc;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.resource.v1.Resource;
import io.opentelemetry.proto.trace.v1.ScopeSpans;
import io.opentelemetry.proto.trace.v1.Span;
import io.opentelemetry.proto.trace.v1.Status;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.otel.Handler;
import org.apache.skywalking.oap.server.receiver.zipkin.SpanForwardService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin2.Endpoint;
import zipkin2.Span;

public class OpenTelemetryTraceHandler
extends TraceServiceGrpc.TraceServiceImplBase
implements Handler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenTelemetryTraceHandler.class);
    private final ModuleManager manager;
    private SpanForwardService forwardService;

    @Override
    public String type() {
        return "otlp-traces";
    }

    @Override
    public void active() throws ModuleStartException {
        GRPCHandlerRegister grpcHandlerRegister = (GRPCHandlerRegister)this.manager.find("receiver-sharing-server").provider().getService(GRPCHandlerRegister.class);
        grpcHandlerRegister.addHandler((BindableService)this);
    }

    public void export(ExportTraceServiceRequest request, StreamObserver<ExportTraceServiceResponse> responseObserver) {
        ArrayList result = new ArrayList();
        request.getResourceSpansList().forEach(resourceSpans -> {
            Resource resource = resourceSpans.getResource();
            List scopeSpansList = resourceSpans.getScopeSpansList();
            if (resource.getAttributesCount() == 0 && scopeSpansList.size() == 0) {
                return;
            }
            Map<String, String> resourceTags = this.convertAttributeToMap(resource.getAttributesList());
            String serviceName = this.extractZipkinServiceName(resourceTags);
            if (StringUtil.isEmpty((String)serviceName)) {
                log.warn("No service name found in resource attributes, discarding the trace");
                return;
            }
            try {
                for (ScopeSpans scopeSpans : scopeSpansList) {
                    this.extractScopeTag(scopeSpans.getScope(), resourceTags);
                    for (Span span : scopeSpans.getSpansList()) {
                        zipkin2.Span zipkinSpan = this.convertSpan(span, serviceName, resourceTags);
                        result.add(zipkinSpan);
                    }
                }
            }
            catch (Exception e) {
                log.warn("convert span error, discarding the span: {}", (Object)e.getMessage());
            }
        });
        this.getForwardService().send(result);
        responseObserver.onNext((Object)ExportTraceServiceResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }

    private zipkin2.Span convertSpan(Span span, String serviceName, Map<String, String> resourceTags) {
        Span.Builder spanBuilder = zipkin2.Span.newBuilder();
        Map<String, String> tags = this.aggregateSpanTags(span.getAttributesList(), resourceTags);
        if (span.getTraceId().isEmpty()) {
            throw new IllegalArgumentException("No trace id found in span");
        }
        spanBuilder.traceId(ByteBuffer.wrap(span.getTraceId().toByteArray(), 0, 8).getLong(), ByteBuffer.wrap(span.getTraceId().toByteArray(), 8, span.getTraceId().size() - 8).getLong());
        if (span.getSpanId().isEmpty()) {
            throw new IllegalArgumentException("No span id found in span");
        }
        spanBuilder.id(this.convertSpanId(span.getSpanId()));
        tags.put("w3c.tracestate", span.getTraceState());
        if (!span.getParentSpanId().isEmpty()) {
            spanBuilder.parentId(this.convertSpanId(span.getParentSpanId()));
        }
        spanBuilder.name(span.getName());
        long startMicro = TimeUnit.NANOSECONDS.toMicros(span.getStartTimeUnixNano());
        long endMicro = TimeUnit.NANOSECONDS.toMicros(span.getEndTimeUnixNano());
        spanBuilder.timestamp(startMicro);
        spanBuilder.duration(endMicro - startMicro);
        spanBuilder.kind(this.convertKind(span.getKind()));
        if (span.getKind() == Span.SpanKind.SPAN_KIND_INTERNAL) {
            tags.put("span.kind", "internal");
        }
        HashSet<String> redundantKeys = new HashSet<String>();
        spanBuilder.localEndpoint(this.convertEndpointFromTags(tags, serviceName, false, redundantKeys));
        spanBuilder.remoteEndpoint(this.convertEndpointFromTags(tags, "", true, redundantKeys));
        this.removeRedundantTags(tags, redundantKeys);
        this.populateStatus(span.getStatus(), tags);
        this.convertAnnotations(spanBuilder, span.getEventsList());
        this.convertLink(tags, span.getLinksList());
        tags.forEach((arg_0, arg_1) -> ((Span.Builder)spanBuilder).putTag(arg_0, arg_1));
        return spanBuilder.build();
    }

    private void convertAnnotations(Span.Builder spanBuilder, List<Span.Event> events) {
        events.forEach(event -> {
            long eventTime = TimeUnit.NANOSECONDS.toMicros(event.getTimeUnixNano());
            if (event.getAttributesList().size() == 0 && event.getDroppedAttributesCount() == 0) {
                spanBuilder.addAnnotation(eventTime, event.getName());
                return;
            }
            JsonObject attrObj = this.convertToString(event.getAttributesList());
            spanBuilder.addAnnotation(eventTime, event.getName() + "|" + attrObj + "|" + event.getDroppedAttributesCount());
        });
    }

    private void convertLink(Map<String, String> tags, List<Span.Link> links) {
        for (int i = 0; i < links.size(); ++i) {
            Span.Link link = links.get(i);
            tags.put("otlp.link." + i, this.idToHexString(link.getTraceId()) + "|" + this.idToHexString(link.getSpanId()) + "|" + link.getTraceState() + "|" + this.convertToString(link.getAttributesList()) + "|" + link.getDroppedAttributesCount());
        }
    }

    private String idToHexString(ByteString id) {
        if (id == null) {
            return "";
        }
        return new BigInteger(1, id.toByteArray()).toString();
    }

    private void populateStatus(Status status, Map<String, String> tags) {
        if (status.getCode() == Status.StatusCode.STATUS_CODE_ERROR) {
            tags.put("error", "true");
        } else {
            tags.remove("error");
        }
        if (status.getCode() == Status.StatusCode.STATUS_CODE_UNSET) {
            return;
        }
        tags.put("otel.status_code", status.getCode().name());
        if (StringUtil.isNotEmpty((String)status.getMessage())) {
            tags.put("otel.status_description", status.getMessage());
        }
    }

    private void removeRedundantTags(Map<String, String> resourceKeys, Set<String> redundantKeys) {
        for (String key : redundantKeys) {
            resourceKeys.remove(key);
        }
    }

    private Endpoint convertEndpointFromTags(Map<String, String> resourceTags, String localServiceName, boolean isRemote, Set<String> redundantKeys) {
        String portKey;
        String ipKey;
        String tmpVal;
        Endpoint.Builder builder = Endpoint.newBuilder();
        String serviceName = localServiceName;
        if (isRemote && StringUtil.isNotEmpty((String)(tmpVal = this.getAndPutRedundantKey(resourceTags, "peer.service", redundantKeys)))) {
            serviceName = tmpVal;
        } else if (isRemote && StringUtil.isNotEmpty((String)(tmpVal = this.getAndPutRedundantKey(resourceTags, "net.peer.name", redundantKeys))) && !builder.parseIp(tmpVal)) {
            serviceName = tmpVal;
        }
        if (isRemote) {
            ipKey = "net.peer.ip";
            portKey = "net.peer.port";
        } else {
            ipKey = "net.host.ip";
            portKey = "net.host.port";
        }
        boolean ipParseSuccess = false;
        tmpVal = this.getAndPutRedundantKey(resourceTags, ipKey, redundantKeys);
        if (StringUtil.isNotEmpty((String)tmpVal) && !(ipParseSuccess = builder.parseIp(tmpVal))) {
            String string = serviceName = StringUtil.isEmpty((String)serviceName) ? tmpVal : serviceName;
        }
        if (StringUtil.isNotEmpty((String)(tmpVal = this.getAndPutRedundantKey(resourceTags, portKey, redundantKeys)))) {
            builder.port(Integer.parseInt(tmpVal));
        }
        if (StringUtil.isEmpty((String)serviceName) && !ipParseSuccess) {
            return null;
        }
        builder.serviceName(serviceName);
        return builder.build();
    }

    private String getAndPutRedundantKey(Map<String, String> resourceTags, String key, Set<String> redundantKeys) {
        String val = resourceTags.get(key);
        if (StringUtil.isEmpty((String)val)) {
            return null;
        }
        redundantKeys.add(key);
        return val;
    }

    private Span.Kind convertKind(Span.SpanKind kind) {
        switch (kind) {
            case SPAN_KIND_CLIENT: {
                return Span.Kind.CLIENT;
            }
            case SPAN_KIND_SERVER: {
                return Span.Kind.SERVER;
            }
            case SPAN_KIND_PRODUCER: {
                return Span.Kind.PRODUCER;
            }
            case SPAN_KIND_CONSUMER: {
                return Span.Kind.CONSUMER;
            }
        }
        return null;
    }

    private long convertSpanId(ByteString spanId) {
        return ByteBuffer.wrap(spanId.toByteArray()).getLong();
    }

    private Map<String, String> aggregateSpanTags(List<KeyValue> spanAttrs, Map<String, String> resourceTags) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(resourceTags);
        result.putAll(this.convertAttributeToMap(spanAttrs));
        return result;
    }

    private void extractScopeTag(InstrumentationScope scope, Map<String, String> resourceTags) {
        if (scope == null) {
            return;
        }
        if (StringUtil.isNotEmpty((String)scope.getName())) {
            resourceTags.put("otel.library.name", scope.getName());
        }
        if (StringUtil.isNotEmpty((String)scope.getVersion())) {
            resourceTags.put("otel.library.version", scope.getVersion());
        }
    }

    private Map<String, String> convertAttributeToMap(List<KeyValue> attrs) {
        return attrs.stream().collect(Collectors.toMap(KeyValue::getKey, attributeKeyValue -> this.convertToString(attributeKeyValue.getValue()), (v1, v2) -> v1));
    }

    private String extractZipkinServiceName(Map<String, String> resourceTags) {
        String name = null;
        name = this.getServiceNameFromTags(name, resourceTags, "service.name", false);
        name = this.getServiceNameFromTags(name, resourceTags, "faas.name", true);
        name = this.getServiceNameFromTags(name, resourceTags, "k8s.deployment.name", true);
        name = this.getServiceNameFromTags(name, resourceTags, "process.executable.name", true);
        return name;
    }

    private String getServiceNameFromTags(String serviceName, Map<String, String> resourceTags, String tagKey, boolean addingSource) {
        if (StringUtil.isNotEmpty((String)serviceName)) {
            return serviceName;
        }
        String name = resourceTags.get(tagKey);
        if (StringUtil.isNotEmpty((String)name)) {
            if (addingSource) {
                resourceTags.remove(tagKey);
                resourceTags.put("otlp.service.name.source", tagKey);
            }
            return name;
        }
        return "";
    }

    private String convertToString(AnyValue value) {
        if (value == null) {
            return "";
        }
        if (value.hasBoolValue()) {
            return String.valueOf(value.getBoolValue());
        }
        if (value.hasDoubleValue()) {
            return String.valueOf(value.getDoubleValue());
        }
        if (value.hasStringValue()) {
            return value.getStringValue();
        }
        if (value.hasArrayValue()) {
            return value.getArrayValue().getValuesList().stream().map(this::convertToString).collect(Collectors.joining(","));
        }
        if (value.hasIntValue()) {
            return String.valueOf(value.getIntValue());
        }
        if (value.hasKvlistValue()) {
            JsonObject kvObj = this.convertToString(value.getKvlistValue().getValuesList());
            return kvObj.getAsString();
        }
        if (value.hasBytesValue()) {
            return new String(Base64.getEncoder().encode(value.getBytesValue().toByteArray()), StandardCharsets.UTF_8);
        }
        return "";
    }

    private JsonObject convertToString(List<KeyValue> keyValues) {
        JsonObject json = new JsonObject();
        for (KeyValue keyValue : keyValues) {
            json.addProperty(keyValue.getKey(), this.convertToString(keyValue.getValue()));
        }
        return json;
    }

    private SpanForwardService getForwardService() {
        if (this.forwardService == null) {
            this.forwardService = (SpanForwardService)this.manager.find("receiver-zipkin").provider().getService(SpanForwardService.class);
        }
        return this.forwardService;
    }

    @Generated
    public OpenTelemetryTraceHandler(ModuleManager manager) {
        this.manager = manager;
    }
}

