/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.rt.util;

import freemarker.template.Configuration;
import freemarker.template.Version;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.skywalking.oal.rt.OALRuntime;
import org.apache.skywalking.oal.rt.output.AllDispatcherContext;
import org.apache.skywalking.oal.rt.output.DispatcherContext;
import org.apache.skywalking.oal.rt.parser.AnalysisResult;
import org.apache.skywalking.oal.rt.parser.OALScripts;
import org.apache.skywalking.oal.rt.parser.SourceColumn;
import org.apache.skywalking.oap.server.core.WorkPath;
import org.apache.skywalking.oap.server.core.analysis.DisableRegister;
import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.oal.rt.OALCompileException;
import org.apache.skywalking.oap.server.core.oal.rt.OALDefine;
import org.apache.skywalking.oap.server.core.source.oal.rt.dispatcher.DispatcherClassPackageHolder;
import org.apache.skywalking.oap.server.core.source.oal.rt.metrics.MetricClassPackageHolder;
import org.apache.skywalking.oap.server.core.source.oal.rt.metrics.builder.MetricBuilderClassPackageHolder;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OALClassGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OALClassGenerator.class);
    private static final String METRICS_FUNCTION_PACKAGE = "org.apache.skywalking.oap.server.core.analysis.metrics.";
    private static final String WITH_METADATA_INTERFACE = "org.apache.skywalking.oap.server.core.analysis.metrics.WithMetadata";
    private static final String DISPATCHER_INTERFACE = "org.apache.skywalking.oap.server.core.analysis.SourceDispatcher";
    private static final String METRICS_STREAM_PROCESSOR = "org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor";
    private static final String[] METRICS_CLASS_METHODS = new String[]{"id", "hashCode", "remoteHashCode", "equals", "serialize", "deserialize", "getMeta", "toHour", "toDay"};
    private static final String[] METRICS_BUILDER_CLASS_METHODS = new String[]{"entity2Storage", "storage2Entity"};
    private static final String CLASS_FILE_CHARSET = "UTF-8";
    private boolean openEngineDebug = StringUtil.isNotEmpty((String)System.getenv("SW_OAL_ENGINE_DEBUG"));
    private AllDispatcherContext allDispatcherContext = new AllDispatcherContext();
    private final ClassPool classPool = ClassPool.getDefault();
    private final OALDefine oalDefine;
    private Configuration configuration;
    private ClassLoader currentClassLoader;
    private StorageBuilderFactory storageBuilderFactory;
    private static String GENERATED_FILE_PATH;

    public OALClassGenerator(OALDefine define) {
        this.oalDefine = define;
        this.configuration = new Configuration(new Version("2.3.28"));
        this.configuration.setEncoding(Locale.ENGLISH, CLASS_FILE_CHARSET);
        this.configuration.setClassLoaderForTemplateLoading(OALRuntime.class.getClassLoader(), "/code-templates");
    }

    public void generateClassAtRuntime(OALScripts oalScripts, List<Class> metricsClasses, List<Class> dispatcherClasses) throws OALCompileException {
        List<AnalysisResult> metricsStmts = oalScripts.getMetricsStmts();
        metricsStmts.forEach(this::buildDispatcherContext);
        for (AnalysisResult analysisResult : metricsStmts) {
            metricsClasses.add(this.generateMetricsClass(analysisResult));
            this.generateMetricsBuilderClass(analysisResult);
        }
        for (Map.Entry entry : this.allDispatcherContext.getAllContext().entrySet()) {
            dispatcherClasses.add(this.generateDispatcherClass((String)entry.getKey(), (DispatcherContext)entry.getValue()));
        }
        oalScripts.getDisableCollection().getAllDisableSources().forEach(disable -> DisableRegister.INSTANCE.add(disable));
    }

    private Class generateMetricsClass(AnalysisResult metricsStmt) throws OALCompileException {
        Class targetClass;
        String className = this.metricsClassName(metricsStmt, false);
        CtClass parentMetricsClass = null;
        try {
            parentMetricsClass = this.classPool.get(METRICS_FUNCTION_PACKAGE + metricsStmt.getMetricsClassName());
        }
        catch (NotFoundException e) {
            log.error("Can't find parent class for " + className + ".", (Throwable)e);
            throw new OALCompileException(e.getMessage(), (Throwable)e);
        }
        CtClass metricsClass = this.classPool.makeClass(this.metricsClassName(metricsStmt, true), parentMetricsClass);
        try {
            metricsClass.addInterface(this.classPool.get(WITH_METADATA_INTERFACE));
        }
        catch (NotFoundException e) {
            log.error("Can't find WithMetadata interface for " + className + ".", (Throwable)e);
            throw new OALCompileException(e.getMessage(), (Throwable)e);
        }
        ClassFile metricsClassClassFile = metricsClass.getClassFile();
        ConstPool constPool = metricsClassClassFile.getConstPool();
        try {
            CtConstructor defaultConstructor = CtNewConstructor.make((String)("public " + className + "() {}"), (CtClass)metricsClass);
            metricsClass.addConstructor(defaultConstructor);
        }
        catch (CannotCompileException e) {
            log.error("Can't add empty constructor in " + className + ".", (Throwable)e);
            throw new OALCompileException(e.getMessage(), (Throwable)e);
        }
        for (SourceColumn field : metricsStmt.getFieldsFromSource()) {
            try {
                CtField newField = CtField.make((String)("private " + field.getType().getName() + " " + field.getFieldName() + ";"), (CtClass)metricsClass);
                metricsClass.addField(newField);
                metricsClass.addMethod(CtNewMethod.getter((String)field.getFieldGetter(), (CtField)newField));
                metricsClass.addMethod(CtNewMethod.setter((String)field.getFieldSetter(), (CtField)newField));
                AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
                Annotation columnAnnotation = new Annotation(Column.class.getName(), constPool);
                columnAnnotation.addMemberValue("name", (MemberValue)new StringMemberValue(field.getColumnName(), constPool));
                if (field.getType().equals(String.class)) {
                    columnAnnotation.addMemberValue("length", (MemberValue)new IntegerMemberValue(constPool, field.getLength()));
                }
                annotationsAttribute.addAnnotation(columnAnnotation);
                if (field.isID()) {
                    Annotation banyanShardingKeyAnnotation = new Annotation(BanyanDB.SeriesID.class.getName(), constPool);
                    banyanShardingKeyAnnotation.addMemberValue("index", (MemberValue)new IntegerMemberValue(constPool, 0));
                    annotationsAttribute.addAnnotation(banyanShardingKeyAnnotation);
                }
                if (field.isGroupByCondInTopN()) {
                    Annotation banyanTopNAggregationAnnotation = new Annotation(BanyanDB.TopNAggregation.class.getName(), constPool);
                    annotationsAttribute.addAnnotation(banyanTopNAggregationAnnotation);
                }
                newField.getFieldInfo().addAttribute((AttributeInfo)annotationsAttribute);
            }
            catch (CannotCompileException e) {
                log.error("Can't add field(including set/get) " + field.getFieldName() + " in " + className + ".", (Throwable)e);
                throw new OALCompileException(e.getMessage(), (Throwable)e);
            }
        }
        for (String method : METRICS_CLASS_METHODS) {
            StringWriter methodEntity = new StringWriter();
            try {
                this.configuration.getTemplate("metrics/" + method + ".ftl").process((Object)metricsStmt, (Writer)methodEntity);
                metricsClass.addMethod(CtNewMethod.make((String)methodEntity.toString(), (CtClass)metricsClass));
            }
            catch (Exception e) {
                log.error("Can't generate method " + method + " for " + className + ".", (Throwable)e);
                throw new OALCompileException(e.getMessage(), (Throwable)e);
            }
        }
        AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation streamAnnotation = new Annotation(Stream.class.getName(), constPool);
        streamAnnotation.addMemberValue("name", (MemberValue)new StringMemberValue(metricsStmt.getTableName(), constPool));
        streamAnnotation.addMemberValue("scopeId", (MemberValue)new IntegerMemberValue(constPool, metricsStmt.getFrom().getSourceScopeId()));
        streamAnnotation.addMemberValue("builder", (MemberValue)new ClassMemberValue(this.metricsBuilderClassName(metricsStmt, true), constPool));
        streamAnnotation.addMemberValue("processor", (MemberValue)new ClassMemberValue(METRICS_STREAM_PROCESSOR, constPool));
        annotationsAttribute.addAnnotation(streamAnnotation);
        metricsClassClassFile.addAttribute((AttributeInfo)annotationsAttribute);
        try {
            targetClass = SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8) ? metricsClass.toClass(this.currentClassLoader, null) : metricsClass.toClass(MetricClassPackageHolder.class);
        }
        catch (CannotCompileException e) {
            log.error("Can't compile/load " + className + ".", (Throwable)e);
            throw new OALCompileException(e.getMessage(), (Throwable)e);
        }
        log.debug("Generate metrics class, " + metricsClass.getName());
        this.writeGeneratedFile(metricsClass, "metrics");
        return targetClass;
    }

    private void generateMetricsBuilderClass(AnalysisResult metricsStmt) throws OALCompileException {
        String className = this.metricsBuilderClassName(metricsStmt, false);
        CtClass metricsBuilderClass = this.classPool.makeClass(this.metricsBuilderClassName(metricsStmt, true));
        try {
            metricsBuilderClass.addInterface(this.classPool.get(this.storageBuilderFactory.builderTemplate().getSuperClass()));
        }
        catch (NotFoundException e) {
            log.error("Can't find StorageBuilder interface for " + className + ".", (Throwable)e);
            throw new OALCompileException(e.getMessage(), (Throwable)e);
        }
        try {
            CtConstructor defaultConstructor = CtNewConstructor.make((String)("public " + className + "() {}"), (CtClass)metricsBuilderClass);
            metricsBuilderClass.addConstructor(defaultConstructor);
        }
        catch (CannotCompileException e) {
            log.error("Can't add empty constructor in " + className + ".", (Throwable)e);
            throw new OALCompileException(e.getMessage(), (Throwable)e);
        }
        for (String method : METRICS_BUILDER_CLASS_METHODS) {
            StringWriter methodEntity = new StringWriter();
            try {
                this.configuration.getTemplate(this.storageBuilderFactory.builderTemplate().getTemplatePath() + "/" + method + ".ftl").process((Object)metricsStmt, (Writer)methodEntity);
                metricsBuilderClass.addMethod(CtNewMethod.make((String)methodEntity.toString(), (CtClass)metricsBuilderClass));
            }
            catch (Exception e) {
                log.error("Can't generate method " + method + " for " + className + ".", (Throwable)e);
                throw new OALCompileException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8)) {
                metricsBuilderClass.toClass(this.currentClassLoader, null);
            } else {
                metricsBuilderClass.toClass(MetricBuilderClassPackageHolder.class);
            }
        }
        catch (CannotCompileException e) {
            log.error("Can't compile/load " + className + ".", (Throwable)e);
            throw new OALCompileException(e.getMessage(), (Throwable)e);
        }
        this.writeGeneratedFile(metricsBuilderClass, "metrics/builder");
    }

    private Class generateDispatcherClass(String scopeName, DispatcherContext dispatcherContext) throws OALCompileException {
        Class targetClass;
        String className = this.dispatcherClassName(scopeName, false);
        CtClass dispatcherClass = this.classPool.makeClass(this.dispatcherClassName(scopeName, true));
        try {
            CtClass dispatcherInterface = this.classPool.get(DISPATCHER_INTERFACE);
            dispatcherClass.addInterface(dispatcherInterface);
            String sourceClassName = this.oalDefine.getSourcePackage() + dispatcherContext.getSource();
            SignatureAttribute.ClassSignature dispatcherSignature = new SignatureAttribute.ClassSignature(null, null, new SignatureAttribute.ClassType[]{new SignatureAttribute.ClassType(SourceDispatcher.class.getCanonicalName(), new SignatureAttribute.TypeArgument[]{new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)new SignatureAttribute.ClassType(sourceClassName))})});
            dispatcherClass.setGenericSignature(dispatcherSignature.encode());
        }
        catch (NotFoundException e) {
            log.error("Can't find Dispatcher interface for " + className + ".", (Throwable)e);
            throw new OALCompileException(e.getMessage(), (Throwable)e);
        }
        for (AnalysisResult dispatcherContextMetric : dispatcherContext.getMetrics()) {
            StringWriter methodEntity = new StringWriter();
            try {
                this.configuration.getTemplate("dispatcher/doMetrics.ftl").process((Object)dispatcherContextMetric, (Writer)methodEntity);
                dispatcherClass.addMethod(CtNewMethod.make((String)methodEntity.toString(), (CtClass)dispatcherClass));
            }
            catch (Exception e) {
                log.error("Can't generate method do" + dispatcherContextMetric.getMetricsName() + " for " + className + ".", (Throwable)e);
                log.error("Method body as following" + System.lineSeparator() + "{}", (Object)methodEntity);
                throw new OALCompileException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            StringWriter methodEntity = new StringWriter();
            this.configuration.getTemplate("dispatcher/dispatch.ftl").process((Object)dispatcherContext, (Writer)methodEntity);
            dispatcherClass.addMethod(CtNewMethod.make((String)methodEntity.toString(), (CtClass)dispatcherClass));
        }
        catch (Exception e) {
            log.error("Can't generate method dispatch for " + className + ".", (Throwable)e);
            throw new OALCompileException(e.getMessage(), (Throwable)e);
        }
        try {
            targetClass = SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8) ? dispatcherClass.toClass(this.currentClassLoader, null) : dispatcherClass.toClass(DispatcherClassPackageHolder.class);
        }
        catch (CannotCompileException e) {
            log.error("Can't compile/load " + className + ".", (Throwable)e);
            throw new OALCompileException(e.getMessage(), (Throwable)e);
        }
        this.writeGeneratedFile(dispatcherClass, "dispatcher");
        return targetClass;
    }

    private String metricsClassName(AnalysisResult metricsStmt, boolean fullName) {
        return (fullName ? this.oalDefine.getDynamicMetricsClassPackage() : "") + metricsStmt.getMetricsName() + "Metrics";
    }

    private String metricsBuilderClassName(AnalysisResult metricsStmt, boolean fullName) {
        return (fullName ? this.oalDefine.getDynamicMetricsBuilderClassPackage() : "") + metricsStmt.getMetricsName() + "MetricsBuilder";
    }

    private String dispatcherClassName(String scopeName, boolean fullName) {
        return (fullName ? this.oalDefine.getDynamicDispatcherClassPackage() : "") + scopeName + "Dispatcher";
    }

    private void buildDispatcherContext(AnalysisResult metricsStmt) {
        String sourceName = metricsStmt.getFrom().getSourceName();
        DispatcherContext context = this.allDispatcherContext.getAllContext().computeIfAbsent(sourceName, name -> {
            DispatcherContext absent = new DispatcherContext();
            absent.setSourcePackage(this.oalDefine.getSourcePackage());
            absent.setSource((String)name);
            absent.setPackageName(name.toLowerCase());
            return absent;
        });
        metricsStmt.setMetricsClassPackage(this.oalDefine.getDynamicMetricsClassPackage());
        metricsStmt.setSourcePackage(this.oalDefine.getSourcePackage());
        context.getMetrics().add(metricsStmt);
    }

    public void prepareRTTempFolder() {
        if (this.openEngineDebug) {
            File workPath = WorkPath.getPath();
            File folder = new File(workPath.getParentFile(), "oal-rt/");
            if (folder.exists()) {
                try {
                    FileUtils.deleteDirectory((File)folder);
                }
                catch (IOException e) {
                    log.warn("Can't delete " + folder.getAbsolutePath() + " temp folder.", (Throwable)e);
                }
            }
            folder.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGeneratedFile(CtClass metricsClass, String type) throws OALCompileException {
        if (this.openEngineDebug) {
            String className = metricsClass.getSimpleName();
            FilterOutputStream printWriter = null;
            try {
                File file;
                File folder = new File(OALClassGenerator.getGeneratedFilePath() + File.separator + type);
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                if ((file = new File(folder, className + ".class")).exists()) {
                    file.delete();
                }
                file.createNewFile();
                printWriter = new DataOutputStream(new FileOutputStream(file));
                metricsClass.toBytecode((DataOutputStream)printWriter);
                ((DataOutputStream)printWriter).flush();
            }
            catch (IOException e) {
                log.warn("Can't create " + className + ".txt, ignore.", (Throwable)e);
                return;
            }
            catch (CannotCompileException e) {
                log.warn("Can't compile " + className + ".class(should not happen), ignore.", (Throwable)e);
                return;
            }
            finally {
                if (printWriter != null) {
                    try {
                        printWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void setCurrentClassLoader(ClassLoader currentClassLoader) {
        this.currentClassLoader = currentClassLoader;
    }

    public void setStorageBuilderFactory(StorageBuilderFactory storageBuilderFactory) {
        this.storageBuilderFactory = storageBuilderFactory;
    }

    public static void setGeneratedFilePath(String generatedFilePath) {
        GENERATED_FILE_PATH = generatedFilePath;
    }

    public static String getGeneratedFilePath() {
        if (GENERATED_FILE_PATH == null) {
            return String.valueOf(new File(WorkPath.getPath().getParentFile(), "oal-rt/"));
        }
        return GENERATED_FILE_PATH;
    }

    public OALDefine getOalDefine() {
        return this.oalDefine;
    }

    public void setOpenEngineDebug(boolean debug) {
        this.openEngineDebug = debug;
    }
}

