/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.PublicSpi;
import graphql.SerializationError;
import graphql.TrivialDataFetcher;
import graphql.TypeMismatchError;
import graphql.UnresolvedTypeError;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.AbortExecutionException;
import graphql.execution.Async;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStepInfoFactory;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FetchedValue;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.FieldValueInfo;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.NonNullableFieldValidator;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.ResolveType;
import graphql.execution.ResultPath;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.UnresolvedTypeException;
import graphql.execution.ValuesResolver;
import graphql.execution.directives.QueryDirectivesImpl;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationFieldCompleteParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldParameters;
import graphql.extensions.ExtensionsBuilder;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.ExecutableNormalizedOperation;
import graphql.schema.CoercingSerializeException;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.DataFetchingFieldSelectionSetImpl;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.LightDataFetcher;
import graphql.util.FpKit;
import graphql.util.LogKit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicSpi
public abstract class ExecutionStrategy {
    private static final Logger log = LoggerFactory.getLogger(ExecutionStrategy.class);
    private static final Logger logNotSafe = LogKit.getNotPrivacySafeLogger(ExecutionStrategy.class);
    protected final FieldCollector fieldCollector = new FieldCollector();
    protected final ExecutionStepInfoFactory executionStepInfoFactory = new ExecutionStepInfoFactory();
    private final ResolveType resolvedType = new ResolveType();
    protected final DataFetcherExceptionHandler dataFetcherExceptionHandler;

    protected ExecutionStrategy() {
        this.dataFetcherExceptionHandler = new SimpleDataFetcherExceptionHandler();
    }

    protected ExecutionStrategy(DataFetcherExceptionHandler dataFetcherExceptionHandler) {
        this.dataFetcherExceptionHandler = dataFetcherExceptionHandler;
    }

    public abstract CompletableFuture<ExecutionResult> execute(ExecutionContext var1, ExecutionStrategyParameters var2) throws NonNullableFieldWasNullException;

    protected CompletableFuture<ExecutionResult> resolveField(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        return this.resolveFieldWithInfo(executionContext, parameters).thenCompose(FieldValueInfo::getFieldValue);
    }

    protected CompletableFuture<FieldValueInfo> resolveFieldWithInfo(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext, parameters, parameters.getField().getSingleField());
        Supplier<ExecutionStepInfo> executionStepInfo = FpKit.intraThreadMemoize(() -> this.createExecutionStepInfo(executionContext, parameters, fieldDef, null));
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext<ExecutionResult> fieldCtx = SimpleInstrumentationContext.nonNullCtx(instrumentation.beginField(new InstrumentationFieldParameters(executionContext, executionStepInfo), executionContext.getInstrumentationState()));
        CompletableFuture<FetchedValue> fetchFieldFuture = this.fetchField(executionContext, parameters);
        CompletionStage result = fetchFieldFuture.thenApply(fetchedValue -> this.completeField(executionContext, parameters, (FetchedValue)fetchedValue));
        CompletionStage executionResultFuture = ((CompletableFuture)result).thenCompose(FieldValueInfo::getFieldValue);
        fieldCtx.onDispatched((CompletableFuture<ExecutionResult>)executionResultFuture);
        ((CompletableFuture)executionResultFuture).whenComplete(fieldCtx::onCompleted);
        return result;
    }

    protected CompletableFuture<FetchedValue> fetchField(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        MergedField field = parameters.getField();
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field.getSingleField());
        GraphQLCodeRegistry codeRegistry = executionContext.getGraphQLSchema().getCodeRegistry();
        Supplier<DataFetchingEnvironment> dataFetchingEnvironment = FpKit.intraThreadMemoize(() -> {
            Supplier<ExecutionStepInfo> executionStepInfo = FpKit.intraThreadMemoize(() -> this.createExecutionStepInfo(executionContext, parameters, fieldDef, parentType));
            Supplier<Map<String, Object>> argumentValues = () -> ((ExecutionStepInfo)executionStepInfo.get()).getArguments();
            Supplier<ExecutableNormalizedField> normalizedFieldSupplier = this.getNormalizedField(executionContext, parameters, executionStepInfo);
            DataFetchingFieldSelectionSet fieldCollector = DataFetchingFieldSelectionSetImpl.newCollector(executionContext.getGraphQLSchema(), fieldDef.getType(), normalizedFieldSupplier);
            QueryDirectivesImpl queryDirectives = new QueryDirectivesImpl(field, executionContext.getGraphQLSchema(), executionContext.getCoercedVariables().toMap(), executionContext.getGraphQLContext(), executionContext.getLocale());
            return DataFetchingEnvironmentImpl.newDataFetchingEnvironment(executionContext).source(parameters.getSource()).localContext(parameters.getLocalContext()).arguments(argumentValues).fieldDefinition(fieldDef).mergedField(parameters.getField()).fieldType(fieldDef.getType()).executionStepInfo(executionStepInfo).parentType(parentType).selectionSet(fieldCollector).queryDirectives(queryDirectives).build();
        });
        DataFetcher<?> dataFetcher = codeRegistry.getDataFetcher(parentType, fieldDef);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationFieldFetchParameters instrumentationFieldFetchParams = new InstrumentationFieldFetchParameters(executionContext, dataFetchingEnvironment, parameters, dataFetcher instanceof TrivialDataFetcher);
        InstrumentationContext<Object> fetchCtx = SimpleInstrumentationContext.nonNullCtx(instrumentation.beginFieldFetch(instrumentationFieldFetchParams, executionContext.getInstrumentationState()));
        dataFetcher = instrumentation.instrumentDataFetcher(dataFetcher, instrumentationFieldFetchParams, executionContext.getInstrumentationState());
        CompletableFuture<Object> fetchedValue = this.invokeDataFetcher(executionContext, parameters, fieldDef, dataFetchingEnvironment, dataFetcher);
        fetchCtx.onDispatched(fetchedValue);
        return ((CompletableFuture)((CompletableFuture)fetchedValue.handle((result, exception) -> {
            fetchCtx.onCompleted(result, (Throwable)exception);
            if (exception != null) {
                return this.handleFetchingException((DataFetchingEnvironment)dataFetchingEnvironment.get(), (Throwable)exception);
            }
            return fetchedValue;
        })).thenCompose(Function.identity())).thenApply(result -> this.unboxPossibleDataFetcherResult(executionContext, parameters, result));
    }

    private CompletableFuture<Object> invokeDataFetcher(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLFieldDefinition fieldDef, Supplier<DataFetchingEnvironment> dataFetchingEnvironment, DataFetcher<?> dataFetcher) {
        CompletableFuture<Object> fetchedValue;
        try {
            Object fetchedValueRaw = dataFetcher instanceof LightDataFetcher ? ((LightDataFetcher)dataFetcher).get(fieldDef, parameters.getSource(), dataFetchingEnvironment) : dataFetcher.get(dataFetchingEnvironment.get());
            fetchedValue = Async.toCompletableFuture(fetchedValueRaw);
        }
        catch (Exception e) {
            if (logNotSafe.isDebugEnabled()) {
                logNotSafe.debug(String.format("'%s', field '%s' fetch threw exception", executionContext.getExecutionId(), parameters.getPath()), (Throwable)e);
            }
            fetchedValue = Async.exceptionallyCompletedFuture(e);
        }
        return fetchedValue;
    }

    protected Supplier<ExecutableNormalizedField> getNormalizedField(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Supplier<ExecutionStepInfo> executionStepInfo) {
        Supplier<ExecutableNormalizedOperation> normalizedQuery = executionContext.getNormalizedQueryTree();
        return () -> ((ExecutableNormalizedOperation)normalizedQuery.get()).getNormalizedField(parameters.getField(), ((ExecutionStepInfo)executionStepInfo.get()).getObjectType(), ((ExecutionStepInfo)executionStepInfo.get()).getPath());
    }

    protected FetchedValue unboxPossibleDataFetcherResult(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object result) {
        if (result instanceof DataFetcherResult) {
            DataFetcherResult dataFetcherResult = (DataFetcherResult)result;
            executionContext.addErrors(dataFetcherResult.getErrors());
            this.addExtensionsIfPresent(executionContext, dataFetcherResult);
            Object localContext = dataFetcherResult.getLocalContext();
            if (localContext == null) {
                localContext = parameters.getLocalContext();
            }
            return FetchedValue.newFetchedValue().fetchedValue(executionContext.getValueUnboxer().unbox(dataFetcherResult.getData())).rawFetchedValue(dataFetcherResult.getData()).errors(dataFetcherResult.getErrors()).localContext(localContext).build();
        }
        return FetchedValue.newFetchedValue().fetchedValue(executionContext.getValueUnboxer().unbox(result)).rawFetchedValue(result).localContext(parameters.getLocalContext()).build();
    }

    private void addExtensionsIfPresent(ExecutionContext executionContext, DataFetcherResult<?> dataFetcherResult) {
        ExtensionsBuilder extensionsBuilder;
        Map<Object, Object> extensions = dataFetcherResult.getExtensions();
        if (extensions != null && (extensionsBuilder = (ExtensionsBuilder)executionContext.getGraphQLContext().get(ExtensionsBuilder.class)) != null) {
            extensionsBuilder.addValues(extensions);
        }
    }

    protected <T> CompletableFuture<T> handleFetchingException(DataFetchingEnvironment environment, Throwable e) {
        DataFetcherExceptionHandlerParameters handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(environment).exception(e).build();
        try {
            return this.asyncHandleException(this.dataFetcherExceptionHandler, handlerParameters);
        }
        catch (Exception handlerException) {
            handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(environment).exception(handlerException).build();
            return this.asyncHandleException(new SimpleDataFetcherExceptionHandler(), handlerParameters);
        }
    }

    private <T> CompletableFuture<T> asyncHandleException(DataFetcherExceptionHandler handler, DataFetcherExceptionHandlerParameters handlerParameters) {
        return handler.handleException(handlerParameters).thenApply(handlerResult -> DataFetcherResult.newResult().errors(handlerResult.getErrors()).build());
    }

    protected FieldValueInfo completeField(ExecutionContext executionContext, ExecutionStrategyParameters parameters, FetchedValue fetchedValue) {
        Field field = parameters.getField().getSingleField();
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
        ExecutionStepInfo executionStepInfo = this.createExecutionStepInfo(executionContext, parameters, fieldDef, parentType);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationFieldCompleteParameters instrumentationParams = new InstrumentationFieldCompleteParameters(executionContext, parameters, () -> executionStepInfo, fetchedValue);
        InstrumentationContext<ExecutionResult> ctxCompleteField = SimpleInstrumentationContext.nonNullCtx(instrumentation.beginFieldComplete(instrumentationParams, executionContext.getInstrumentationState()));
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, executionStepInfo);
        ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.executionStepInfo(executionStepInfo).source(fetchedValue.getFetchedValue()).localContext(fetchedValue.getLocalContext()).nonNullFieldValidator(nonNullableFieldValidator));
        if (log.isDebugEnabled()) {
            log.debug("'{}' completing field '{}'...", (Object)executionContext.getExecutionId(), (Object)executionStepInfo.getPath());
        }
        FieldValueInfo fieldValueInfo = this.completeValue(executionContext, newParameters);
        CompletableFuture<ExecutionResult> executionResultFuture = fieldValueInfo.getFieldValue();
        ctxCompleteField.onDispatched(executionResultFuture);
        executionResultFuture.whenComplete(ctxCompleteField::onCompleted);
        return fieldValueInfo;
    }

    protected FieldValueInfo completeValue(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        CompletableFuture<ExecutionResult> fieldValue;
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        Object result = executionContext.getValueUnboxer().unbox(parameters.getSource());
        GraphQLOutputType fieldType = executionStepInfo.getUnwrappedNonNullType();
        if (result == null) {
            return this.getFieldValueInfoForNull(executionContext, parameters);
        }
        if (GraphQLTypeUtil.isList(fieldType)) {
            return this.completeValueForList(executionContext, parameters, result);
        }
        if (GraphQLTypeUtil.isScalar(fieldType)) {
            CompletableFuture<ExecutionResult> fieldValue2 = this.completeValueForScalar(executionContext, parameters, (GraphQLScalarType)fieldType, result);
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.SCALAR).fieldValue(fieldValue2).build();
        }
        if (GraphQLTypeUtil.isEnum(fieldType)) {
            CompletableFuture<ExecutionResult> fieldValue3 = this.completeValueForEnum(executionContext, parameters, (GraphQLEnumType)fieldType, result);
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.ENUM).fieldValue(fieldValue3).build();
        }
        try {
            GraphQLObjectType resolvedObjectType = this.resolveType(executionContext, parameters, fieldType);
            fieldValue = this.completeValueForObject(executionContext, parameters, resolvedObjectType, result);
        }
        catch (UnresolvedTypeException ex) {
            this.handleUnresolvedTypeProblem(executionContext, parameters, ex);
            return this.getFieldValueInfoForNull(executionContext, parameters);
        }
        return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.OBJECT).fieldValue(fieldValue).build();
    }

    private void handleUnresolvedTypeProblem(ExecutionContext context, ExecutionStrategyParameters parameters, UnresolvedTypeException e) {
        UnresolvedTypeError error = new UnresolvedTypeError(parameters.getPath(), parameters.getExecutionStepInfo(), e);
        logNotSafe.warn(error.getMessage(), (Throwable)e);
        context.addError(error);
    }

    private FieldValueInfo getFieldValueInfoForNull(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        CompletableFuture<ExecutionResult> fieldValue = this.completeValueForNull(executionContext, parameters);
        return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.NULL).fieldValue(fieldValue).build();
    }

    protected CompletableFuture<ExecutionResult> completeValueForNull(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        return Async.tryCatch(() -> {
            Object nullValue = parameters.getNonNullFieldValidator().validate(parameters.getPath(), null);
            return CompletableFuture.completedFuture(new ExecutionResultImpl(nullValue, executionContext.getErrors()));
        });
    }

    protected FieldValueInfo completeValueForList(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object result) {
        Iterable<Object> resultIterable = this.toIterable(executionContext, parameters, result);
        try {
            resultIterable = parameters.getNonNullFieldValidator().validate(parameters.getPath(), resultIterable);
        }
        catch (NonNullableFieldWasNullException e) {
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.LIST).fieldValue(Async.exceptionallyCompletedFuture(e)).build();
        }
        if (resultIterable == null) {
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.LIST).fieldValue(CompletableFuture.completedFuture(new ExecutionResultImpl(null, executionContext.getErrors()))).build();
        }
        return this.completeValueForList(executionContext, parameters, resultIterable);
    }

    protected FieldValueInfo completeValueForList(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Iterable<Object> iterableValues) {
        OptionalInt size = FpKit.toSize(iterableValues);
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        InstrumentationFieldCompleteParameters instrumentationParams = new InstrumentationFieldCompleteParameters(executionContext, parameters, () -> executionStepInfo, iterableValues);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext<ExecutionResult> completeListCtx = SimpleInstrumentationContext.nonNullCtx(instrumentation.beginFieldListComplete(instrumentationParams, executionContext.getInstrumentationState()));
        ArrayList<FieldValueInfo> fieldValueInfos = new ArrayList<FieldValueInfo>(size.orElse(1));
        int index = 0;
        for (Object item : iterableValues) {
            ResultPath indexedPath = parameters.getPath().segment(index);
            ExecutionStepInfo stepInfoForListElement = this.executionStepInfoFactory.newExecutionStepInfoForListElement(executionStepInfo, indexedPath);
            NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, stepInfoForListElement);
            FetchedValue value = this.unboxPossibleDataFetcherResult(executionContext, parameters, item);
            ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.executionStepInfo(stepInfoForListElement).nonNullFieldValidator(nonNullableFieldValidator).localContext(value.getLocalContext()).path(indexedPath).source(value.getFetchedValue()));
            fieldValueInfos.add(this.completeValue(executionContext, newParameters));
            ++index;
        }
        CompletableFuture resultsFuture = Async.each(fieldValueInfos, FieldValueInfo::getFieldValue);
        CompletableFuture<ExecutionResult> overallResult = new CompletableFuture<ExecutionResult>();
        completeListCtx.onDispatched(overallResult);
        resultsFuture.whenComplete((results, exception) -> {
            if (exception != null) {
                ExecutionResult executionResult = this.handleNonNullException(executionContext, overallResult, (Throwable)exception);
                completeListCtx.onCompleted(executionResult, (Throwable)exception);
                return;
            }
            ArrayList completedResults = new ArrayList(results.size());
            for (ExecutionResult completedValue : results) {
                completedResults.add(completedValue.getData());
            }
            ExecutionResultImpl executionResult = new ExecutionResultImpl(completedResults, executionContext.getErrors());
            overallResult.complete(executionResult);
        });
        overallResult.whenComplete(completeListCtx::onCompleted);
        return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.LIST).fieldValue(overallResult).fieldValueInfos(fieldValueInfos).build();
    }

    protected CompletableFuture<ExecutionResult> completeValueForScalar(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLScalarType scalarType, Object result) {
        Object serialized;
        try {
            serialized = scalarType.getCoercing().serialize(result, executionContext.getGraphQLContext(), executionContext.getLocale());
        }
        catch (CoercingSerializeException e) {
            serialized = this.handleCoercionProblem(executionContext, parameters, e);
        }
        try {
            serialized = parameters.getNonNullFieldValidator().validate(parameters.getPath(), serialized);
        }
        catch (NonNullableFieldWasNullException e) {
            return Async.exceptionallyCompletedFuture(e);
        }
        return CompletableFuture.completedFuture(new ExecutionResultImpl(serialized, executionContext.getErrors()));
    }

    protected CompletableFuture<ExecutionResult> completeValueForEnum(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLEnumType enumType, Object result) {
        Object serialized;
        try {
            serialized = enumType.serialize(result, executionContext.getGraphQLContext(), executionContext.getLocale());
        }
        catch (CoercingSerializeException e) {
            serialized = this.handleCoercionProblem(executionContext, parameters, e);
        }
        try {
            serialized = parameters.getNonNullFieldValidator().validate(parameters.getPath(), serialized);
        }
        catch (NonNullableFieldWasNullException e) {
            return Async.exceptionallyCompletedFuture(e);
        }
        return CompletableFuture.completedFuture(new ExecutionResultImpl(serialized, executionContext.getErrors()));
    }

    protected CompletableFuture<ExecutionResult> completeValueForObject(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLObjectType resolvedObjectType, Object result) {
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters().schema(executionContext.getGraphQLSchema()).objectType(resolvedObjectType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getCoercedVariables().toMap()).build();
        MergedSelectionSet subFields = this.fieldCollector.collectFields(collectorParameters, parameters.getField());
        ExecutionStepInfo newExecutionStepInfo = executionStepInfo.changeTypeWithPreservedNonNull(resolvedObjectType);
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, newExecutionStepInfo);
        ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.executionStepInfo(newExecutionStepInfo).fields(subFields).nonNullFieldValidator(nonNullableFieldValidator).source(result));
        return executionContext.getQueryStrategy().execute(executionContext, newParameters);
    }

    private Object handleCoercionProblem(ExecutionContext context, ExecutionStrategyParameters parameters, CoercingSerializeException e) {
        SerializationError error = new SerializationError(parameters.getPath(), e);
        logNotSafe.warn(error.getMessage(), (Throwable)e);
        context.addError(error);
        return null;
    }

    protected GraphQLObjectType resolveType(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLType fieldType) {
        if (fieldType instanceof GraphQLObjectType) {
            return (GraphQLObjectType)fieldType;
        }
        return this.resolvedType.resolveType(executionContext, parameters.getField(), parameters.getSource(), parameters.getExecutionStepInfo(), fieldType, parameters.getLocalContext());
    }

    protected Iterable<Object> toIterable(ExecutionContext context, ExecutionStrategyParameters parameters, Object result) {
        if (FpKit.isIterable(result)) {
            return FpKit.toIterable(result);
        }
        this.handleTypeMismatchProblem(context, parameters, result);
        return null;
    }

    private void handleTypeMismatchProblem(ExecutionContext context, ExecutionStrategyParameters parameters, Object result) {
        TypeMismatchError error = new TypeMismatchError(parameters.getPath(), parameters.getExecutionStepInfo().getUnwrappedNonNullType());
        logNotSafe.warn("{} got {}", (Object)error.getMessage(), result.getClass());
        context.addError(error);
    }

    protected GraphQLFieldDefinition getFieldDef(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Field field) {
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        return this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
    }

    protected GraphQLFieldDefinition getFieldDef(GraphQLSchema schema, GraphQLObjectType parentType, Field field) {
        return Introspection.getFieldDef(schema, parentType, field.getName());
    }

    protected void assertNonNullFieldPrecondition(NonNullableFieldWasNullException e) throws NonNullableFieldWasNullException {
        ExecutionStepInfo executionStepInfo = e.getExecutionStepInfo();
        if (executionStepInfo.hasParent() && executionStepInfo.getParent().isNonNullType()) {
            throw new NonNullableFieldWasNullException(e);
        }
    }

    protected void assertNonNullFieldPrecondition(NonNullableFieldWasNullException e, CompletableFuture<?> completableFuture) throws NonNullableFieldWasNullException {
        ExecutionStepInfo executionStepInfo = e.getExecutionStepInfo();
        if (executionStepInfo.hasParent() && executionStepInfo.getParent().isNonNullType()) {
            completableFuture.completeExceptionally(new NonNullableFieldWasNullException(e));
        }
    }

    protected ExecutionResult handleNonNullException(ExecutionContext executionContext, CompletableFuture<ExecutionResult> result, Throwable e) {
        ExecutionResult executionResult = null;
        ImmutableList<GraphQLError> errors = ImmutableList.copyOf(executionContext.getErrors());
        Throwable underlyingException = e;
        if (e instanceof CompletionException) {
            underlyingException = e.getCause();
        }
        if (underlyingException instanceof NonNullableFieldWasNullException) {
            this.assertNonNullFieldPrecondition((NonNullableFieldWasNullException)underlyingException, result);
            if (!result.isDone()) {
                executionResult = new ExecutionResultImpl(null, errors);
                result.complete(executionResult);
            }
        } else if (underlyingException instanceof AbortExecutionException) {
            AbortExecutionException abortException = (AbortExecutionException)underlyingException;
            executionResult = abortException.toExecutionResult();
            result.complete(executionResult);
        } else {
            result.completeExceptionally(e);
        }
        return executionResult;
    }

    protected ExecutionStepInfo createExecutionStepInfo(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLFieldDefinition fieldDefinition, GraphQLObjectType fieldContainer) {
        MergedField field = parameters.getField();
        ExecutionStepInfo parentStepInfo = parameters.getExecutionStepInfo();
        GraphQLOutputType fieldType = fieldDefinition.getType();
        List<GraphQLArgument> fieldArgDefs = fieldDefinition.getArguments();
        Supplier<Map<String, Object>> argumentValues = ImmutableKit::emptyMap;
        if (!fieldArgDefs.isEmpty()) {
            List<Argument> fieldArgs = field.getArguments();
            GraphQLCodeRegistry codeRegistry = executionContext.getGraphQLSchema().getCodeRegistry();
            Supplier<Map> argValuesSupplier = () -> ValuesResolver.getArgumentValues(codeRegistry, fieldArgDefs, fieldArgs, executionContext.getCoercedVariables(), executionContext.getGraphQLContext(), executionContext.getLocale());
            argumentValues = FpKit.intraThreadMemoize(argValuesSupplier);
        }
        return ExecutionStepInfo.newExecutionStepInfo().type(fieldType).fieldDefinition(fieldDefinition).fieldContainer(fieldContainer).field(field).path(parameters.getPath()).parentInfo(parentStepInfo).arguments(argumentValues).build();
    }

    @Internal
    public static String mkNameForPath(Field currentField) {
        return ExecutionStrategy.mkNameForPath(Collections.singletonList(currentField));
    }

    @Internal
    public static String mkNameForPath(MergedField mergedField) {
        return ExecutionStrategy.mkNameForPath(mergedField.getFields());
    }

    @Internal
    public static String mkNameForPath(List<Field> currentField) {
        Field field = currentField.get(0);
        return field.getResultKey();
    }
}

