/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.module;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.skywalking.oap.server.library.module.ApplicationConfiguration;
import org.apache.skywalking.oap.server.library.module.DuplicateProviderException;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleConfigException;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleProviderHolder;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ProviderNotFoundException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.module.TerminalFriendlyTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModuleDefine
implements ModuleProviderHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleDefine.class);
    private ModuleProvider loadedProvider = null;
    private final String name;

    public ModuleDefine(String name) {
        this.name = name;
    }

    public final String name() {
        return this.name;
    }

    public abstract Class[] services();

    void prepare(ModuleManager moduleManager, ApplicationConfiguration.ModuleConfiguration configuration, ServiceLoader<ModuleProvider> moduleProviderLoader, TerminalFriendlyTable bootingParameters) throws ProviderNotFoundException, ServiceNotProvidedException, ModuleConfigException, ModuleStartException {
        for (ModuleProvider provider : moduleProviderLoader) {
            if (!configuration.has(provider.name()) || !provider.module().equals(this.getClass())) continue;
            if (this.loadedProvider == null) {
                this.loadedProvider = provider;
                this.loadedProvider.setManager(moduleManager);
                this.loadedProvider.setModuleDefine(this);
                this.loadedProvider.setBootingParameters(bootingParameters);
                continue;
            }
            throw new DuplicateProviderException(this.name() + " module has one " + this.loadedProvider.name() + "[" + this.loadedProvider.getClass().getName() + "] provider already, " + provider.name() + "[" + provider.getClass().getName() + "] is defined as 2nd provider.");
        }
        if (this.loadedProvider == null) {
            throw new ProviderNotFoundException(this.name() + " module no provider found.");
        }
        LOGGER.info("Prepare the {} provider in {} module.", (Object)this.loadedProvider.name(), (Object)this.name());
        try {
            Class<? extends ModuleConfig> typeOfConfig;
            ModuleProvider.ConfigCreator<? extends ModuleConfig> creator = this.loadedProvider.newConfigCreator();
            if (creator != null && (typeOfConfig = creator.type()) != null) {
                ModuleConfig config = typeOfConfig.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.copyProperties(config, configuration.getProviderConfiguration(this.loadedProvider.name()), this.name(), this.loadedProvider.name());
                creator.onInitialized(config);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ModuleConfigException(this.name() + " module config transport to config bean failure.", e);
        }
        this.loadedProvider.prepare();
    }

    private void copyProperties(ModuleConfig dest, Properties src, String moduleName, String providerName) throws IllegalAccessException {
        if (dest == null) {
            return;
        }
        Enumeration<?> propertyNames = src.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            Class<?> destClass = dest.getClass();
            try {
                Field field = this.getDeclaredField(destClass, propertyName);
                field.setAccessible(true);
                field.set(dest, src.get(propertyName));
            }
            catch (NoSuchFieldException e) {
                LOGGER.warn(propertyName + " setting is not supported in " + providerName + " provider of " + moduleName + " module");
            }
        }
    }

    private Field getDeclaredField(Class<?> destClass, String fieldName) throws NoSuchFieldException {
        if (destClass != null) {
            Field[] fields;
            for (Field field : fields = destClass.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
            return this.getDeclaredField(destClass.getSuperclass(), fieldName);
        }
        throw new NoSuchFieldException();
    }

    @Override
    public final ModuleProvider provider() throws DuplicateProviderException, ProviderNotFoundException {
        if (this.loadedProvider == null) {
            throw new ProviderNotFoundException("There is no module provider in " + this.name() + " module!");
        }
        return this.loadedProvider;
    }
}

