/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.webhook;

import com.google.gson.Gson;
import java.net.URI;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.HttpAlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.webhook.WebhookSettings;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookCallback
extends HttpAlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebhookCallback.class);
    private final AlarmRulesWatcher alarmRulesWatcher;
    private final Gson gson = new Gson();

    public void doAlarm(List<AlarmMessage> alarmMessages) throws Exception {
        Map<String, WebhookSettings> settingsMap = this.alarmRulesWatcher.getWebHooks();
        if (settingsMap == null || settingsMap.isEmpty()) {
            return;
        }
        Map groupedMessages = this.groupMessagesByHook(alarmMessages);
        for (Map.Entry entry : groupedMessages.entrySet()) {
            String hookName = (String)entry.getKey();
            List messages = (List)entry.getValue();
            WebhookSettings setting = settingsMap.get(hookName);
            if (setting == null || CollectionUtils.isEmpty(setting.getUrls()) || CollectionUtils.isEmpty((List)messages)) continue;
            for (String url : setting.getUrls()) {
                try {
                    this.post(URI.create(url), this.gson.toJson((Object)messages), Map.of());
                }
                catch (Exception e) {
                    log.error("Failed to send alarm message to Webhook: {}", (Object)url, (Object)e);
                }
            }
        }
    }

    @Generated
    public WebhookCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
    }
}

