/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.expr.rt;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.mqe.rt.MQEVisitorBase;
import org.apache.skywalking.mqe.rt.grammar.MQEParser;
import org.apache.skywalking.mqe.rt.type.ExpressionResult;
import org.apache.skywalking.mqe.rt.type.ExpressionResultType;
import org.apache.skywalking.mqe.rt.type.MQEValue;
import org.apache.skywalking.mqe.rt.type.MQEValues;
import org.apache.skywalking.mqe.rt.type.Metadata;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.DoubleValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.LabeledValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MultiIntValuesHolder;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmMQEVisitor
extends MQEVisitorBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmMQEVisitor.class);
    private final LinkedList<Map<String, Metrics>> metricsValues;
    private final Map<String, Map<String, Double>> commonValuesMap;
    private final Map<String, Map<String, DataTable>> labeledValuesMap;
    private final int windowSize;
    private final LocalDateTime endTime;
    private final ArrayList<String> windowTimes;
    private final int maxTrendRange;

    public AlarmMQEVisitor(LinkedList<Map<String, Metrics>> metricsValues, LocalDateTime endTime, int maxTrendRange) {
        super(Step.MINUTE);
        this.metricsValues = metricsValues;
        this.commonValuesMap = new HashMap<String, Map<String, Double>>();
        this.labeledValuesMap = new HashMap<String, Map<String, DataTable>>();
        this.endTime = endTime;
        this.windowSize = metricsValues.size();
        this.windowTimes = this.initWindowTimes();
        this.maxTrendRange = maxTrendRange;
        this.initMetricsValues();
    }

    public ExpressionResult visitMetric(MQEParser.MetricContext ctx) {
        List<MQEValues> mqeValuesList;
        ExpressionResult result = new ExpressionResult();
        String metricName = ctx.metricName().getText();
        Optional valueColumn = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(metricName);
        if (valueColumn.isEmpty()) {
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError("Metric: [" + metricName + "] dose not exist.");
            return result;
        }
        Column.ValueDataType dataType = ((ValueColumnMetadata.ValueColumn)valueColumn.get()).getDataType();
        if (dataType == Column.ValueDataType.COMMON_VALUE) {
            Map<String, Double> timeValues = this.commonValuesMap.get(metricName);
            mqeValuesList = CollectionUtils.isEmpty(timeValues) ? this.buildEmptyMQEValuesList() : this.buildMqeValuesList(timeValues);
        } else if (dataType == Column.ValueDataType.LABELED_VALUE) {
            Map<String, DataTable> timeValues;
            String labelValue;
            String labelValueTrim;
            List<String> labelValues = Collections.emptyList();
            if (ctx.label() != null && StringUtil.isNotBlank((String)(labelValueTrim = (labelValue = ctx.label().labelValue().getText()).substring(1, labelValue.length() - 1)))) {
                labelValues = Arrays.asList(labelValueTrim.split(","));
            }
            mqeValuesList = CollectionUtils.isEmpty(timeValues = this.labeledValuesMap.get(metricName)) ? this.buildEmptyLabeledMQEValuesList(labelValues) : this.buildLabledMqeValuesList(timeValues, labelValues);
            result.setLabeledResult(true);
        } else {
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError("Unsupported value type: " + dataType);
            return result;
        }
        if (!(ctx.parent instanceof MQEParser.TrendOPContext)) {
            result.getResults().forEach(resultValues -> {
                List mqeValues = resultValues.getValues();
                if (this.maxTrendRange > 0 && mqeValues.size() > this.maxTrendRange) {
                    resultValues.setValues(mqeValues.subList(this.maxTrendRange, mqeValues.size()));
                }
            });
        }
        result.setResults(mqeValuesList);
        result.setType(ExpressionResultType.TIME_SERIES_VALUES);
        return result;
    }

    public ExpressionResult visitTrendOP(MQEParser.TrendOPContext ctx) {
        ExpressionResult result = super.visitTrendOP(ctx);
        int trendRange = Integer.parseInt(ctx.INTEGER().getText());
        int trimIndex = this.maxTrendRange - trendRange;
        if (trimIndex > 0) {
            result.getResults().forEach(resultValues -> {
                List mqeValues = resultValues.getValues();
                if (mqeValues.size() > trimIndex) {
                    resultValues.setValues(mqeValues.subList(trimIndex, mqeValues.size()));
                }
            });
        }
        return result;
    }

    private ArrayList<String> initWindowTimes() {
        ArrayList<String> windowTimes = new ArrayList<String>();
        for (int i = this.windowSize - 1; i >= 0; --i) {
            windowTimes.add(this.endTime.minusMinutes(i).toString("yyyyMMddHHmm"));
        }
        return windowTimes;
    }

    private void initMetricsValues() {
        for (Map map : this.metricsValues) {
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                String metricName = (String)entry.getKey();
                Metrics metrics = (Metrics)entry.getValue();
                if (metrics instanceof LongValueHolder) {
                    this.initCommonMetricValues(metricName, ((LongValueHolder)metrics).getValue(), metrics.getTimeBucket());
                    continue;
                }
                if (metrics instanceof IntValueHolder) {
                    this.initCommonMetricValues(metricName, ((IntValueHolder)metrics).getValue(), metrics.getTimeBucket());
                    continue;
                }
                if (metrics instanceof DoubleValueHolder) {
                    this.initCommonMetricValues(metricName, ((DoubleValueHolder)metrics).getValue(), metrics.getTimeBucket());
                    continue;
                }
                if (metrics instanceof MultiIntValuesHolder) {
                    int[] ivalueArray = ((MultiIntValuesHolder)metrics).getValues();
                    DataTable values = new DataTable();
                    for (int i = 0; i < ivalueArray.length; ++i) {
                        values.put(String.valueOf(i), Long.valueOf(ivalueArray[i]));
                    }
                    this.initLabeledMetricValues(metricName, values, metrics.getTimeBucket());
                    continue;
                }
                if (metrics instanceof LabeledValueHolder) {
                    DataTable values = ((LabeledValueHolder)metrics).getValue();
                    this.initLabeledMetricValues(metricName, values, metrics.getTimeBucket());
                    continue;
                }
                log.warn("Unsupported metrics {}", (Object)metricName);
                return;
            }
        }
    }

    private void initCommonMetricValues(String metricName, double value, long timeBucket) {
        Map timeValues = this.commonValuesMap.computeIfAbsent(metricName, v -> new HashMap());
        timeValues.put(String.valueOf(timeBucket), value);
    }

    private void initLabeledMetricValues(String metricName, DataTable values, long timeBucket) {
        Map timeValues = this.labeledValuesMap.computeIfAbsent(metricName, v -> new HashMap());
        timeValues.put(String.valueOf(timeBucket), values);
    }

    private List<MQEValues> buildMqeValuesList(Map<String, Double> timeValues) {
        ArrayList<MQEValues> mqeValuesList = new ArrayList<MQEValues>();
        MQEValues mqeValues = new MQEValues();
        for (String time : this.windowTimes) {
            Metadata metadata = new Metadata();
            Double metricValue = timeValues.get(time);
            MQEValue mqeValue = new MQEValue();
            mqeValue.setId(time);
            if (metricValue != null) {
                mqeValue.setDoubleValue(metricValue.doubleValue());
            } else {
                mqeValue.setEmptyValue(true);
            }
            mqeValues.setMetric(metadata);
            mqeValues.getValues().add(mqeValue);
        }
        mqeValuesList.add(mqeValues);
        return mqeValuesList;
    }

    private List<MQEValues> buildLabledMqeValuesList(Map<String, DataTable> timeValues, List<String> labelValues) {
        ArrayList<MQEValues> mqeValuesList = new ArrayList<MQEValues>();
        List<String> allLabelValues = CollectionUtils.isEmpty(labelValues) || labelValues.stream().allMatch(Strings::isNullOrEmpty) ? timeValues.values().stream().flatMap(dataTable -> dataTable.keys().stream()).distinct().collect(Collectors.toList()) : labelValues;
        for (String label : allLabelValues) {
            MQEValues mqeValues = new MQEValues();
            for (String time : this.windowTimes) {
                Metadata metadata = new Metadata();
                DataTable dataTable2 = timeValues.getOrDefault(time, new DataTable());
                Long metricValue = dataTable2.get(label);
                MQEValue mqeValue = new MQEValue();
                mqeValue.setId(time);
                if (metricValue != null) {
                    mqeValue.setDoubleValue((double)metricValue.longValue());
                } else {
                    mqeValue.setEmptyValue(true);
                }
                KeyValue labelValue = new KeyValue("_", label);
                metadata.getLabels().add(labelValue);
                mqeValues.setMetric(metadata);
                mqeValues.getValues().add(mqeValue);
            }
            mqeValuesList.add(mqeValues);
        }
        return mqeValuesList;
    }

    private MQEValues initMQEValues() {
        MQEValues mqeValues = new MQEValues();
        for (String times : this.windowTimes) {
            MQEValue mqeValue = new MQEValue();
            mqeValue.setEmptyValue(true);
            mqeValue.setId(times);
            mqeValues.getValues().add(mqeValue);
        }
        return mqeValues;
    }

    private ArrayList<MQEValues> buildEmptyMQEValuesList() {
        ArrayList<MQEValues> mqeValuesList = new ArrayList<MQEValues>();
        mqeValuesList.add(this.initMQEValues());
        return mqeValuesList;
    }

    private ArrayList<MQEValues> buildEmptyLabeledMQEValuesList(List<String> labelValues) {
        ArrayList<MQEValues> mqeValuesList = new ArrayList<MQEValues>();
        if (CollectionUtils.isEmpty(labelValues)) {
            MQEValues mqeValues = this.initMQEValues();
            KeyValue label = new KeyValue("_", "_");
            Metadata metadata = new Metadata();
            metadata.getLabels().add(label);
            mqeValues.setMetric(metadata);
            mqeValuesList.add(mqeValues);
        } else {
            for (String labelValue : labelValues) {
                MQEValues mqeValues = this.initMQEValues();
                Metadata metadata = new Metadata();
                KeyValue label = new KeyValue("_", labelValue);
                metadata.getLabels().add(label);
                mqeValues.setMetric(metadata);
                mqeValuesList.add(mqeValues);
            }
        }
        return mqeValuesList;
    }
}

