/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.expr.rt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.mqe.rt.MQEVisitorBase;
import org.apache.skywalking.mqe.rt.grammar.MQEParser;
import org.apache.skywalking.mqe.rt.type.ExpressionResult;
import org.apache.skywalking.mqe.rt.type.ExpressionResultType;
import org.apache.skywalking.mqe.rt.type.MQEValue;
import org.apache.skywalking.mqe.rt.type.MQEValues;
import org.apache.skywalking.mqe.rt.type.Metadata;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmMQEVerifyVisitor
extends MQEVisitorBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmMQEVerifyVisitor.class);
    private final Set<String> includeMetrics = new HashSet<String>();
    private int maxTrendRange = 0;

    public AlarmMQEVerifyVisitor() {
        super(Step.MINUTE);
    }

    public ExpressionResult visitMetric(MQEParser.MetricContext ctx) {
        ExpressionResult result = new ExpressionResult();
        String metricName = ctx.metricName().getText();
        Optional valueColumn = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(metricName);
        if (valueColumn.isEmpty()) {
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError("Metric: [" + metricName + "] dose not exist.");
            return result;
        }
        this.includeMetrics.add(metricName);
        if (ctx.parent instanceof MQEParser.TopNOPContext) {
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError("Unsupported operation: [top_n] in alarm expression.");
            return result;
        }
        Column.ValueDataType dataType = ((ValueColumnMetadata.ValueColumn)valueColumn.get()).getDataType();
        MQEValues mockMqeValues = new MQEValues();
        MQEValue mqeValue = new MQEValue();
        mqeValue.setEmptyValue(true);
        mockMqeValues.getValues().add(mqeValue);
        if (dataType == Column.ValueDataType.COMMON_VALUE) {
            result.getResults().add(mockMqeValues);
            result.setType(ExpressionResultType.TIME_SERIES_VALUES);
            return result;
        }
        if (dataType == Column.ValueDataType.LABELED_VALUE) {
            String labelValue;
            String labelValueTrim;
            List<Object> labelValues = Collections.emptyList();
            if (ctx.label() != null && StringUtil.isNotBlank((String)(labelValueTrim = (labelValue = ctx.label().labelValue().getText()).substring(1, labelValue.length() - 1)))) {
                labelValues = Arrays.asList(labelValueTrim.split(","));
            }
            ArrayList<MQEValues> mqeValuesList = new ArrayList<MQEValues>();
            if (CollectionUtils.isEmpty(labelValues)) {
                KeyValue label = new KeyValue("_", "_");
                Metadata metadata = new Metadata();
                metadata.getLabels().add(label);
                mockMqeValues.setMetric(metadata);
                mqeValuesList.add(mockMqeValues);
            } else {
                for (String value : labelValues) {
                    Metadata metadata = new Metadata();
                    KeyValue label = new KeyValue("_", value);
                    metadata.getLabels().add(label);
                    mockMqeValues.setMetric(metadata);
                    mqeValuesList.add(mockMqeValues);
                }
            }
            result.setType(ExpressionResultType.TIME_SERIES_VALUES);
            result.setResults(mqeValuesList);
            result.setLabeledResult(true);
            return result;
        }
        result.setType(ExpressionResultType.UNKNOWN);
        result.setError("Metric dose not supported in alarm, metric: [" + metricName + "] is not a common or labeled metric.");
        return result;
    }

    public ExpressionResult visitTrendOP(MQEParser.TrendOPContext ctx) {
        int trendRange = Integer.parseInt(ctx.INTEGER().getText());
        if (trendRange < 1) {
            ExpressionResult result = new ExpressionResult();
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError("The trend range must be greater than 0.");
            return result;
        }
        this.setMaxTrendRange(trendRange);
        return super.visitTrendOP(ctx);
    }

    private void setMaxTrendRange(int trendRange) {
        if (trendRange > this.maxTrendRange) {
            this.maxTrendRange = trendRange;
        }
    }

    @Generated
    public Set<String> getIncludeMetrics() {
        return this.includeMetrics;
    }

    @Generated
    public int getMaxTrendRange() {
        return this.maxTrendRange;
    }
}

