/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmHooksType;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRule;
import org.apache.skywalking.oap.server.core.alarm.provider.Rules;
import org.apache.skywalking.oap.server.core.alarm.provider.dingtalk.DingtalkSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.discord.DiscordSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.feishu.FeishuSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.grpc.GRPCAlarmSetting;
import org.apache.skywalking.oap.server.core.alarm.provider.pagerduty.PagerDutySettings;
import org.apache.skywalking.oap.server.core.alarm.provider.slack.SlackSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.webhook.WebhookSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.wechat.WechatSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.welink.WeLinkSettings;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class RulesReader {
    private Map yamlData;
    private final Set<String> defaultHooks = new HashSet<String>();
    private final Set<String> allHooks = new HashSet<String>();

    public RulesReader(InputStream inputStream) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        this.yamlData = (Map)yaml.load(inputStream);
    }

    public RulesReader(Reader io) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        this.yamlData = (Map)yaml.load(io);
    }

    public Rules readRules() {
        Rules rules = new Rules();
        if (Objects.nonNull(this.yamlData)) {
            this.readHooksConfig(rules);
            this.readRulesConfig(rules);
        }
        return rules;
    }

    private void readRulesConfig(Rules rules) {
        Map rulesData = (Map)this.yamlData.get("rules");
        if (rulesData == null) {
            return;
        }
        rules.setRules(new ArrayList<AlarmRule>());
        rulesData.forEach((k, v) -> {
            if (((String)k).endsWith("_rule")) {
                AlarmRule alarmRule = new AlarmRule();
                alarmRule.setAlarmRuleName((String)k);
                Map settings = (Map)v;
                Object expression = settings.get("expression");
                if (StringUtil.isEmpty((String)((String)expression))) {
                    throw new IllegalArgumentException("expression can't be empty");
                }
                try {
                    alarmRule.setExpression(expression.toString());
                }
                catch (IllegalExpressionException e) {
                    throw new IllegalArgumentException(e);
                }
                alarmRule.setIncludeNames(settings.getOrDefault("include-names", new ArrayList(0)));
                alarmRule.setExcludeNames(settings.getOrDefault("exclude-names", new ArrayList(0)));
                alarmRule.setIncludeNamesRegex(settings.getOrDefault("include-names-regex", ""));
                alarmRule.setExcludeNamesRegex(settings.getOrDefault("exclude-names-regex", ""));
                alarmRule.setPeriod(settings.getOrDefault("period", 1));
                alarmRule.setSilencePeriod(settings.getOrDefault("silence-period", alarmRule.getPeriod()));
                alarmRule.setMessage((String)((Object)settings.getOrDefault("message", "Alarm caused by Rule " + alarmRule.getAlarmRuleName())));
                alarmRule.setTags(settings.getOrDefault("tags", new HashMap()));
                HashSet<String> specificHooks = new HashSet<String>(settings.getOrDefault("hooks", new ArrayList()));
                this.checkSpecificHooks(alarmRule.getAlarmRuleName(), specificHooks);
                alarmRule.setHooks(specificHooks);
                if (alarmRule.getHooks().isEmpty()) {
                    alarmRule.getHooks().addAll(this.defaultHooks);
                }
                rules.getRules().add(alarmRule);
            }
        });
    }

    private void readHooksConfig(Rules rules) {
        Map hooks = this.yamlData.getOrDefault("hooks", Collections.EMPTY_MAP);
        if (CollectionUtils.isEmpty((Map)hooks)) {
            return;
        }
        this.readWebHookConfig(hooks, rules);
        this.readGrpcConfig(hooks, rules);
        this.readSlackConfig(hooks, rules);
        this.readWechatConfig(hooks, rules);
        this.readDingtalkConfig(hooks, rules);
        this.readFeishuConfig(hooks, rules);
        this.readWeLinkConfig(hooks, rules);
        this.readPagerDutyConfig(hooks, rules);
        this.readDiscordConfig(hooks, rules);
    }

    private void readWebHookConfig(Map hooks, Rules rules) {
        Map configs = (Map)hooks.get(AlarmHooksType.webhook.name());
        if (configs == null) {
            return;
        }
        configs.forEach((k, v) -> {
            Map config = (Map)v;
            WebhookSettings settings = new WebhookSettings(k.toString(), AlarmHooksType.webhook, config.getOrDefault("is-default", false));
            List urls = (List)config.get("urls");
            if (urls != null) {
                settings.getUrls().addAll(urls);
            }
            rules.getWebhookSettingsMap().put(settings.getFormattedName(), settings);
            if (settings.isDefault()) {
                this.defaultHooks.add(settings.getFormattedName());
            }
            this.allHooks.add(settings.getFormattedName());
        });
    }

    private void readGrpcConfig(Map hooks, Rules rules) {
        Map configs = (Map)hooks.get(AlarmHooksType.gRPC.name());
        if (configs == null) {
            return;
        }
        configs.forEach((k, v) -> {
            Object targetPort;
            Map config = (Map)v;
            GRPCAlarmSetting setting = new GRPCAlarmSetting(k.toString(), AlarmHooksType.gRPC, config.getOrDefault("is-default", false));
            Object targetHost = config.get("target-host");
            if (targetHost != null) {
                setting.setTargetHost((String)targetHost);
            }
            if ((targetPort = config.get("target-port")) != null) {
                setting.setTargetPort((Integer)targetPort);
            }
            rules.getGrpcAlarmSettingMap().put(setting.getFormattedName(), setting);
            if (setting.isDefault()) {
                this.defaultHooks.add(setting.getFormattedName());
            }
            this.allHooks.add(setting.getFormattedName());
        });
    }

    private void readSlackConfig(Map hooks, Rules rules) {
        Map configs = (Map)hooks.get(AlarmHooksType.slack.name());
        if (configs == null) {
            return;
        }
        configs.forEach((k, v) -> {
            Map config = (Map)v;
            SlackSettings settings = new SlackSettings(k.toString(), AlarmHooksType.slack, config.getOrDefault("is-default", false));
            String textTemplate = config.getOrDefault("text-template", "");
            settings.setTextTemplate(textTemplate);
            List webhooks = (List)config.get("webhooks");
            if (webhooks != null) {
                settings.getWebhooks().addAll(webhooks);
            }
            rules.getSlackSettingsMap().put(settings.getFormattedName(), settings);
            if (settings.isDefault()) {
                this.defaultHooks.add(settings.getFormattedName());
            }
            this.allHooks.add(settings.getFormattedName());
        });
    }

    private void readWechatConfig(Map hooks, Rules rules) {
        Map configs = (Map)hooks.get(AlarmHooksType.wechat.name());
        if (configs == null) {
            return;
        }
        configs.forEach((k, v) -> {
            Map config = (Map)v;
            WechatSettings settings = new WechatSettings(k.toString(), AlarmHooksType.wechat, config.getOrDefault("is-default", false));
            String textTemplate = config.getOrDefault("text-template", "");
            settings.setTextTemplate(textTemplate);
            List webhooks = (List)config.get("webhooks");
            if (webhooks != null) {
                settings.getWebhooks().addAll(webhooks);
            }
            rules.getWechatSettingsMap().put(settings.getFormattedName(), settings);
            if (settings.isDefault()) {
                this.defaultHooks.add(settings.getFormattedName());
            }
            this.allHooks.add(settings.getFormattedName());
        });
    }

    private void readDingtalkConfig(Map hooks, Rules rules) {
        Map configs = (Map)hooks.get(AlarmHooksType.dingtalk.name());
        if (configs == null) {
            return;
        }
        configs.forEach((k, v) -> {
            Map config = (Map)v;
            DingtalkSettings settings = new DingtalkSettings(k.toString(), AlarmHooksType.dingtalk, config.getOrDefault("is-default", false));
            String textTemplate = config.getOrDefault("text-template", "");
            settings.setTextTemplate(textTemplate);
            List webhooks = (List)config.get("webhooks");
            if (webhooks != null) {
                webhooks.forEach(webhook -> {
                    String secret = webhook.getOrDefault("secret", "");
                    String url = webhook.getOrDefault("url", "");
                    settings.getWebhooks().add(new DingtalkSettings.WebHookUrl(secret, url));
                });
            }
            rules.getDingtalkSettingsMap().put(settings.getFormattedName(), settings);
            if (settings.isDefault()) {
                this.defaultHooks.add(settings.getFormattedName());
            }
            this.allHooks.add(settings.getFormattedName());
        });
    }

    private void readFeishuConfig(Map hooks, Rules rules) {
        Map configs = (Map)hooks.get(AlarmHooksType.feishu.name());
        if (configs == null) {
            return;
        }
        configs.forEach((k, v) -> {
            Map config = (Map)v;
            FeishuSettings settings = new FeishuSettings(k.toString(), AlarmHooksType.feishu, config.getOrDefault("is-default", false));
            String textTemplate = config.getOrDefault("text-template", "");
            settings.setTextTemplate(textTemplate);
            List webhooks = (List)config.get("webhooks");
            if (webhooks != null) {
                webhooks.forEach(webhook -> {
                    String secret = webhook.getOrDefault("secret", "");
                    String url = webhook.getOrDefault("url", "");
                    settings.getWebhooks().add(new FeishuSettings.WebHookUrl(secret, url));
                });
            }
            rules.getFeishuSettingsMap().put(settings.getFormattedName(), settings);
            if (settings.isDefault()) {
                this.defaultHooks.add(settings.getFormattedName());
            }
            this.allHooks.add(settings.getFormattedName());
        });
    }

    private void readWeLinkConfig(Map hooks, Rules rules) {
        Map configs = (Map)hooks.get(AlarmHooksType.welink.name());
        if (configs == null) {
            return;
        }
        configs.forEach((k, v) -> {
            Map config = (Map)v;
            String textTemplate = (String)config.get("text-template");
            List webhooks = (List)config.get("webhooks");
            if (StringUtil.isBlank((String)textTemplate) || CollectionUtils.isEmpty((List)webhooks)) {
                return;
            }
            List<WeLinkSettings.WebHookUrl> webHookUrls = webhooks.stream().map(WeLinkSettings.WebHookUrl::generateFromMap).collect(Collectors.toList());
            WeLinkSettings settings = new WeLinkSettings(k.toString(), AlarmHooksType.welink, config.getOrDefault("is-default", false));
            settings.setTextTemplate(textTemplate);
            settings.setWebhooks(webHookUrls);
            rules.getWeLinkSettingsMap().put(settings.getFormattedName(), settings);
            if (settings.isDefault()) {
                this.defaultHooks.add(settings.getFormattedName());
            }
            this.allHooks.add(settings.getFormattedName());
        });
    }

    private void readPagerDutyConfig(Map hooks, Rules rules) {
        Map configs = (Map)hooks.get(AlarmHooksType.pagerduty.name());
        if (configs == null) {
            return;
        }
        configs.forEach((k, v) -> {
            Map config = (Map)v;
            PagerDutySettings settings = new PagerDutySettings(k.toString(), AlarmHooksType.pagerduty, config.getOrDefault("is-default", false));
            String textTemplate = config.getOrDefault("text-template", "");
            settings.setTextTemplate(textTemplate);
            List integrationKeys = (List)config.get("integration-keys");
            if (integrationKeys != null) {
                settings.getIntegrationKeys().addAll(integrationKeys);
            }
            rules.getPagerDutySettingsMap().put(settings.getFormattedName(), settings);
            if (settings.isDefault()) {
                this.defaultHooks.add(settings.getFormattedName());
            }
            this.allHooks.add(settings.getFormattedName());
        });
    }

    private void readDiscordConfig(Map hooks, Rules rules) {
        Map configs = (Map)hooks.get(AlarmHooksType.discord.name());
        if (configs == null) {
            return;
        }
        configs.forEach((k, v) -> {
            Map config = (Map)v;
            String textTemplate = (String)config.get("text-template");
            List webhooks = (List)config.get("webhooks");
            if (StringUtil.isBlank((String)textTemplate) || CollectionUtils.isEmpty((List)webhooks)) {
                return;
            }
            List<DiscordSettings.WebHookUrl> webHookUrls = webhooks.stream().map(DiscordSettings.WebHookUrl::generateFromMap).collect(Collectors.toList());
            DiscordSettings settings = new DiscordSettings(k.toString(), AlarmHooksType.discord, config.getOrDefault("is-default", false));
            settings.setTextTemplate(textTemplate);
            settings.setWebhooks(webHookUrls);
            rules.getDiscordSettingsMap().put(settings.getFormattedName(), settings);
            if (settings.isDefault()) {
                this.defaultHooks.add(settings.getFormattedName());
            }
            this.allHooks.add(settings.getFormattedName());
        });
    }

    private void checkSpecificHooks(String ruleName, Set<String> hooks) {
        if (!this.allHooks.containsAll(hooks)) {
            throw new IllegalArgumentException("rule: [" + ruleName + "] contains invalid hooks. Please check the hook is exist and name format is {hookType}.{hookName}");
        }
    }
}

