/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.health.checker.provider;

import com.google.common.util.concurrent.AtomicDouble;
import io.vavr.collection.Stream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.health.checker.module.HealthCheckerModule;
import org.apache.skywalking.oap.server.health.checker.provider.HealthCheckerConfig;
import org.apache.skywalking.oap.server.health.checker.provider.HealthQueryService;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleServiceHolder;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCollector;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckerProvider
extends ModuleProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthCheckerProvider.class);
    private final AtomicDouble score = new AtomicDouble();
    private final AtomicReference<String> details = new AtomicReference();
    private HealthCheckerConfig config;
    private MetricsCollector collector;
    private MetricsCreator metricsCreator;
    private ScheduledExecutorService ses;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return HealthCheckerModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<HealthCheckerConfig>(){

            public Class type() {
                return HealthCheckerConfig.class;
            }

            public void onInitialized(HealthCheckerConfig initialized) {
                HealthCheckerProvider.this.config = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        this.score.set(-1.0);
        this.ses = Executors.newSingleThreadScheduledExecutor();
        this.registerServiceImplementation(HealthQueryService.class, new HealthQueryService(this.score, this.details));
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        ModuleServiceHolder telemetry = this.getManager().find("telemetry").provider();
        this.metricsCreator = (MetricsCreator)telemetry.getService(MetricsCreator.class);
        this.collector = (MetricsCollector)telemetry.getService(MetricsCollector.class);
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
        this.ses.scheduleAtFixedRate(() -> {
            StringBuilder unhealthyModules = new StringBuilder();
            this.score.set(((Double)Stream.ofAll((Iterable)this.collector.collect()).flatMap(metricFamily -> metricFamily.samples).filter(sample -> this.metricsCreator.isHealthCheckerMetrics(sample.name)).peek(sample -> {
                if (sample.value > 0.0) {
                    unhealthyModules.append(this.metricsCreator.extractModuleName(sample.name)).append(",");
                }
            }).map(sample -> sample.value).collect(Collectors.summingDouble(Double::doubleValue))).doubleValue());
            this.details.set(unhealthyModules.toString());
        }, 2L, this.config.getCheckIntervalSeconds(), TimeUnit.SECONDS);
    }

    public String[] requiredModules() {
        return new String[]{"telemetry"};
    }
}

