/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.client.jdbc.hikaricp;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.healthcheck.DelegatedHealthChecker;
import org.apache.skywalking.oap.server.library.client.healthcheck.HealthCheckable;
import org.apache.skywalking.oap.server.library.util.HealthChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCClient
implements Client,
HealthCheckable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDBCClient.class);
    private final HikariConfig hikariConfig;
    private final DelegatedHealthChecker healthChecker;
    private HikariDataSource dataSource;

    public JDBCClient(Properties properties) {
        this.hikariConfig = new HikariConfig(properties);
        this.healthChecker = new DelegatedHealthChecker();
    }

    @Override
    public void connect() {
        this.dataSource = new HikariDataSource(this.hikariConfig);
    }

    @Override
    public void shutdown() {
        this.dataSource.close();
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(true);
    }

    public Connection getConnection(boolean autoCommit) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(autoCommit);
        return connection;
    }

    public void execute(String sql) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("Executing SQL: {}", (Object)sql);
        }
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(sql);
            statement.closeOnCompletion();
            this.healthChecker.health();
        }
        catch (SQLException e) {
            this.healthChecker.unHealth(e);
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String sql, Object ... params) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("Executing SQL: {}", (Object)sql);
            log.debug("SQL parameters: {}", params);
        }
        try (Connection connection = this.getConnection();){
            int n;
            block15: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    this.setStatementParam(statement, params);
                    int result = statement.executeUpdate();
                    statement.closeOnCompletion();
                    this.healthChecker.health();
                    n = result;
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
        catch (SQLException e) {
            this.healthChecker.unHealth(e);
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    public <T> T executeQuery(String sql, ResultHandler<T> resultHandler, Object ... params) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setStatementParam(PreparedStatement statement, Object[] params) throws SQLException {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                if (param instanceof String) {
                    statement.setString(i + 1, (String)param);
                    continue;
                }
                if (param instanceof Integer) {
                    statement.setInt(i + 1, (Integer)param);
                    continue;
                }
                if (param instanceof Double) {
                    statement.setDouble(i + 1, (Double)param);
                    continue;
                }
                if (param instanceof Long) {
                    statement.setLong(i + 1, (Long)param);
                    continue;
                }
                throw new SQLException("Unsupported data type, type=" + param.getClass().getName());
            }
        }
    }

    @Override
    public void registerChecker(HealthChecker healthChecker) {
        this.healthChecker.register(healthChecker);
    }

    public boolean indexExists(String table, String index) throws SQLException {
        try (Connection connection = this.getConnection();
             ResultSet resultSet = connection.getMetaData().getIndexInfo(connection.getCatalog(), null, table, false, false);){
            while (resultSet.next()) {
                if (!resultSet.getString("INDEX_NAME").equalsIgnoreCase(index)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean tableExists(String table) throws SQLException {
        try (Connection conn = this.getConnection();){
            boolean bl;
            block12: {
                ResultSet result = conn.getMetaData().getTables(conn.getCatalog(), null, table, null);
                try {
                    bl = result.next();
                    if (result == null) break block12;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return bl;
        }
    }

    public Set<String> getTableColumns(String table) throws SQLException {
        try (Connection conn = this.getConnection();){
            HashSet<String> hashSet;
            block13: {
                ResultSet result = conn.getMetaData().getColumns(conn.getCatalog(), null, table, null);
                try {
                    HashSet<String> columns = new HashSet<String>();
                    while (result.next()) {
                        columns.add(result.getString("COLUMN_NAME").toLowerCase());
                    }
                    hashSet = columns;
                    if (result == null) break block13;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return hashSet;
        }
    }

    @FunctionalInterface
    public static interface ResultHandler<T> {
        public T handle(ResultSet var1) throws SQLException;
    }
}

