/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.status;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.status.BootingStatus;
import org.apache.skywalking.oap.server.core.status.ClusterStatus;
import org.apache.skywalking.oap.server.core.status.ServerStatusWatcher;
import org.apache.skywalking.oap.server.library.module.ApplicationConfiguration;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;

public class ServerStatusService
implements Service {
    private final ModuleManager manager;
    private final CoreModuleConfig moduleConfig;
    private BootingStatus bootingStatus = new BootingStatus();
    private ClusterStatus clusterStatus = new ClusterStatus();
    private List<ServerStatusWatcher> statusWatchers = new ArrayList<ServerStatusWatcher>();
    private List<ApplicationConfiguration.ModuleConfiguration> configurations;

    public void bootedNow(List<ApplicationConfiguration.ModuleConfiguration> configurations, long uptime) {
        this.bootingStatus.setBooted(true);
        this.bootingStatus.setUptime(uptime);
        ((MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class)).createGauge("uptime", "oap server start up time", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE).setValue((double)uptime / 1000.0);
        this.statusWatchers.forEach(watcher -> watcher.onServerBooted(this.bootingStatus));
        this.configurations = configurations;
    }

    public void rebalancedCluster(long rebalancedTime) {
        this.clusterStatus.setRebalancedTime(rebalancedTime);
        ((MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class)).createGauge("cluster_rebalanced_time", "oap cluster rebalanced time after scale", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE).setValue((double)rebalancedTime / 1000.0);
        this.statusWatchers.forEach(watcher -> watcher.onClusterRebalanced(this.clusterStatus));
    }

    public void registerWatcher(ServerStatusWatcher watcher) {
        this.statusWatchers.add(watcher);
    }

    public String dumpBootingConfigurations(String keywords4MaskingSecretsOfConfig) {
        if (this.configurations == null || this.configurations.isEmpty()) {
            return "No available booting configurations.";
        }
        String[] keywords = keywords4MaskingSecretsOfConfig.split(",");
        StringBuilder configList = new StringBuilder();
        for (ApplicationConfiguration.ModuleConfiguration configuration : this.configurations) {
            String moduleName = configuration.getModuleName();
            if (configuration.getProviders().size() == 1) {
                configList.append(moduleName).append(".provider=").append((String)configuration.getProviders().keySet().iterator().next()).append("\n");
            }
            configuration.getProviders().forEach((providerName, providerConfiguration) -> providerConfiguration.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                for (String keyword : keywords) {
                    if (!key.toString().toLowerCase().contains(keyword.toLowerCase())) continue;
                    value = "******";
                }
                configList.append(moduleName).append(".").append((String)providerName).append(".").append(key).append("=").append(value).append("\n");
            })));
        }
        return configList.toString();
    }

    @Generated
    public ServerStatusService(ModuleManager manager, CoreModuleConfig moduleConfig) {
        this.manager = manager;
        this.moduleConfig = moduleConfig;
    }

    @Generated
    public BootingStatus getBootingStatus() {
        return this.bootingStatus;
    }

    @Generated
    public ClusterStatus getClusterStatus() {
        return this.clusterStatus;
    }
}

