/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.List;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.RecordCondition;
import org.apache.skywalking.oap.server.core.query.type.Record;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.query.IRecordsQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;

public class RecordQueryService
implements Service {
    private final ModuleManager moduleManager;
    private IRecordsQueryDAO recordsQueryDAO;

    public RecordQueryService(ModuleManager manager) {
        this.moduleManager = manager;
    }

    private IRecordsQueryDAO getRecordsQueryDAO() {
        if (this.recordsQueryDAO == null) {
            this.recordsQueryDAO = (IRecordsQueryDAO)this.moduleManager.find("storage").provider().getService(IRecordsQueryDAO.class);
        }
        return this.recordsQueryDAO;
    }

    public List<Record> readRecords(RecordCondition condition, Duration duration) throws IOException {
        return this.getRecordsQueryDAO().readRecords(condition, ValueColumnMetadata.INSTANCE.getValueCName(condition.getName()), duration);
    }
}

