/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class AggregationQueryService
implements Service {
    private final ModuleManager moduleManager;
    private IAggregationQueryDAO aggregationQueryDAO;

    public AggregationQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private IAggregationQueryDAO getAggregationQueryDAO() {
        if (this.aggregationQueryDAO == null) {
            this.aggregationQueryDAO = (IAggregationQueryDAO)this.moduleManager.find("storage").provider().getService(IAggregationQueryDAO.class);
        }
        return this.aggregationQueryDAO;
    }

    public List<SelectedRecord> sortMetrics(TopNCondition condition, Duration duration) throws IOException {
        String valueCName = ValueColumnMetadata.INSTANCE.getValueCName(condition.getName());
        ArrayList<KeyValue> additionalConditions = null;
        if (StringUtil.isNotEmpty((String)condition.getParentService())) {
            additionalConditions = new ArrayList<KeyValue>(1);
            String serviceId = IDManager.ServiceID.buildId(condition.getParentService(), condition.isNormal());
            additionalConditions.add(new KeyValue("service_id", serviceId));
        }
        List<SelectedRecord> selectedRecords = this.getAggregationQueryDAO().sortMetrics(condition, valueCName, duration, additionalConditions);
        selectedRecords.forEach(selectedRecord -> {
            switch (condition.getScope()) {
                case Service: {
                    selectedRecord.setName(IDManager.ServiceID.analysisId(selectedRecord.getId()).getName());
                    break;
                }
                case ServiceInstance: {
                    IDManager.ServiceInstanceID.InstanceIDDefinition instanceIDDefinition = IDManager.ServiceInstanceID.analysisId(selectedRecord.getId());
                    if (StringUtil.isEmpty((String)condition.getParentService())) {
                        IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId(instanceIDDefinition.getServiceId());
                        selectedRecord.setName(serviceIDDefinition.getName() + " - " + instanceIDDefinition.getName());
                        break;
                    }
                    selectedRecord.setName(instanceIDDefinition.getName());
                    break;
                }
                case Endpoint: {
                    IDManager.EndpointID.EndpointIDDefinition endpointIDDefinition = IDManager.EndpointID.analysisId(selectedRecord.getId());
                    if (StringUtil.isEmpty((String)condition.getParentService())) {
                        IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId(endpointIDDefinition.getServiceId());
                        selectedRecord.setName(serviceIDDefinition.getName() + " - " + endpointIDDefinition.getEndpointName());
                        break;
                    }
                    selectedRecord.setName(endpointIDDefinition.getEndpointName());
                    break;
                }
                default: {
                    selectedRecord.setName("Unknown");
                }
            }
        });
        return selectedRecords;
    }
}

