/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.trace;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.SQLDatabase;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@ScopeDeclaration(id=28, name="ProfileThreadSnapshot")
@Stream(name="profile_task_segment_snapshot", scopeId=28, builder=Builder.class, processor=RecordStreamProcessor.class)
@BanyanDB.TimestampColumn(value="dump_time")
public class ProfileThreadSnapshotRecord
extends Record {
    public static final String INDEX_NAME = "profile_task_segment_snapshot";
    public static final String TASK_ID = "task_id";
    public static final String SEGMENT_ID = "segment_id";
    public static final String DUMP_TIME = "dump_time";
    public static final String SEQUENCE = "sequence";
    public static final String STACK_BINARY = "stack_binary";
    @Column(name="task_id")
    @SQLDatabase.CompositeIndex(withColumns={"segment_id"})
    private String taskId;
    @Column(name="segment_id")
    @SQLDatabase.CompositeIndices(value={@SQLDatabase.CompositeIndex(withColumns={"sequence"}), @SQLDatabase.CompositeIndex(withColumns={"dump_time"})})
    @BanyanDB.SeriesID(index=0)
    private String segmentId;
    @Column(name="dump_time")
    private long dumpTime;
    @Column(name="sequence")
    private int sequence;
    @Column(name="stack_binary")
    private byte[] stackBinary;

    @Override
    public StorageID id() {
        return new StorageID().append(TASK_ID, this.getTaskId()).append(SEGMENT_ID, this.getSegmentId()).append(SEQUENCE, this.getSequence());
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getSegmentId() {
        return this.segmentId;
    }

    @Generated
    public long getDumpTime() {
        return this.dumpTime;
    }

    @Generated
    public int getSequence() {
        return this.sequence;
    }

    @Generated
    public byte[] getStackBinary() {
        return this.stackBinary;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    @Generated
    public void setDumpTime(long dumpTime) {
        this.dumpTime = dumpTime;
    }

    @Generated
    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    @Generated
    public void setStackBinary(byte[] stackBinary) {
        this.stackBinary = stackBinary;
    }

    public static class Builder
    implements StorageBuilder<ProfileThreadSnapshotRecord> {
        @Override
        public ProfileThreadSnapshotRecord storage2Entity(Convert2Entity converter) {
            ProfileThreadSnapshotRecord snapshot = new ProfileThreadSnapshotRecord();
            snapshot.setTaskId((String)converter.get(ProfileThreadSnapshotRecord.TASK_ID));
            snapshot.setSegmentId((String)converter.get(ProfileThreadSnapshotRecord.SEGMENT_ID));
            snapshot.setDumpTime(((Number)converter.get(ProfileThreadSnapshotRecord.DUMP_TIME)).longValue());
            snapshot.setSequence(((Number)converter.get(ProfileThreadSnapshotRecord.SEQUENCE)).intValue());
            snapshot.setTimeBucket(((Number)converter.get("time_bucket")).intValue());
            snapshot.setStackBinary(converter.getBytes(ProfileThreadSnapshotRecord.STACK_BINARY));
            return snapshot;
        }

        @Override
        public void entity2Storage(ProfileThreadSnapshotRecord storageData, Convert2Storage converter) {
            converter.accept(ProfileThreadSnapshotRecord.TASK_ID, storageData.getTaskId());
            converter.accept(ProfileThreadSnapshotRecord.SEGMENT_ID, storageData.getSegmentId());
            converter.accept(ProfileThreadSnapshotRecord.DUMP_TIME, storageData.getDumpTime());
            converter.accept(ProfileThreadSnapshotRecord.SEQUENCE, storageData.getSequence());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept(ProfileThreadSnapshotRecord.STACK_BINARY, storageData.getStackBinary());
        }
    }
}

