/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.ebpf.storage;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="ebpf_profiling_schedule", scopeId=47, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=true)
public class EBPFProfilingScheduleRecord
extends Metrics {
    public static final String INDEX_NAME = "ebpf_profiling_schedule";
    public static final String TASK_ID = "task_id";
    public static final String PROCESS_ID = "process_id";
    public static final String START_TIME = "start_time";
    public static final String END_TIME = "end_time";
    public static final String EBPF_PROFILING_SCHEDULE_ID = "ebpf_profiling_schedule_id";
    @Column(name="task_id")
    private String taskId;
    @Column(name="process_id", length=600)
    private String processId;
    @Column(name="start_time")
    private long startTime;
    @Column(name="end_time")
    private long endTime;
    @Column(name="ebpf_profiling_schedule_id")
    @BanyanDB.SeriesID(index=0)
    private String scheduleId;

    @Override
    public boolean combine(Metrics metrics) {
        EBPFProfilingScheduleRecord executeTraffic = (EBPFProfilingScheduleRecord)metrics;
        if (executeTraffic.getEndTime() > this.endTime) {
            this.endTime = executeTraffic.endTime;
        }
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    @Override
    protected StorageID id0() {
        return new StorageID().append(EBPF_PROFILING_SCHEDULE_ID, this.scheduleId);
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setTaskId(remoteData.getDataStrings(0));
        this.setProcessId(remoteData.getDataStrings(1));
        this.setScheduleId(remoteData.getDataStrings(2));
        this.setStartTime(remoteData.getDataLongs(0));
        this.setEndTime(remoteData.getDataLongs(1));
        this.setTimeBucket(remoteData.getDataLongs(2));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder builder = RemoteData.newBuilder();
        builder.addDataStrings(this.taskId);
        builder.addDataStrings(this.processId);
        builder.addDataStrings(this.scheduleId);
        builder.addDataLongs(this.startTime);
        builder.addDataLongs(this.endTime);
        builder.addDataLongs(this.getTimeBucket());
        return builder;
    }

    @Override
    public int remoteHashCode() {
        return this.hashCode();
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getProcessId() {
        return this.processId;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public String getScheduleId() {
        return this.scheduleId;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EBPFProfilingScheduleRecord)) {
            return false;
        }
        EBPFProfilingScheduleRecord other = (EBPFProfilingScheduleRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$processId = this.getProcessId();
        String other$processId = other.getProcessId();
        return !(this$processId == null ? other$processId != null : !this$processId.equals(other$processId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EBPFProfilingScheduleRecord;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $processId = this.getProcessId();
        result = result * 59 + ($processId == null ? 43 : $processId.hashCode());
        return result;
    }

    public static class Builder
    implements StorageBuilder<EBPFProfilingScheduleRecord> {
        @Override
        public EBPFProfilingScheduleRecord storage2Entity(Convert2Entity converter) {
            EBPFProfilingScheduleRecord executeTraffic = new EBPFProfilingScheduleRecord();
            executeTraffic.setTaskId((String)converter.get(EBPFProfilingScheduleRecord.TASK_ID));
            executeTraffic.setProcessId((String)converter.get(EBPFProfilingScheduleRecord.PROCESS_ID));
            executeTraffic.setScheduleId((String)converter.get(EBPFProfilingScheduleRecord.EBPF_PROFILING_SCHEDULE_ID));
            executeTraffic.setStartTime(((Number)converter.get(EBPFProfilingScheduleRecord.START_TIME)).longValue());
            executeTraffic.setEndTime(((Number)converter.get(EBPFProfilingScheduleRecord.END_TIME)).longValue());
            executeTraffic.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return executeTraffic;
        }

        @Override
        public void entity2Storage(EBPFProfilingScheduleRecord storageData, Convert2Storage converter) {
            converter.accept(EBPFProfilingScheduleRecord.TASK_ID, storageData.getTaskId());
            converter.accept(EBPFProfilingScheduleRecord.PROCESS_ID, storageData.getProcessId());
            converter.accept(EBPFProfilingScheduleRecord.EBPF_PROFILING_SCHEDULE_ID, storageData.getScheduleId());
            converter.accept(EBPFProfilingScheduleRecord.START_TIME, storageData.getStartTime());
            converter.accept(EBPFProfilingScheduleRecord.END_TIME, storageData.getEndTime());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

