/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Expression;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

@MetricsFunction(functionName="percent")
public abstract class PercentMetrics
extends Metrics
implements IntValueHolder {
    protected static final String TOTAL = "total";
    protected static final String MATCH = "match";
    protected static final String PERCENTAGE = "percentage";
    @Column(name="total", storageOnly=true)
    @BanyanDB.MeasureField
    private long total;
    @Column(name="percentage", dataType=Column.ValueDataType.COMMON_VALUE, function=Function.Avg)
    @BanyanDB.MeasureField
    private int percentage;
    @Column(name="match", storageOnly=true)
    private long match;

    @Entrance
    public final void combine(@Expression boolean isMatch) {
        if (isMatch) {
            ++this.match;
        }
        ++this.total;
    }

    @Override
    public final boolean combine(Metrics metrics) {
        this.total += ((PercentMetrics)metrics).total;
        this.match += ((PercentMetrics)metrics).match;
        return true;
    }

    @Override
    public void calculate() {
        this.percentage = (int)(this.match * 10000L / this.total);
    }

    @Override
    public int getValue() {
        return this.percentage;
    }

    @Generated
    public long getTotal() {
        return this.total;
    }

    @Generated
    public void setTotal(long total) {
        this.total = total;
    }

    @Generated
    public int getPercentage() {
        return this.percentage;
    }

    @Generated
    public void setPercentage(int percentage) {
        this.percentage = percentage;
    }

    @Generated
    public long getMatch() {
        return this.match;
    }

    @Generated
    public void setMatch(long match) {
        this.match = match;
    }
}

