/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.remote.data.StreamData;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

public abstract class Metrics
extends StreamData
implements StorageData {
    public static final String ENTITY_ID = "entity_id";
    public static final String ID = "id";
    @Column(name="time_bucket")
    private long timeBucket;
    private long lastUpdateTimestamp = 0L;
    private volatile StorageID id;

    public abstract boolean combine(Metrics var1);

    public abstract void calculate();

    public abstract Metrics toHour();

    public abstract Metrics toDay();

    public void setLastUpdateTimestamp(long timestamp) {
        this.lastUpdateTimestamp = timestamp;
    }

    public boolean isExpired(long timestamp, long expiredThreshold) {
        return timestamp - this.lastUpdateTimestamp > expiredThreshold;
    }

    public long toTimeBucketInHour() {
        if (this.isMinuteBucket()) {
            return this.timeBucket / 100L;
        }
        throw new IllegalStateException("Current time bucket is not in minute dimensionality");
    }

    public long toTimeBucketInDay() {
        if (this.isMinuteBucket()) {
            return this.timeBucket / 10000L;
        }
        if (this.isHourBucket()) {
            return this.timeBucket / 100L;
        }
        throw new IllegalStateException("Current time bucket is not in minute dimensionality");
    }

    protected long getDurationInMinute() {
        if (this.isMinuteBucket()) {
            return 1L;
        }
        if (this.isHourBucket()) {
            return 60L;
        }
        if (this.isDayBucket()) {
            return 1440L;
        }
        throw new IllegalStateException("Time bucket (" + this.timeBucket + ") can't be recognized.");
    }

    private boolean isMinuteBucket() {
        return TimeBucket.isMinuteBucket(this.timeBucket);
    }

    private boolean isHourBucket() {
        return TimeBucket.isHourBucket(this.timeBucket);
    }

    private boolean isDayBucket() {
        return TimeBucket.isDayBucket(this.timeBucket);
    }

    @Override
    public StorageID id() {
        if (this.id == null) {
            this.id = this.id0();
        }
        return this.id;
    }

    protected abstract StorageID id0();

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metrics)) {
            return false;
        }
        Metrics other = (Metrics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getTimeBucket() == other.getTimeBucket();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Metrics;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeBucket = this.getTimeBucket();
        result = result * 59 + (int)($timeBucket >>> 32 ^ $timeBucket);
        return result;
    }

    @Generated
    public long getTimeBucket() {
        return this.timeBucket;
    }

    @Generated
    public void setTimeBucket(long timeBucket) {
        this.timeBucket = timeBucket;
    }

    @Generated
    public long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }
}

