/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function.sumpermin;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.Meter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.LabeledValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@MeterFunction(functionName="sumPerMinLabeled")
public abstract class SumPerMinLabeledFunction
extends Meter
implements AcceptableValue<DataTable>,
LabeledValueHolder {
    protected static final String VALUE = "datatable_value";
    protected static final String TOTAL = "datatable_total";
    @Column(name="entity_id", length=512)
    @BanyanDB.SeriesID(index=0)
    private String entityId;
    @Column(name="service_id")
    private String serviceId;
    @Column(name="datatable_value", dataType=Column.ValueDataType.LABELED_VALUE, storageOnly=true)
    @BanyanDB.MeasureField
    private DataTable value = new DataTable(30);
    @Column(name="datatable_total", storageOnly=true)
    @BanyanDB.MeasureField
    private DataTable total = new DataTable(30);

    @Entrance
    public final void combine(@SourceFrom DataTable value) {
        this.total.append(value);
    }

    @Override
    public void accept(MeterEntity entity, DataTable value) {
        this.setEntityId(entity.id());
        this.setServiceId(entity.serviceId());
        this.total.append(value);
    }

    @Override
    public Class<? extends StorageBuilder> builder() {
        return SumPerMinLabeledStorageBuilder.class;
    }

    @Override
    public boolean combine(Metrics metrics) {
        SumPerMinLabeledFunction sumPerMinLabeledFunction = (SumPerMinLabeledFunction)metrics;
        this.combine(sumPerMinLabeledFunction.getTotal());
        return true;
    }

    @Override
    public void calculate() {
        for (String key : this.total.keys()) {
            Long val = this.total.get(key);
            if (Objects.isNull(val)) continue;
            this.value.put(key, val / this.getDurationInMinute());
        }
    }

    @Override
    public Metrics toHour() {
        SumPerMinLabeledFunction metrics = (SumPerMinLabeledFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setServiceId(this.getServiceId());
        metrics.getTotal().copyFrom(this.getTotal());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        SumPerMinLabeledFunction metrics = (SumPerMinLabeledFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setServiceId(this.getServiceId());
        metrics.getTotal().copyFrom(this.getTotal());
        return metrics;
    }

    @Override
    protected StorageID id0() {
        return new StorageID().append("time_bucket", this.getTimeBucket()).append("entity_id", this.getEntityId());
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setTotal(new DataTable(remoteData.getDataObjectStrings(0)));
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setEntityId(remoteData.getDataStrings(0));
        this.setServiceId(remoteData.getDataStrings(1));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataObjectStrings(this.total.toStorageData());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.getEntityId());
        remoteBuilder.addDataStrings(this.getServiceId());
        return remoteBuilder;
    }

    @Override
    public int remoteHashCode() {
        return this.getEntityId().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SumPerMinLabeledFunction)) {
            return false;
        }
        SumPerMinLabeledFunction function = (SumPerMinLabeledFunction)o;
        return Objects.equals(this.entityId, function.entityId) && this.getTimeBucket() == function.getTimeBucket();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityId, this.getTimeBucket());
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    @Generated
    public DataTable getValue() {
        return this.value;
    }

    @Generated
    public void setValue(DataTable value) {
        this.value = value;
    }

    @Generated
    public DataTable getTotal() {
        return this.total;
    }

    @Generated
    public void setTotal(DataTable total) {
        this.total = total;
    }

    public static class SumPerMinLabeledStorageBuilder
    implements StorageBuilder<SumPerMinLabeledFunction> {
        @Override
        public SumPerMinLabeledFunction storage2Entity(Convert2Entity converter) {
            SumPerMinLabeledFunction metrics = new SumPerMinLabeledFunction(){

                @Override
                public AcceptableValue<DataTable> createNew() {
                    throw new UnexpectedException("createNew should not be called");
                }
            };
            metrics.setValue(new DataTable((String)converter.get(SumPerMinLabeledFunction.VALUE)));
            metrics.setTotal(new DataTable((String)converter.get(SumPerMinLabeledFunction.TOTAL)));
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setServiceId((String)converter.get("service_id"));
            metrics.setEntityId((String)converter.get("entity_id"));
            return metrics;
        }

        @Override
        public void entity2Storage(SumPerMinLabeledFunction storageData, Convert2Storage converter) {
            converter.accept(SumPerMinLabeledFunction.VALUE, storageData.getValue());
            converter.accept(SumPerMinLabeledFunction.TOTAL, storageData.getTotal());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("service_id", storageData.getServiceId());
            converter.accept("entity_id", storageData.getEntityId());
        }
    }
}

