/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.DispatcherDetectorListener;
import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherManager
implements DispatcherDetectorListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DispatcherManager.class);
    private Map<Integer, List<SourceDispatcher<ISource>>> dispatcherMap = new HashMap<Integer, List<SourceDispatcher<ISource>>>();

    public void forward(ISource source) {
        if (source == null) {
            return;
        }
        List<SourceDispatcher<ISource>> dispatchers = this.dispatcherMap.get(source.scope());
        if (dispatchers != null) {
            source.prepare();
            for (SourceDispatcher<ISource> dispatcher : dispatchers) {
                dispatcher.dispatch(source);
            }
        }
    }

    public void scan() throws IOException, IllegalAccessException, InstantiationException {
        ClassPath classpath = ClassPath.from((ClassLoader)this.getClass().getClassLoader());
        ImmutableSet classes = classpath.getTopLevelClassesRecursive("org.apache.skywalking");
        for (ClassPath.ClassInfo classInfo : classes) {
            Class aClass = classInfo.load();
            this.addIfAsSourceDispatcher(aClass);
        }
    }

    @Override
    public void addIfAsSourceDispatcher(Class aClass) throws IllegalAccessException, InstantiationException {
        if (!aClass.isInterface() && !Modifier.isAbstract(aClass.getModifiers()) && SourceDispatcher.class.isAssignableFrom(aClass)) {
            Type[] genericInterfaces;
            for (Type genericInterface : genericInterfaces = aClass.getGenericInterfaces()) {
                ParameterizedType anInterface = (ParameterizedType)genericInterface;
                if (!anInterface.getRawType().getTypeName().equals(SourceDispatcher.class.getName())) continue;
                Type[] arguments = anInterface.getActualTypeArguments();
                if (arguments.length != 1) {
                    throw new UnexpectedException("unexpected type argument number, class " + aClass.getName());
                }
                Type argument = arguments[0];
                Object source = ((Class)argument).newInstance();
                if (!ISource.class.isAssignableFrom(source.getClass())) {
                    throw new UnexpectedException("unexpected type argument of class " + aClass.getName() + ", should be `org.apache.skywalking.oap.server.core.source.Source`. ");
                }
                ISource dispatcherSource = (ISource)source;
                SourceDispatcher dispatcher = (SourceDispatcher)aClass.newInstance();
                int scopeId = dispatcherSource.scope();
                List<SourceDispatcher<ISource>> dispatchers = this.dispatcherMap.get(scopeId);
                if (dispatchers == null) {
                    dispatchers = new ArrayList<SourceDispatcher<ISource>>();
                    this.dispatcherMap.put(scopeId, dispatchers);
                }
                dispatchers.add(dispatcher);
                LOGGER.info("Dispatcher {} is added into DefaultScopeDefine {}.", (Object)dispatcher.getClass().getName(), (Object)scopeId);
            }
        }
    }
}

