/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.graphql.protocol.GraphqlRequest;
import com.linecorp.armeria.internal.server.graphql.protocol.GraphqlUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.graphql.GraphqlErrorHandler;
import com.linecorp.armeria.server.graphql.GraphqlService;
import com.linecorp.armeria.server.graphql.GraphqlServiceContexts;
import com.linecorp.armeria.server.graphql.protocol.AbstractGraphqlService;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.dataloader.DataLoaderRegistry;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultGraphqlService
extends AbstractGraphqlService
implements GraphqlService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultGraphqlService.class);
    private final GraphQL graphQL;
    private final Function<? super ServiceRequestContext, ? extends DataLoaderRegistry> dataLoaderRegistryFunction;
    private final boolean useBlockingTaskExecutor;
    private final GraphqlErrorHandler errorHandler;

    DefaultGraphqlService(GraphQL graphQL, Function<? super ServiceRequestContext, ? extends DataLoaderRegistry> dataLoaderRegistryFunction, boolean useBlockingTaskExecutor, GraphqlErrorHandler errorHandler) {
        this.graphQL = Objects.requireNonNull(graphQL, "graphQL");
        this.dataLoaderRegistryFunction = Objects.requireNonNull(dataLoaderRegistryFunction, "dataLoaderRegistryFunction");
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
        this.errorHandler = errorHandler;
    }

    protected HttpResponse executeGraphql(ServiceRequestContext ctx, GraphqlRequest req) throws Exception {
        String operationName;
        Map extensions;
        MediaType produceType = GraphqlUtil.produceType((RequestHeaders)ctx.request().headers());
        if (produceType == null) {
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_ACCEPTABLE, (MediaType)MediaType.PLAIN_TEXT, (String)"Only %s and %s compatible media types are acceptable", (Object[])new Object[]{MediaType.GRAPHQL_RESPONSE_JSON, MediaType.JSON});
        }
        ExecutionInput.Builder builder = ExecutionInput.newExecutionInput((String)req.query());
        Map variables = req.variables();
        if (!variables.isEmpty()) {
            builder.variables(variables);
        }
        if (!(extensions = req.extensions()).isEmpty()) {
            builder.extensions(extensions);
        }
        if ((operationName = req.operationName()) != null) {
            builder.operationName(operationName);
        }
        ExecutionInput executionInput = builder.context((Object)ctx).graphQLContext(GraphqlServiceContexts.graphqlContext(ctx)).dataLoaderRegistry(this.dataLoaderRegistryFunction.apply((ServiceRequestContext)ctx)).build();
        return this.execute(ctx, executionInput, produceType);
    }

    private HttpResponse execute(ServiceRequestContext ctx, ExecutionInput input, MediaType produceType) {
        CompletableFuture<ExecutionResult> future = this.useBlockingTaskExecutor ? CompletableFuture.supplyAsync(() -> this.graphQL.execute(input), (Executor)ctx.blockingTaskExecutor()) : this.graphQL.executeAsync(input);
        return HttpResponse.of((CompletionStage)future.handle((executionResult, cause) -> {
            if (executionResult.getData() instanceof Publisher) {
                logger.warn("executionResult.getData() returns a {} that is not supported yet.", (Object)executionResult.getData().toString());
                return HttpResponse.ofJson((HttpStatus)HttpStatus.NOT_IMPLEMENTED, (MediaType)produceType, DefaultGraphqlService.toSpecification("WebSocket is not implemented"));
            }
            if (executionResult.getErrors().isEmpty() && cause == null) {
                return HttpResponse.ofJson((MediaType)produceType, (Object)executionResult.toSpecification());
            }
            return this.errorHandler.handle(ctx, input, (ExecutionResult)executionResult, (Throwable)cause);
        }));
    }

    static Map<String, Object> toSpecification(String message) {
        Objects.requireNonNull(message, "message");
        ImmutableMap error = ImmutableMap.of((Object)"message", (Object)message);
        return ImmutableMap.of((Object)"errors", (Object)ImmutableList.of((Object)error));
    }
}

