/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.Function;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.mqe.rt.type.ExpressionResult;

public class MathematicalFunctionOp {
    public static ExpressionResult doFunction0Op(ExpressionResult expResult, int opType) throws IllegalExpressionException {
        switch (opType) {
            case 29: {
                return MathematicalFunctionOp.transResult(expResult, Math::abs);
            }
            case 30: {
                return MathematicalFunctionOp.transResult(expResult, Math::ceil);
            }
            case 31: {
                return MathematicalFunctionOp.transResult(expResult, Math::floor);
            }
        }
        throw new IllegalExpressionException("Unsupported function.");
    }

    public static ExpressionResult doFunction1Op(ExpressionResult expResult, int opType, int scale) throws IllegalExpressionException {
        switch (opType) {
            case 32: {
                return MathematicalFunctionOp.transResult(expResult, aDouble -> {
                    BigDecimal bd = BigDecimal.valueOf(aDouble);
                    return bd.setScale(scale, RoundingMode.HALF_UP).doubleValue();
                });
            }
        }
        throw new IllegalExpressionException("Unsupported function.");
    }

    private static ExpressionResult transResult(ExpressionResult expResult, Function<Double, Double> calculator) {
        expResult.getResults().forEach(resultValues -> resultValues.getValues().forEach(mqeValue -> {
            if (!mqeValue.isEmptyValue()) {
                double newValue = (Double)calculator.apply(mqeValue.getDoubleValue());
                mqeValue.setDoubleValue(newValue);
            }
        }));
        return expResult;
    }
}

