/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import java.util.HashMap;
import java.util.List;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.mqe.rt.type.ExpressionResult;
import org.apache.skywalking.mqe.rt.type.ExpressionResultType;
import org.apache.skywalking.mqe.rt.type.MQEValue;
import org.apache.skywalking.mqe.rt.type.MQEValues;

@FunctionalInterface
public interface LROp {
    public double apply(double var1, double var3, int var5);

    public static ExpressionResult doLROp(ExpressionResult left, ExpressionResult right, int opType, LROp calculate) throws IllegalExpressionException {
        if (left.getType() == ExpressionResultType.SINGLE_VALUE && right.getType() == ExpressionResultType.SINGLE_VALUE) {
            return LROp.single2SingleBinaryOp(left, right, opType, calculate);
        }
        if ((left.getType() == ExpressionResultType.TIME_SERIES_VALUES || left.getType() == ExpressionResultType.SORTED_LIST || left.getType() == ExpressionResultType.RECORD_LIST) && right.getType() == ExpressionResultType.SINGLE_VALUE) {
            return LROp.many2OneBinaryOp(left, right, opType, calculate);
        }
        if (left.getType() == ExpressionResultType.SINGLE_VALUE && (right.getType() == ExpressionResultType.TIME_SERIES_VALUES || right.getType() == ExpressionResultType.SORTED_LIST || right.getType() == ExpressionResultType.RECORD_LIST)) {
            return LROp.one2ManyBinaryOp(left, right, opType, calculate);
        }
        if (left.getType() == ExpressionResultType.TIME_SERIES_VALUES && right.getType() == ExpressionResultType.TIME_SERIES_VALUES) {
            return LROp.seriesBinaryOp(left, right, opType, calculate);
        }
        throw new IllegalExpressionException("Unsupported operation.");
    }

    private static ExpressionResult seriesBinaryOp(ExpressionResult seriesLeft, ExpressionResult seriesRight, int opType, LROp calculate) throws IllegalExpressionException {
        ExpressionResult result = new ExpressionResult();
        result = !seriesLeft.isLabeledResult() && !seriesRight.isLabeledResult() ? LROp.seriesNoLabeled(seriesLeft, seriesRight, opType, calculate) : (seriesLeft.isLabeledResult() && !seriesRight.isLabeledResult() ? LROp.seriesLabeledWithNoLabeled(seriesLeft, seriesRight, opType, calculate) : (!seriesLeft.isLabeledResult() && seriesRight.isLabeledResult() ? LROp.seriesNoLabeledWithLabeled(seriesLeft, seriesRight, opType, calculate) : LROp.seriesLabeledWithLabeled(seriesLeft, seriesRight, opType, calculate)));
        return result;
    }

    private static ExpressionResult single2SingleBinaryOp(ExpressionResult singleLeft, ExpressionResult singleRight, int opType, LROp calculate) throws IllegalExpressionException {
        if (!singleLeft.isLabeledResult() && !singleRight.isLabeledResult()) {
            return LROp.single2SingleNoLabeled(singleLeft, singleRight, opType, calculate);
        }
        if (singleLeft.isLabeledResult() && !singleRight.isLabeledResult()) {
            return LROp.many2OneBinaryOp(singleLeft, singleRight, opType, calculate);
        }
        if (!singleLeft.isLabeledResult() && singleRight.isLabeledResult()) {
            return LROp.one2ManyBinaryOp(singleLeft, singleRight, opType, calculate);
        }
        return LROp.single2SingleLabeled(singleLeft, singleRight, opType, calculate);
    }

    private static ExpressionResult single2SingleNoLabeled(ExpressionResult singleLeft, ExpressionResult singleRight, int opType, LROp calculate) {
        ExpressionResult result = new ExpressionResult();
        MQEValue mqeValue = new MQEValue();
        MQEValues mqeValues = new MQEValues();
        mqeValues.getValues().add(mqeValue);
        result.getResults().add(mqeValues);
        result.setType(ExpressionResultType.SINGLE_VALUE);
        MQEValue left = singleLeft.getResults().get(0).getValues().get(0);
        MQEValue right = singleRight.getResults().get(0).getValues().get(0);
        if (left.isEmptyValue() || right.isEmptyValue()) {
            mqeValue.setEmptyValue(true);
        } else {
            double value = calculate.apply(left.getDoubleValue(), right.getDoubleValue(), opType);
            mqeValue.setDoubleValue(value);
            mqeValue.setEmptyValue(false);
        }
        return result;
    }

    private static ExpressionResult single2SingleLabeled(ExpressionResult singleLeft, ExpressionResult singleRight, int opType, LROp calculate) throws IllegalExpressionException {
        HashMap labelMapR = new HashMap();
        if (singleLeft.getResults().size() != singleRight.getResults().size()) {
            throw new IllegalExpressionException("Operation between labeled metrics should have the same label.");
        }
        singleRight.getResults().forEach(mqeValuesR -> labelMapR.put(mqeValuesR.getMetric().getLabels().get(0), mqeValuesR.getValues()));
        for (MQEValues mqeValuesL : singleLeft.getResults()) {
            MQEValue valueL = mqeValuesL.getValues().get(0);
            List mqeValuesR2 = (List)labelMapR.get(mqeValuesL.getMetric().getLabels().get(0));
            if (mqeValuesR2 == null) {
                throw new IllegalExpressionException("Operation between labeled metrics should have the same label.");
            }
            MQEValue valueR = (MQEValue)mqeValuesR2.get(0);
            if (valueL.isEmptyValue() || valueR.isEmptyValue()) {
                valueL.setEmptyValue(true);
                valueL.setDoubleValue(0.0);
                continue;
            }
            double value = calculate.apply(valueL.getDoubleValue(), valueR.getDoubleValue(), opType);
            valueL.setDoubleValue(value);
            valueL.setEmptyValue(false);
        }
        return singleLeft;
    }

    private static ExpressionResult many2OneBinaryOp(ExpressionResult manyResult, ExpressionResult singleResult, int opType, LROp calculate) {
        manyResult.getResults().forEach(mqeValues -> mqeValues.getValues().forEach(mqeValue -> {
            if (!mqeValue.isEmptyValue()) {
                double newValue = calculate.apply(mqeValue.getDoubleValue(), singleResult.getResults().get(0).getValues().get(0).getDoubleValue(), opType);
                mqeValue.setDoubleValue(newValue);
            }
        }));
        return manyResult;
    }

    private static ExpressionResult one2ManyBinaryOp(ExpressionResult singleResult, ExpressionResult manyResult, int opType, LROp calculate) {
        manyResult.getResults().forEach(mqeValues -> mqeValues.getValues().forEach(mqeValue -> {
            if (!mqeValue.isEmptyValue()) {
                double newValue = calculate.apply(singleResult.getResults().get(0).getValues().get(0).getDoubleValue(), mqeValue.getDoubleValue(), opType);
                mqeValue.setDoubleValue(newValue);
            }
        }));
        return manyResult;
    }

    private static ExpressionResult seriesNoLabeled(ExpressionResult seriesLeft, ExpressionResult seriesRight, int opType, LROp calculate) {
        MQEValues mqeValuesL = seriesLeft.getResults().get(0);
        MQEValues mqeValuesR = seriesRight.getResults().get(0);
        mqeValuesL.setMetric(null);
        for (int i = 0; i < mqeValuesL.getValues().size(); ++i) {
            MQEValue valueL = mqeValuesL.getValues().get(i);
            MQEValue valueR = mqeValuesR.getValues().get(i);
            if (valueL.isEmptyValue() || valueR.isEmptyValue()) {
                valueL.setEmptyValue(true);
                valueL.setDoubleValue(0.0);
                continue;
            }
            double newValue = calculate.apply(valueL.getDoubleValue(), valueR.getDoubleValue(), opType);
            mqeValuesL.getValues().get(i).setDoubleValue(newValue);
        }
        return seriesLeft;
    }

    private static ExpressionResult seriesLabeledWithNoLabeled(ExpressionResult seriesLeft, ExpressionResult seriesRight, int opType, LROp calculate) {
        MQEValues mqeValuesR = seriesRight.getResults().get(0);
        seriesLeft.getResults().forEach(mqeValuesL -> {
            for (int i = 0; i < mqeValuesL.getValues().size(); ++i) {
                MQEValue valueL = mqeValuesL.getValues().get(i);
                MQEValue valueR = mqeValuesR.getValues().get(i);
                if (valueL.isEmptyValue() || valueR.isEmptyValue()) {
                    valueL.setEmptyValue(true);
                    valueL.setDoubleValue(0.0);
                    continue;
                }
                double newValue = calculate.apply(valueL.getDoubleValue(), valueR.getDoubleValue(), opType);
                mqeValuesL.getValues().get(i).setDoubleValue(newValue);
            }
        });
        return seriesLeft;
    }

    private static ExpressionResult seriesNoLabeledWithLabeled(ExpressionResult seriesLeft, ExpressionResult seriesRight, int opType, LROp calculate) {
        MQEValues mqeValuesL = seriesLeft.getResults().get(0);
        seriesRight.getResults().forEach(mqeValuesR -> {
            for (int i = 0; i < mqeValuesL.getValues().size(); ++i) {
                MQEValue valueL = mqeValuesL.getValues().get(i);
                MQEValue valueR = mqeValuesR.getValues().get(i);
                if (valueL.isEmptyValue() || valueR.isEmptyValue()) {
                    valueL.setEmptyValue(true);
                    valueL.setDoubleValue(0.0);
                    continue;
                }
                double newValue = calculate.apply(valueL.getDoubleValue(), valueR.getDoubleValue(), opType);
                mqeValuesR.getValues().get(i).setDoubleValue(newValue);
            }
        });
        return seriesRight;
    }

    private static ExpressionResult seriesLabeledWithLabeled(ExpressionResult seriesLeft, ExpressionResult seriesRight, int opType, LROp calculate) throws IllegalExpressionException {
        HashMap labelMapR = new HashMap();
        if (seriesLeft.getResults().size() != seriesRight.getResults().size()) {
            throw new IllegalExpressionException("Operation between labeled metrics should have the same label.");
        }
        seriesRight.getResults().forEach(mqeValuesR -> labelMapR.put(mqeValuesR.getMetric().getLabels().get(0), mqeValuesR.getValues()));
        for (MQEValues mqeValuesL : seriesLeft.getResults()) {
            for (int i = 0; i < mqeValuesL.getValues().size(); ++i) {
                MQEValue valueL = mqeValuesL.getValues().get(i);
                List mqeValuesR2 = (List)labelMapR.get(mqeValuesL.getMetric().getLabels().get(0));
                if (mqeValuesR2 == null) {
                    throw new IllegalExpressionException("Operation between labeled metrics should have the same label.");
                }
                MQEValue valueR = (MQEValue)mqeValuesR2.get(i);
                if (valueL.isEmptyValue() || valueR.isEmptyValue()) {
                    valueL.setEmptyValue(true);
                    valueL.setDoubleValue(0.0);
                    continue;
                }
                double newValue = calculate.apply(valueL.getDoubleValue(), valueR.getDoubleValue(), opType);
                mqeValuesL.getValues().get(i).setDoubleValue(newValue);
            }
        }
        return seriesLeft;
    }
}

