/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.mqe.rt.operation.LROp;
import org.apache.skywalking.mqe.rt.type.ExpressionResult;

public class BinaryOp {
    public static ExpressionResult doBinaryOp(ExpressionResult left, ExpressionResult right, int opType) throws IllegalExpressionException {
        try {
            return LROp.doLROp(left, right, opType, BinaryOp::scalarBinaryOp);
        }
        catch (IllegalExpressionException e) {
            throw new IllegalExpressionException("Unsupported binary operation.");
        }
    }

    private static double scalarBinaryOp(double leftValue, double rightValue, int opType) {
        double calculatedResult = 0.0;
        switch (opType) {
            case 13: {
                calculatedResult = leftValue + rightValue;
                break;
            }
            case 12: {
                calculatedResult = leftValue - rightValue;
                break;
            }
            case 14: {
                calculatedResult = leftValue * rightValue;
                break;
            }
            case 15: {
                calculatedResult = leftValue / rightValue;
                break;
            }
            case 16: {
                calculatedResult = leftValue % rightValue;
            }
        }
        return calculatedResult;
    }
}

