/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.zipkin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchParams;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.Aggregation;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.AggregationBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.BucketOrder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.TermsAggregationBuilder;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.storage.query.IZipkinQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.zipkin.ZipkinServiceRelationTraffic;
import org.apache.skywalking.oap.server.core.zipkin.ZipkinServiceSpanTraffic;
import org.apache.skywalking.oap.server.core.zipkin.ZipkinServiceTraffic;
import org.apache.skywalking.oap.server.core.zipkin.ZipkinSpanRecord;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchScroller;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.RoutingUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeRangeIndexNameGenerator;
import zipkin2.Span;
import zipkin2.storage.QueryRequest;

public class ZipkinQueryEsDAO
extends EsDAO
implements IZipkinQueryDAO {
    private static final int NAME_QUERY_MAX_SIZE = 10000;
    private static final int SCROLLING_BATCH_SIZE = 5000;

    public ZipkinQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public List<String> getServiceNames() {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("zipkin_service_traffic");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("zipkin_service_traffic")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"zipkin_service_traffic"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(5000));
        ElasticSearchScroller scroller = ElasticSearchScroller.builder().client((ElasticSearchClient)this.getClient()).search(search.build()).index(index).resultConverter(hit -> {
            Map sourceAsMap = hit.getSource();
            ZipkinServiceTraffic record = new ZipkinServiceTraffic.Builder().storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("zipkin_service_traffic", sourceAsMap));
            return record.getServiceName();
        }).build();
        return scroller.scroll();
    }

    public List<String> getRemoteServiceNames(String serviceName) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("zipkin_service_relation_traffic");
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.term((String)"service_name", (Object)serviceName));
        if (IndexController.LogicIndicesRegister.isMergedTable("zipkin_service_relation_traffic")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"zipkin_service_relation_traffic"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(10000));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        ArrayList<String> remoteServices = new ArrayList<String>();
        for (SearchHit searchHit : response.getHits()) {
            Map sourceAsMap = searchHit.getSource();
            ZipkinServiceRelationTraffic record = new ZipkinServiceRelationTraffic.Builder().storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("zipkin_service_relation_traffic", sourceAsMap));
            remoteServices.add(record.getRemoteServiceName());
        }
        return remoteServices;
    }

    public List<String> getSpanNames(String serviceName) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("zipkin_service_span_traffic");
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.term((String)"service_name", (Object)serviceName));
        if (IndexController.LogicIndicesRegister.isMergedTable("zipkin_service_span_traffic")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"zipkin_service_span_traffic"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(10000));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        ArrayList<String> spanNames = new ArrayList<String>();
        for (SearchHit searchHit : response.getHits()) {
            Map sourceAsMap = searchHit.getSource();
            ZipkinServiceSpanTraffic record = new ZipkinServiceSpanTraffic.Builder().storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("zipkin_service_span_traffic", sourceAsMap));
            spanNames.add(record.getSpanName());
        }
        return spanNames;
    }

    public List<Span> getTrace(String traceId) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("zipkin_span");
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.term((String)"trace_id", (Object)traceId));
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(5000));
        SearchParams params = new SearchParams();
        RoutingUtils.addRoutingValueToSearchParam(params, traceId);
        ElasticSearchScroller scroller = ElasticSearchScroller.builder().client((ElasticSearchClient)this.getClient()).search(search.build()).index(index).params(params).resultConverter(searchHit -> {
            Map sourceAsMap = searchHit.getSource();
            ZipkinSpanRecord record = new ZipkinSpanRecord.Builder().storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("zipkin_span", sourceAsMap));
            return ZipkinSpanRecord.buildSpanFromRecord((ZipkinSpanRecord)record);
        }).build();
        return scroller.scroll();
    }

    public List<List<Span>> getTraces(QueryRequest request, Duration duration) {
        long startTimeMillis = duration.getStartTimestamp();
        long endTimeMillis = duration.getEndTimestamp();
        BoolQueryBuilder query = Query.bool();
        if (startTimeMillis > 0L && endTimeMillis > 0L) {
            query.must((QueryBuilder)Query.range((String)"timestamp_millis").gte((Object)startTimeMillis).lte((Object)endTimeMillis));
        }
        if (!StringUtil.isEmpty((String)request.serviceName())) {
            query.must((QueryBuilder)Query.term((String)"local_endpoint_service_name", (Object)request.serviceName()));
        }
        if (!StringUtil.isEmpty((String)request.remoteServiceName())) {
            query.must((QueryBuilder)Query.term((String)"remote_endpoint_service_name", (Object)request.remoteServiceName()));
        }
        if (!StringUtil.isEmpty((String)request.spanName())) {
            query.must((QueryBuilder)Query.term((String)"name", (Object)request.spanName()));
        }
        if (!CollectionUtils.isEmpty((Map)request.annotationQuery())) {
            for (Map.Entry annotation : request.annotationQuery().entrySet()) {
                if (((String)annotation.getValue()).isEmpty()) {
                    query.must((QueryBuilder)Query.term((String)"query", annotation.getKey()));
                    continue;
                }
                query.must((QueryBuilder)Query.term((String)"query", (Object)((String)annotation.getKey() + "=" + (String)annotation.getValue())));
            }
        }
        if (request.minDuration() != null) {
            query.must((QueryBuilder)Query.range((String)"duration").gte((Object)request.minDuration()));
        }
        if (request.maxDuration() != null) {
            query.must((QueryBuilder)Query.range((String)"duration").lte((Object)request.maxDuration()));
        }
        TermsAggregationBuilder traceIdAggregation = Aggregation.terms((String)"trace_id").field("trace_id").executionHint(TermsAggregationBuilder.ExecutionHint.MAP).collectMode(TermsAggregationBuilder.CollectMode.BREADTH_FIRST).size(request.limit()).subAggregation((AggregationBuilder)Aggregation.min((String)"timestamp_millis").field("timestamp_millis")).order(BucketOrder.aggregation((String)"timestamp_millis", (boolean)false));
        SearchBuilder search = Search.builder().query((QueryBuilder)query).aggregation((AggregationBuilder)traceIdAggregation);
        SearchResponse traceIdResponse = ((ElasticSearchClient)this.getClient()).search((Supplier)new TimeRangeIndexNameGenerator(IndexController.LogicIndicesRegister.getPhysicalTableName("zipkin_span"), TimeBucket.getRecordTimeBucket((long)startTimeMillis), TimeBucket.getRecordTimeBucket((long)endTimeMillis)), search.build());
        HashSet<String> traceIds = new HashSet<String>();
        if (Objects.nonNull(traceIdResponse.getAggregations())) {
            Map idTerms = (Map)traceIdResponse.getAggregations().get("trace_id");
            List buckets = (List)idTerms.get("buckets");
            for (Map idBucket : buckets) {
                traceIds.add((String)idBucket.get("key"));
            }
        }
        return this.getTraces(traceIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<List<Span>> getTraces(Set<String> traceIds) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("zipkin_span");
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.terms((String)"trace_id", new ArrayList<String>(traceIds)));
        SearchBuilder search = Search.builder().query((QueryBuilder)query).sort("timestamp_millis", Sort.Order.DESC).size(Integer.valueOf(5000));
        SearchParams params = new SearchParams().scroll(SCROLL_CONTEXT_RETENTION);
        RoutingUtils.addRoutingValuesToSearchParam(params, traceIds);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build(), params);
        HashSet<String> scrollIds = new HashSet<String>();
        LinkedHashMap<String, List<Span>> groupedByTraceId = new LinkedHashMap<String, List<Span>>();
        try {
            while (response.getHits().getHits().size() != 0) {
                String scrollId = response.getScrollId();
                scrollIds.add(scrollId);
                this.buildTraces(response, groupedByTraceId);
                if (response.getHits().getHits().size() >= 5000) {
                    response = ((ElasticSearchClient)this.getClient()).scroll(SCROLL_CONTEXT_RETENTION, scrollId);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            scrollIds.forEach(arg_0 -> ((ElasticSearchClient)((ElasticSearchClient)this.getClient())).deleteScrollContextQuietly(arg_0));
            throw throwable;
        }
        scrollIds.forEach(arg_0 -> ((ElasticSearchClient)((ElasticSearchClient)this.getClient())).deleteScrollContextQuietly(arg_0));
        return new ArrayList<List<Span>>(groupedByTraceId.values());
    }

    private void buildTraces(SearchResponse response, Map<String, List<Span>> groupedByTraceId) {
        for (SearchHit searchHit : response.getHits()) {
            Map sourceAsMap = searchHit.getSource();
            ZipkinSpanRecord record = new ZipkinSpanRecord.Builder().storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("zipkin_span", sourceAsMap));
            Span span = ZipkinSpanRecord.buildSpanFromRecord((ZipkinSpanRecord)record);
            String traceId = span.traceId();
            groupedByTraceId.putIfAbsent(traceId, new ArrayList());
            groupedByTraceId.get(traceId).add(span);
        }
    }
}

