/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventTraceType;
import org.apache.skywalking.oap.server.core.storage.query.ISpanAttachedEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchScroller;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class SpanAttachedEventEsDAO
extends EsDAO
implements ISpanAttachedEventQueryDAO {
    private final int scrollingBatchSize;
    protected Function<SearchHit, SpanAttachedEventRecord> searchHitSpanAttachedEventRecordFunction = hit -> {
        Map sourceAsMap = hit.getSource();
        SpanAttachedEventRecord.Builder builder = new SpanAttachedEventRecord.Builder();
        return builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("span_attached_event_record", sourceAsMap));
    };

    public SpanAttachedEventEsDAO(ElasticSearchClient client, StorageModuleElasticsearchConfig config) {
        super(client);
        this.scrollingBatchSize = config.getProfileDataQueryBatchSize();
    }

    public List<SpanAttachedEventRecord> querySpanAttachedEvents(SpanAttachedEventTraceType type, List<String> traceIds) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("span_attached_event_record");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("span_attached_event_record")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"span_attached_event_record"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(this.scrollingBatchSize));
        query.must((QueryBuilder)Query.terms((String)"related_trace_id", traceIds));
        query.must((QueryBuilder)Query.terms((String)"trace_ref_type", (Object[])new Object[]{type.value()}));
        search.sort("start_time_second", Sort.Order.ASC);
        search.sort("start_time_nanos", Sort.Order.ASC);
        ElasticSearchScroller scroller = ElasticSearchScroller.builder().client((ElasticSearchClient)this.getClient()).search(search.build()).index(index).resultConverter(this.searchHitSpanAttachedEventRecordFunction).build();
        return scroller.scroll();
    }
}

