/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.RangeQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.endpoint.EndpointTraffic;
import org.apache.skywalking.oap.server.core.analysis.manual.instance.InstanceTraffic;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessDetectType;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessTraffic;
import org.apache.skywalking.oap.server.core.analysis.manual.service.ServiceTraffic;
import org.apache.skywalking.oap.server.core.query.enumeration.Language;
import org.apache.skywalking.oap.server.core.query.enumeration.ProfilingSupportStatus;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Attribute;
import org.apache.skywalking.oap.server.core.query.type.Endpoint;
import org.apache.skywalking.oap.server.core.query.type.Process;
import org.apache.skywalking.oap.server.core.query.type.Service;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchScroller;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.MatchCNameBuilder;

public class MetadataQueryEsDAO
extends EsDAO
implements IMetadataQueryDAO {
    private static final Gson GSON = new Gson();
    private final int queryMaxSize;
    private final int scrollingBatchSize;
    private String endpointTrafficNameAlias;
    private boolean aliasNameInit = false;
    private final int layerSize;
    protected final Function<SearchHit, Service> searchHitServiceFunction = hit -> {
        Map sourceAsMap = hit.getSource();
        ServiceTraffic.Builder builder = new ServiceTraffic.Builder();
        ServiceTraffic serviceTraffic = builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("service_traffic", sourceAsMap));
        String serviceName = serviceTraffic.getName();
        Service service = new Service();
        service.setId(serviceTraffic.getServiceId());
        service.setName(serviceName);
        service.setShortName(serviceTraffic.getShortName());
        service.setGroup(serviceTraffic.getGroup());
        service.getLayers().add(serviceTraffic.getLayer().name());
        return service;
    };
    protected final Function<SearchHit, ServiceInstance> searchHitServiceInstanceFunction = hit -> {
        Map sourceAsMap = hit.getSource();
        InstanceTraffic instanceTraffic = new InstanceTraffic.Builder().storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("instance_traffic", sourceAsMap));
        ServiceInstance serviceInstance = new ServiceInstance();
        serviceInstance.setId(instanceTraffic.id().build());
        serviceInstance.setName(instanceTraffic.getName());
        serviceInstance.setInstanceUUID(serviceInstance.getId());
        JsonObject properties = instanceTraffic.getProperties();
        if (properties != null) {
            for (Map.Entry property : properties.entrySet()) {
                String key = (String)property.getKey();
                String value = ((JsonElement)property.getValue()).getAsString();
                if (key.equals("language")) {
                    serviceInstance.setLanguage(Language.value((String)value));
                    continue;
                }
                serviceInstance.getAttributes().add(new Attribute(key, value));
            }
        } else {
            serviceInstance.setLanguage(Language.UNKNOWN);
        }
        return serviceInstance;
    };

    public MetadataQueryEsDAO(ElasticSearchClient client, StorageModuleElasticsearchConfig config) {
        super(client);
        this.queryMaxSize = config.getMetadataQueryMaxSize();
        this.scrollingBatchSize = config.getScrollingBatchSize();
        this.layerSize = Layer.values().length;
    }

    public List<Service> listServices() {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("service_traffic");
        int batchSize = Math.min(this.queryMaxSize, this.scrollingBatchSize);
        BoolQueryBuilder query = Query.bool();
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(batchSize));
        if (IndexController.LogicIndicesRegister.isMergedTable("service_traffic")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"service_traffic"));
        }
        ElasticSearchScroller scroller = ElasticSearchScroller.builder().client((ElasticSearchClient)this.getClient()).search(search.build()).index(index).queryMaxSize(this.queryMaxSize).resultConverter(this.searchHitServiceFunction).build();
        return scroller.scroll();
    }

    public List<ServiceInstance> listInstances(Duration duration, String serviceId) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("instance_traffic");
        long startMinuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)duration.getStartTimestamp());
        long endMinuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)duration.getEndTimestamp());
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.range((String)"last_ping").gte((Object)startMinuteTimeBucket)).must((QueryBuilder)Query.range((String)"time_bucket").lt((Object)endMinuteTimeBucket)).must((QueryBuilder)Query.term((String)"service_id", (Object)serviceId));
        if (IndexController.LogicIndicesRegister.isMergedTable("instance_traffic")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"instance_traffic"));
        }
        int batchSize = Math.min(this.queryMaxSize, this.scrollingBatchSize);
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(batchSize));
        ElasticSearchScroller scroller = ElasticSearchScroller.builder().client((ElasticSearchClient)this.getClient()).search(search.build()).index(index).queryMaxSize(this.queryMaxSize).resultConverter(this.searchHitServiceInstanceFunction).build();
        return scroller.scroll();
    }

    public ServiceInstance getInstance(String instanceId) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("instance_traffic");
        String id = instanceId;
        if (IndexController.LogicIndicesRegister.isMergedTable("instance_traffic")) {
            id = IndexController.INSTANCE.generateDocId("instance_traffic", instanceId);
        }
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.term((String)"_id", (Object)id));
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(1));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        List<ServiceInstance> instances = this.buildInstances(response);
        return instances.size() > 0 ? instances.get(0) : null;
    }

    public List<ServiceInstance> getInstances(List<String> instanceIds) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("instance_traffic");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("instance_traffic")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"instance_traffic"));
            instanceIds = instanceIds.stream().map(s -> IndexController.INSTANCE.generateDocId("instance_traffic", (String)s)).collect(Collectors.toList());
        }
        query.must((QueryBuilder)Query.terms((String)"_id", instanceIds));
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(instanceIds.size()));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        return this.buildInstances(response);
    }

    public List<Endpoint> findEndpoint(String keyword, String serviceId, int limit) {
        this.initColumnName();
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("endpoint_traffic");
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.term((String)"service_id", (Object)serviceId));
        if (!Strings.isNullOrEmpty((String)keyword)) {
            String matchCName = MatchCNameBuilder.INSTANCE.build(this.endpointTrafficNameAlias);
            query.must((QueryBuilder)Query.match((String)matchCName, (String)keyword));
        }
        if (IndexController.LogicIndicesRegister.isMergedTable("endpoint_traffic")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"endpoint_traffic"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(limit));
        ElasticSearchScroller scroller = ElasticSearchScroller.builder().client((ElasticSearchClient)this.getClient()).search(search.build()).index(index).queryMaxSize(limit).resultConverter(searchHit -> {
            Map sourceAsMap = searchHit.getSource();
            EndpointTraffic endpointTraffic = new EndpointTraffic.Builder().storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("endpoint_traffic", sourceAsMap));
            Endpoint endpoint = new Endpoint();
            endpoint.setId(endpointTraffic.id().build());
            endpoint.setName(endpointTraffic.getName());
            return endpoint;
        }).build();
        return scroller.scroll();
    }

    public List<Process> listProcesses(String serviceId, ProfilingSupportStatus supportStatus, long lastPingStartTimeBucket, long lastPingEndTimeBucket) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("process_traffic");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("process_traffic")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"process_traffic"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(this.queryMaxSize));
        this.appendProcessWhereQuery(query, serviceId, null, null, supportStatus, lastPingStartTimeBucket, lastPingEndTimeBucket, false);
        ElasticSearchScroller scroller = ElasticSearchScroller.builder().client((ElasticSearchClient)this.getClient()).search(search.build()).index(index).queryMaxSize(this.queryMaxSize).resultConverter(this::buildProcess).build();
        return scroller.scroll();
    }

    public List<Process> listProcesses(String serviceInstanceId, Duration duration, boolean includeVirtual) {
        long lastPingStartTimeBucket = duration.getStartTimeBucket();
        long lastPingEndTimeBucket = duration.getEndTimeBucket();
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("process_traffic");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("process_traffic")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"process_traffic"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(this.queryMaxSize));
        this.appendProcessWhereQuery(query, null, serviceInstanceId, null, null, lastPingStartTimeBucket, lastPingEndTimeBucket, includeVirtual);
        ElasticSearchScroller scroller = ElasticSearchScroller.builder().client((ElasticSearchClient)this.getClient()).search(search.build()).index(index).queryMaxSize(this.queryMaxSize).resultConverter(this::buildProcess).build();
        return scroller.scroll();
    }

    public List<Process> listProcesses(String agentId) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("process_traffic");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("process_traffic")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"process_traffic"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(this.queryMaxSize));
        this.appendProcessWhereQuery(query, null, null, agentId, null, 0L, 0L, false);
        ElasticSearchScroller scroller = ElasticSearchScroller.builder().client((ElasticSearchClient)this.getClient()).search(search.build()).index(index).queryMaxSize(this.queryMaxSize).resultConverter(this::buildProcess).build();
        return scroller.scroll();
    }

    public long getProcessCount(String serviceId, ProfilingSupportStatus profilingSupportStatus, long lastPingStartTimeBucket, long lastPingEndTimeBucket) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("process_traffic");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("process_traffic")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"process_traffic"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(0));
        this.appendProcessWhereQuery(query, serviceId, null, null, profilingSupportStatus, lastPingStartTimeBucket, lastPingEndTimeBucket, false);
        SearchResponse results = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        return results.getHits().getTotal();
    }

    public long getProcessCount(String instanceId) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("process_traffic");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("process_traffic")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"process_traffic"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(0));
        this.appendProcessWhereQuery(query, null, instanceId, null, null, 0L, 0L, false);
        SearchResponse results = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        return results.getHits().getTotal();
    }

    private void appendProcessWhereQuery(BoolQueryBuilder query, String serviceId, String instanceId, String agentId, ProfilingSupportStatus profilingSupportStatus, long lastPingStartTimeBucket, long lastPingEndTimeBucket, boolean includeVirtual) {
        if (StringUtil.isNotEmpty((String)serviceId)) {
            query.must((QueryBuilder)Query.term((String)"service_id", (Object)serviceId));
        }
        if (StringUtil.isNotEmpty((String)instanceId)) {
            query.must((QueryBuilder)Query.term((String)"instance_id", (Object)instanceId));
        }
        if (StringUtil.isNotEmpty((String)agentId)) {
            query.must((QueryBuilder)Query.term((String)"agent_id", (Object)agentId));
        }
        if (profilingSupportStatus != null) {
            query.must((QueryBuilder)Query.term((String)"profiling_support_status", (Object)profilingSupportStatus.value()));
        }
        if (lastPingStartTimeBucket > 0L) {
            RangeQueryBuilder rangeQuery = Query.range((String)"last_ping");
            rangeQuery.gte((Object)lastPingStartTimeBucket);
            query.must((QueryBuilder)rangeQuery);
        }
        if (!includeVirtual) {
            query.mustNot((QueryBuilder)Query.term((String)"detect_type", (Object)ProcessDetectType.VIRTUAL.value()));
        }
    }

    public Process getProcess(String processId) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("process_traffic");
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.term((String)"_id", (Object)processId));
        if (IndexController.LogicIndicesRegister.isMergedTable("process_traffic")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"process_traffic"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(this.queryMaxSize));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        Iterator iterator = response.getHits().iterator();
        if (iterator.hasNext()) {
            return this.buildProcess((SearchHit)iterator.next());
        }
        return null;
    }

    private List<Service> buildServices(SearchResponse response) {
        ArrayList<Service> services = new ArrayList<Service>();
        for (SearchHit hit : response.getHits()) {
            services.add(this.searchHitServiceFunction.apply(hit));
        }
        return services;
    }

    private List<ServiceInstance> buildInstances(SearchResponse response) {
        ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>();
        for (SearchHit searchHit : response.getHits()) {
            serviceInstances.add(this.searchHitServiceInstanceFunction.apply(searchHit));
        }
        return serviceInstances;
    }

    private Process buildProcess(SearchHit searchHit) {
        String labelsJson;
        Map sourceAsMap = searchHit.getSource();
        ProcessTraffic processTraffic = new ProcessTraffic.Builder().storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("process_traffic", sourceAsMap));
        Process process = new Process();
        process.setId(processTraffic.id().build());
        process.setName(processTraffic.getName());
        String serviceId = processTraffic.getServiceId();
        process.setServiceId(serviceId);
        process.setServiceName(IDManager.ServiceID.analysisId((String)serviceId).getName());
        String instanceId = processTraffic.getInstanceId();
        process.setInstanceId(instanceId);
        process.setInstanceName(IDManager.ServiceInstanceID.analysisId((String)instanceId).getName());
        process.setAgentId(processTraffic.getAgentId());
        process.setDetectType(ProcessDetectType.valueOf((int)processTraffic.getDetectType()).name());
        process.setProfilingSupportStatus(ProfilingSupportStatus.valueOf((int)processTraffic.getProfilingSupportStatus()).name());
        JsonObject properties = processTraffic.getProperties();
        if (properties != null) {
            for (Map.Entry property : properties.entrySet()) {
                String key = (String)property.getKey();
                String value = ((JsonElement)property.getValue()).getAsString();
                process.getAttributes().add(new Attribute(key, value));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(labelsJson = processTraffic.getLabelsJson()))) {
            List labels = (List)GSON.fromJson(labelsJson, ArrayList.class);
            process.getLabels().addAll(labels);
        }
        return process;
    }

    private void initColumnName() {
        if (!this.aliasNameInit) {
            this.endpointTrafficNameAlias = IndexController.LogicIndicesRegister.getPhysicalColumnName("endpoint_traffic", "endpoint_traffic_name");
            this.aliasNameInit = true;
        }
    }
}

