/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.protobuf;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.server.ResponseConversionUtil;
import com.linecorp.armeria.internal.server.annotation.ClassUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.protobuf.ProtobufRequestConverterFunction;
import com.linecorp.armeria.server.streaming.JsonTextSequences;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

@UnstableApi
public final class ProtobufResponseConverterFunction
implements ResponseConverterFunction {
    private static final MethodHandle fromPublisherMH;
    private static final MethodHandle fromStreamMH;
    private static final MethodHandle fromObjectMH;
    static final MediaType X_PROTOBUF;
    private static final JsonFormat.Printer defaultJsonPrinter;
    private final JsonFormat.Printer jsonPrinter;

    public ProtobufResponseConverterFunction() {
        this(defaultJsonPrinter);
    }

    public ProtobufResponseConverterFunction(JsonFormat.Printer jsonPrinter) {
        this.jsonPrinter = Objects.requireNonNull(jsonPrinter, "jsonPrinter");
    }

    public Boolean isResponseStreaming(Type returnType, @Nullable MediaType produceType) {
        Class clazz = ClassUtil.typeToClass((Type)ClassUtil.unwrapUnaryAsyncType((Type)returnType));
        if (clazz == null) {
            return null;
        }
        if (ProtobufRequestConverterFunction.isJson(produceType)) {
            return false;
        }
        if (Message.class.isAssignableFrom(clazz) && ProtobufRequestConverterFunction.isProtobuf(produceType)) {
            return false;
        }
        if (ProtobufResponseConverterFunction.isJsonSeq(produceType) && (Publisher.class.isAssignableFrom(clazz) || Stream.class.isAssignableFrom(clazz))) {
            return true;
        }
        return null;
    }

    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) throws Exception {
        MediaType contentType = headers.contentType();
        boolean isJson = ProtobufRequestConverterFunction.isJson(contentType);
        if (ProtobufResponseConverterFunction.isJsonSeq(contentType)) {
            Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"a null value is not allowed for %s", (Object)contentType);
            Function<Object, String> toJson = this::toJson;
            if (result instanceof Publisher) {
                Publisher publisher = (Publisher)result;
                try {
                    return fromPublisherMH.invoke(headers, publisher, trailers, toJson);
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Failed to call JsonTextSequences.fromPublisher() through reflection", ex);
                }
            }
            if (result instanceof Stream) {
                Stream stream = (Stream)result;
                try {
                    return fromStreamMH.invoke(headers, stream, trailers, ctx.blockingTaskExecutor(), toJson);
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Failed to call JsonTextSequences.fromStream() through reflection", ex);
                }
            }
            try {
                return fromObjectMH.invoke(headers, result, trailers, toJson);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to call JsonTextSequences.fromObject() through reflection", ex);
            }
        }
        if (result instanceof Message) {
            if (isJson) {
                Charset charset = contentType.charset(StandardCharsets.UTF_8);
                return HttpResponse.of((ResponseHeaders)headers, (HttpData)this.toJsonHttpData(result, charset), (HttpHeaders)trailers);
            }
            if (contentType == null) {
                return HttpResponse.of((ResponseHeaders)headers.toBuilder().contentType(MediaType.PROTOBUF).build(), (HttpData)ProtobufResponseConverterFunction.toProtobuf(result), (HttpHeaders)trailers);
            }
            if (ProtobufRequestConverterFunction.isProtobuf(contentType)) {
                return HttpResponse.of((ResponseHeaders)headers, (HttpData)ProtobufResponseConverterFunction.toProtobuf(result), (HttpHeaders)trailers);
            }
            return (HttpResponse)ResponseConverterFunction.fallthrough();
        }
        if (isJson) {
            Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"a null value is not allowed for %s", (Object)contentType);
            Charset charset = contentType.charset(StandardCharsets.UTF_8);
            if (result instanceof Publisher) {
                Publisher publisher = (Publisher)result;
                return ResponseConversionUtil.aggregateFrom((Publisher)publisher, (ResponseHeaders)headers, (HttpHeaders)trailers, obj -> this.toJsonHttpData(obj, charset), (ServiceRequestContext)ctx);
            }
            if (result instanceof Stream) {
                Stream stream = (Stream)result;
                return ResponseConversionUtil.aggregateFrom((Stream)stream, (ResponseHeaders)headers, (HttpHeaders)trailers, obj -> this.toJsonHttpData(obj, charset), (Executor)ctx.blockingTaskExecutor());
            }
            return HttpResponse.of((ResponseHeaders)headers, (HttpData)this.toJsonHttpData(result, charset), (HttpHeaders)trailers);
        }
        throw new IllegalArgumentException("Cannot convert a " + result + " to Protocol Buffers wire format");
    }

    private static HttpData toProtobuf(Object message) {
        if (!(message instanceof Message)) {
            throw new IllegalStateException("Unexpected message type : " + message.getClass() + " (expected: a subtype of " + Message.class.getName() + ')');
        }
        try {
            Message cast = (Message)message;
            return HttpData.wrap((byte[])cast.toByteArray());
        }
        catch (Exception e) {
            return (HttpData)Exceptions.throwUnsafely((Throwable)e);
        }
    }

    private HttpData toJsonHttpData(Object message, Charset charset) {
        return HttpData.of((Charset)charset, (String)this.toJson(message));
    }

    private String toJson(Object message) {
        if (message instanceof Iterable) {
            return Streams.stream((Iterable)((Iterable)message)).map(this::toJson).collect(Collectors.joining(",", "[", "]"));
        }
        if (message instanceof Map) {
            Map map = (Map)message;
            return map.entrySet().stream().map(entry -> '\"' + entry.getKey().toString() + "\":" + this.toJson(entry.getValue())).collect(Collectors.joining(",", "{", "}"));
        }
        if (!(message instanceof Message)) {
            throw new IllegalStateException("Unexpected message type : " + message.getClass() + " (expected: a subtype of " + Message.class.getName() + ')');
        }
        try {
            return this.jsonPrinter.print((MessageOrBuilder)((Message)message));
        }
        catch (Exception e) {
            return (String)Exceptions.throwUnsafely((Throwable)e);
        }
    }

    private static boolean isJsonSeq(@Nullable MediaType mediaType) {
        return mediaType != null && mediaType.is(MediaType.JSON_SEQ);
    }

    static {
        MethodHandle fromObject;
        MethodHandle fromStream;
        MethodHandle fromPublisher;
        try {
            Method method = JsonTextSequences.class.getDeclaredMethod("fromPublisher", ResponseHeaders.class, Publisher.class, HttpHeaders.class, Function.class);
            method.setAccessible(true);
            fromPublisher = MethodHandles.lookup().unreflect(method);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            fromPublisher = null;
        }
        fromPublisherMH = fromPublisher;
        try {
            Method method = JsonTextSequences.class.getDeclaredMethod("fromStream", ResponseHeaders.class, Stream.class, HttpHeaders.class, Executor.class, Function.class);
            method.setAccessible(true);
            fromStream = MethodHandles.lookup().unreflect(method);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            fromStream = null;
        }
        fromStreamMH = fromStream;
        try {
            Method method = JsonTextSequences.class.getDeclaredMethod("fromObject", ResponseHeaders.class, Object.class, HttpHeaders.class, Function.class);
            method.setAccessible(true);
            fromObject = MethodHandles.lookup().unreflect(method);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            fromObject = null;
        }
        fromObjectMH = fromObject;
        X_PROTOBUF = MediaType.create((String)"application", (String)"x-protobuf");
        defaultJsonPrinter = JsonFormat.printer();
    }
}

