/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.storage.query.ITagAutoCompleteQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.SQLAndParameters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCTagAutoCompleteQueryDAO
implements ITagAutoCompleteQueryDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public Set<String> queryTagAutocompleteKeys(TagType tagType, int limit, Duration duration) {
        List<String> tables = this.tableHelper.getTablesForRead("tag_autocomplete", duration.getStartTimeBucket(), duration.getEndTimeBucket());
        HashSet<String> results = new HashSet<String>();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQLForQueryKeys(tagType, limit, duration, table);
            this.jdbcClient.executeQuery(sqlAndParameters.sql(), resultSet -> {
                while (resultSet.next()) {
                    results.add(resultSet.getString("tag_key"));
                }
                return null;
            }, sqlAndParameters.parameters());
        }
        return results;
    }

    protected SQLAndParameters buildSQLForQueryKeys(TagType tagType, int limit, Duration duration, String table) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> condition = new ArrayList<Object>(2);
        sql.append("select distinct ").append("tag_key").append(" from ").append(table).append(" where ");
        sql.append(" 1=1 ");
        this.appendTagAutocompleteCondition(tagType, duration, sql, condition);
        sql.append(" limit ").append(limit);
        return new SQLAndParameters(sql.toString(), condition);
    }

    public Set<String> queryTagAutocompleteValues(TagType tagType, String tagKey, int limit, Duration duration) {
        List<String> tables = this.tableHelper.getTablesForRead("tag_autocomplete", duration.getStartTimeBucket(), duration.getEndTimeBucket());
        HashSet<String> results = new HashSet<String>();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQLForQueryValues(tagType, tagKey, limit, duration, table);
            this.jdbcClient.executeQuery(sqlAndParameters.sql(), resultSet -> {
                while (resultSet.next()) {
                    results.add(resultSet.getString("tag_value"));
                }
                return null;
            }, sqlAndParameters.parameters());
        }
        return results;
    }

    protected SQLAndParameters buildSQLForQueryValues(TagType tagType, String tagKey, int limit, Duration duration, String table) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> condition = new ArrayList<Object>(3);
        sql.append("select * from ").append(table).append(" where ");
        sql.append("tag_key").append(" = ?");
        condition.add(tagKey);
        this.appendTagAutocompleteCondition(tagType, duration, sql, condition);
        sql.append(" limit ").append(limit);
        return new SQLAndParameters(sql.toString(), condition);
    }

    private void appendTagAutocompleteCondition(TagType tagType, Duration duration, StringBuilder sql, List<Object> condition) {
        long startSecondTB = 0L;
        long endSecondTB = 0L;
        if (Objects.nonNull(duration)) {
            startSecondTB = duration.getStartTimeBucketInSec();
            endSecondTB = duration.getEndTimeBucketInSec();
        }
        long startTB = startSecondTB / 1000000L * 10000L;
        long endTB = endSecondTB / 1000000L * 10000L + 2359L;
        sql.append(" and ");
        sql.append("tag_type").append(" = ?");
        condition.add(tagType.name());
        if (startTB > 0L) {
            sql.append(" and ");
            sql.append("time_bucket").append(">=?");
            condition.add(startTB);
        }
        if (endTB > 0L) {
            sql.append(" and ");
            sql.append("time_bucket").append("<=?");
            condition.add(endTB);
        }
    }

    @Generated
    public JDBCTagAutoCompleteQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

