/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import com.google.common.base.Strings;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TraceScopeCondition;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.SQLAndParameters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCLogQueryDAO
implements ILogQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDBCLogQueryDAO.class);
    private final JDBCClient jdbcClient;
    private final ModuleManager manager;
    private final TableHelper tableHelper;
    private Set<String> searchableTagKeys;

    public Logs queryLogs(String serviceId, String serviceInstanceId, String endpointId, TraceScopeCondition relatedTrace, Order queryOrder, int from, int limit, Duration duration, List<Tag> tags, List<String> keywordsOfContent, List<String> excludingKeywordsOfContent) {
        if (this.searchableTagKeys == null) {
            ConfigService configService = (ConfigService)this.manager.find("core").provider().getService(ConfigService.class);
            this.searchableTagKeys = new HashSet<String>(Arrays.asList(configService.getSearchableLogsTags().split(",")));
        }
        if (tags != null && !this.searchableTagKeys.containsAll(tags.stream().map(Tag::getKey).collect(Collectors.toSet()))) {
            log.warn("Searching tags that are not searchable: {}", tags.stream().map(Tag::getKey).filter(Predicate.not(this.searchableTagKeys::contains)).collect(Collectors.toSet()));
            return new Logs();
        }
        List<String> tables = this.tableHelper.getTablesForRead("log", duration.getStartTimeBucket(), duration.getEndTimeBucket());
        ArrayList logs = new ArrayList();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQL(serviceId, serviceInstanceId, endpointId, relatedTrace, queryOrder, from, limit, duration, tags, keywordsOfContent, excludingKeywordsOfContent, table);
            logs.addAll((Collection)this.jdbcClient.executeQuery(sqlAndParameters.sql(), this::parseResults, sqlAndParameters.parameters()));
        }
        Comparator<Log> comparator = Order.ASC.equals((Object)queryOrder) ? Comparator.comparing(Log::getTimestamp) : Comparator.comparing(Log::getTimestamp).reversed();
        return new Logs(logs.stream().sorted(comparator).skip(from).limit(limit).collect(Collectors.toList()));
    }

    protected ArrayList<Log> parseResults(ResultSet resultSet) throws SQLException {
        ArrayList<Log> logs = new ArrayList<Log>();
        while (resultSet.next()) {
            Log log = new Log();
            log.setServiceId(resultSet.getString("service_id"));
            log.setServiceInstanceId(resultSet.getString("service_instance_id"));
            log.setEndpointId(resultSet.getString("endpoint_id"));
            if (log.getEndpointId() != null) {
                log.setEndpointName(IDManager.EndpointID.analysisId((String)log.getEndpointId()).getEndpointName());
            }
            log.setTraceId(resultSet.getString("trace_id"));
            log.setTimestamp(Long.valueOf(resultSet.getLong("timestamp")));
            log.setContentType(ContentType.instanceOf((int)resultSet.getInt("content_type")));
            log.setContent(resultSet.getString("content"));
            String dataBinaryBase64 = resultSet.getString("tags_raw_data");
            if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                this.parserDataBinary(dataBinaryBase64, log.getTags());
            }
            logs.add(log);
        }
        return logs;
    }

    protected SQLAndParameters buildSQL(String serviceId, String serviceInstanceId, String endpointId, TraceScopeCondition relatedTrace, Order queryOrder, int from, int limit, Duration duration, List<Tag> tags, List<String> keywordsOfContent, List<String> excludingKeywordsOfContent, String table) {
        int i;
        long startSecondTB = 0L;
        long endSecondTB = 0L;
        if (Objects.nonNull(duration)) {
            startSecondTB = duration.getStartTimeBucketInSec();
            endSecondTB = duration.getEndTimeBucketInSec();
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(10);
        sql.append("select * from ").append(table);
        long timeBucket = TableHelper.getTimeBucket(table);
        String tagTable = TableHelper.getTable("log_tag", timeBucket);
        if (!CollectionUtils.isEmpty(tags)) {
            for (i = 0; i < tags.size(); ++i) {
                sql.append(" inner join ").append(tagTable).append(" ");
                sql.append(tagTable + i);
                sql.append(" on ").append(table).append(".").append("id").append(" = ");
                sql.append(tagTable + i).append(".").append("id");
            }
        }
        sql.append(" where ");
        sql.append("table_name").append(" = ?");
        parameters.add("log");
        if (startSecondTB != 0L && endSecondTB != 0L) {
            sql.append(" and ").append(table).append(".").append("time_bucket").append(" >= ?");
            parameters.add(startSecondTB);
            sql.append(" and ").append(table).append(".").append("time_bucket").append(" <= ?");
            parameters.add(endSecondTB);
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            sql.append(" and ").append(table).append(".").append("service_id").append(" = ?");
            parameters.add(serviceId);
        }
        if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
            sql.append(" and ").append("service_instance_id").append(" = ?");
            parameters.add(serviceInstanceId);
        }
        if (StringUtil.isNotEmpty((String)endpointId)) {
            sql.append(" and ").append("endpoint_id").append(" = ?");
            parameters.add(endpointId);
        }
        if (Objects.nonNull(relatedTrace)) {
            if (StringUtil.isNotEmpty((String)relatedTrace.getTraceId())) {
                sql.append(" and ").append("trace_id").append(" = ?");
                parameters.add(relatedTrace.getTraceId());
            }
            if (StringUtil.isNotEmpty((String)relatedTrace.getSegmentId())) {
                sql.append(" and ").append("trace_segment_id").append(" = ?");
                parameters.add(relatedTrace.getSegmentId());
            }
            if (Objects.nonNull(relatedTrace.getSpanId())) {
                sql.append(" and ").append("span_id").append(" = ?");
                parameters.add(relatedTrace.getSpanId());
            }
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            for (i = 0; i < tags.size(); ++i) {
                sql.append(" and ").append(tagTable + i).append(".");
                sql.append("tags").append(" = ?");
                parameters.add(tags.get(i).toString());
            }
        }
        sql.append(" order by ").append("timestamp").append(" ").append(Order.DES.equals((Object)queryOrder) ? "desc" : "asc");
        sql.append(" limit ").append(from + limit);
        return new SQLAndParameters(sql.toString(), parameters);
    }

    @Generated
    public JDBCLogQueryDAO(JDBCClient jdbcClient, ModuleManager manager, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.manager = manager;
        this.tableHelper = tableHelper;
    }
}

