/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.sql.ResultSet;
import java.time.Clock;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.SQLDatabaseModelExtension;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLBuilder;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.JDBCTableInstaller;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCHistoryDeleteDAO
implements IHistoryDeleteDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDBCHistoryDeleteDAO.class);
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;
    private final JDBCTableInstaller modelInstaller;
    private final Clock clock;
    private final Map<String, Long> lastDeletedTimeBucket = new ConcurrentHashMap<String, Long>();

    public void deleteHistory(Model model, String timeBucketColumnName, int ttl) {
        long endTimeBucket = TimeBucket.getTimeBucket((long)(this.clock.millis() + TimeUnit.DAYS.toMillis(1L)), (DownSampling)DownSampling.Day);
        long startTimeBucket = TimeBucket.getTimeBucket((long)(this.clock.millis() - TimeUnit.DAYS.toMillis(ttl)), (DownSampling)DownSampling.Day);
        log.info("Deleting history data, ttl: {}, now: {}. Keep [{}, {}]", new Object[]{ttl, this.clock.millis(), startTimeBucket, endTimeBucket});
        long deadline = Long.parseLong(new DateTime().minusDays(ttl).toString("yyyyMMdd"));
        Long lastSuccessDeadline = this.lastDeletedTimeBucket.getOrDefault(model.getName(), 0L);
        if (deadline <= lastSuccessDeadline) {
            if (log.isDebugEnabled()) {
                log.debug("The deadline {} is less than the last success deadline {}, skip deleting history data", (Object)deadline, (Object)lastSuccessDeadline);
            }
            return;
        }
        List<String> ttlTables = this.tableHelper.getTablesInTimeBucketRange(model.getName(), startTimeBucket, endTimeBucket);
        HashSet<String> tablesToDrop = new HashSet<String>();
        String tableName = TableHelper.getTableName(model);
        try (Iterator conn = this.jdbcClient.getConnection();
             ResultSet result = conn.getMetaData().getTables(conn.getCatalog(), null, tableName + "%", new String[]{"TABLE"});){
            while (result.next()) {
                tablesToDrop.add(result.getString("TABLE_NAME"));
            }
        }
        ttlTables.forEach(tablesToDrop::remove);
        tablesToDrop.removeIf(it -> !it.matches(tableName + "_\\d{8}$"));
        for (String table : tablesToDrop) {
            SQLBuilder dropSql = new SQLBuilder("drop table if exists ").append(table);
            this.jdbcClient.executeUpdate(dropSql.toString(), new Object[0]);
        }
        for (String table : tablesToDrop) {
            long timeBucket = TableHelper.getTimeBucket(table);
            for (SQLDatabaseModelExtension.AdditionalTable additionalTable : model.getSqlDBModelExtension().getAdditionalTables().values()) {
                String additionalTableToDrop = TableHelper.getTable(additionalTable.getName(), timeBucket);
                SQLBuilder dropSql = new SQLBuilder("drop table if exists ").append(additionalTableToDrop);
                this.jdbcClient.executeUpdate(dropSql.toString(), new Object[0]);
            }
        }
        long nextTimeBucket = TimeBucket.getTimeBucket((long)(this.clock.millis() + TimeUnit.DAYS.toMillis(1L)), (DownSampling)DownSampling.Day);
        this.modelInstaller.createTable(model, nextTimeBucket);
        this.lastDeletedTimeBucket.put(model.getName(), deadline);
    }

    @Generated
    public JDBCHistoryDeleteDAO(JDBCClient jdbcClient, TableHelper tableHelper, JDBCTableInstaller modelInstaller, Clock clock) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
        this.modelInstaller = modelInstaller;
        this.clock = clock;
    }
}

